/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightingAwareElementDescriptor;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlInspectionGroupNames;
import com.intellij.codeInspection.XmlQuickFixFactory;
import com.intellij.codeInspection.htmlInspections.AddHtmlTagOrAttributeToCustomsIntention;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.codeInspection.htmlInspections.XmlEntitiesInspection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RequiredAttributesInspectionBase
extends HtmlLocalInspectionTool
implements XmlEntitiesInspection {
    @NonNls
    public static final Key<InspectionProfileEntry> SHORT_NAME_KEY = Key.create((String)"RequiredAttributes");
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.htmlInspections.RequiredAttributesInspection");
    public String myAdditionalRequiredHtmlAttributes = "";

    private static String appendName(String toAppend, String text) {
        toAppend = !toAppend.isEmpty() ? toAppend + "," + text : text;
        return toAppend;
    }

    @NotNull
    public String getGroupDisplayName() {
        return XmlInspectionGroupNames.HTML_INSPECTIONS;
    }

    @NotNull
    public String getDisplayName() {
        return InspectionsBundle.message((String)"inspection.required.attributes.display.name", (Object[])new Object[0]);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "RequiredAttributes";
    }

    @Override
    public String getAdditionalEntries() {
        return this.myAdditionalRequiredHtmlAttributes;
    }

    @Override
    public void addEntry(String text) {
        this.myAdditionalRequiredHtmlAttributes = RequiredAttributesInspectionBase.appendName(this.getAdditionalEntries(), text);
    }

    public static LocalQuickFix getIntentionAction(String name) {
        return new AddHtmlTagOrAttributeToCustomsIntention(SHORT_NAME_KEY, name, XmlBundle.message((String)"add.optional.html.attribute", (Object[])new Object[]{name}));
    }

    @Override
    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        String name = tag.getName();
        XmlElementDescriptor elementDescriptor = XmlUtil.getDescriptorFromContext(tag);
        if (elementDescriptor instanceof AnyXmlElementDescriptor || elementDescriptor == null) {
            elementDescriptor = tag.getDescriptor();
        }
        if (elementDescriptor == null) {
            return;
        }
        if (elementDescriptor instanceof XmlHighlightingAwareElementDescriptor && !((XmlHighlightingAwareElementDescriptor)elementDescriptor).shouldCheckRequiredAttributes()) {
            return;
        }
        XmlAttributeDescriptor[] attributeDescriptors = elementDescriptor.getAttributesDescriptors(tag);
        HashSet<String> requiredAttributes = null;
        for (XmlAttributeDescriptor attribute : attributeDescriptors) {
            if (attribute == null || !attribute.isRequired()) continue;
            if (requiredAttributes == null) {
                requiredAttributes = new HashSet<String>();
            }
            requiredAttributes.add(attribute.getName((PsiElement)tag));
        }
        if (requiredAttributes != null) {
            for (String attrName : requiredAttributes) {
                if (RequiredAttributesInspectionBase.hasAttribute(tag, attrName) || XmlExtension.getExtension(tag.getContainingFile()).isRequiredAttributeImplicitlyPresent(tag, attrName)) continue;
                LocalQuickFixAndIntentionActionOnPsiElement insertRequiredAttributeIntention = isOnTheFly ? XmlQuickFixFactory.getInstance().insertRequiredAttributeFix(tag, attrName, new String[0]) : null;
                String localizedMessage = XmlErrorMessages.message("element.doesnt.have.required.attribute", name, attrName);
                this.reportOneTagProblem(tag, attrName, localizedMessage, (LocalQuickFix)insertRequiredAttributeIntention, holder, RequiredAttributesInspectionBase.getIntentionAction(attrName));
            }
        }
    }

    private static boolean hasAttribute(XmlTag tag, String attrName) {
        XmlAttribute attribute = tag.getAttribute(attrName);
        if (attribute == null) {
            return false;
        }
        if (attribute.getValueElement() != null) {
            return true;
        }
        if (!(tag instanceof HtmlTag)) {
            return false;
        }
        XmlAttributeDescriptor descriptor = attribute.getDescriptor();
        return descriptor != null && HtmlUtil.isBooleanAttribute(descriptor, (PsiElement)tag);
    }

    private void reportOneTagProblem(XmlTag tag, String name, @NotNull String localizedMessage, LocalQuickFix basicIntention, ProblemsHolder holder, LocalQuickFix addAttributeFix) {
        ProblemHighlightType highlightType;
        LocalQuickFix[] fixes;
        boolean htmlTag = false;
        if (tag instanceof HtmlTag) {
            htmlTag = true;
            if (RequiredAttributesInspectionBase.isAdditionallyDeclared(this.getAdditionalEntries(), name)) {
                return;
            }
        }
        if (htmlTag) {
            LocalQuickFix[] localQuickFixArray;
            if (basicIntention == null) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = addAttributeFix;
            } else {
                LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[2];
                localQuickFixArray3[0] = addAttributeFix;
                localQuickFixArray = localQuickFixArray3;
                localQuickFixArray3[1] = basicIntention;
            }
            fixes = localQuickFixArray;
            highlightType = XmlHighlightVisitor.isInjectedWithoutValidation((PsiElement)tag) ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        } else {
            LocalQuickFix[] localQuickFixArray;
            if (basicIntention == null) {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            } else {
                LocalQuickFix[] localQuickFixArray4 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray4;
                localQuickFixArray4[0] = basicIntention;
            }
            fixes = localQuickFixArray;
            highlightType = ProblemHighlightType.ERROR;
        }
        RequiredAttributesInspectionBase.addElementsForTag(tag, localizedMessage, highlightType, holder, fixes);
    }

    private static void addElementsForTag(XmlTag tag, String message, ProblemHighlightType error, ProblemsHolder holder, LocalQuickFix ... fixes) {
        RequiredAttributesInspectionBase.registerProblem(message, error, holder, XmlTagUtil.getStartTagNameElement((XmlTag)tag), fixes);
        RequiredAttributesInspectionBase.registerProblem(message, error, holder, XmlTagUtil.getEndTagNameElement((XmlTag)tag), fixes);
    }

    private static void registerProblem(String message, ProblemHighlightType error, ProblemsHolder holder, XmlToken start2, LocalQuickFix[] fixes) {
        if (start2 != null) {
            holder.registerProblem((PsiElement)start2, message, error, fixes);
        }
    }

    private static boolean isAdditionallyDeclared(String additional, String name) {
        if (!additional.contains(name = name.toLowerCase())) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(additional, ", ");
        while (tokenizer.hasMoreTokens()) {
            if (!name.equals(tokenizer.nextToken())) continue;
            return true;
        }
        return false;
    }
}

