/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.htmlInspections.RemoveExtraClosingTagIntentionAction;
import com.intellij.codeInspection.htmlInspections.RenameTagBeginOrEndIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlWrongClosingTagNameInspection
implements Annotator {
    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement instanceof XmlToken) {
            String message;
            PsiFile psiFile;
            PsiElement parent = psiElement.getParent();
            if (parent instanceof XmlTag) {
                XmlTag tag = (XmlTag)parent;
                XmlToken start2 = XmlTagUtil.getStartTagNameElement((XmlTag)tag);
                XmlToken endTagName = XmlTagUtil.getEndTagNameElement((XmlTag)tag);
                if (start2 == psiElement) {
                    PsiErrorElement errorElement;
                    if (endTagName != null && !(tag instanceof HtmlTag) && !tag.getName().equals(endTagName.getText())) {
                        XmlWrongClosingTagNameInspection.registerProblemStart(holder, tag, start2, endTagName);
                    } else if (!(endTagName != null || tag instanceof HtmlTag && HtmlUtil.isSingleHtmlTag(tag, true) || (endTagName = XmlWrongClosingTagNameInspection.findEndTagName(errorElement = (PsiErrorElement)PsiTreeUtil.getChildOfType((PsiElement)tag, PsiErrorElement.class))) == null)) {
                        XmlWrongClosingTagNameInspection.registerProblemStart(holder, tag, start2, endTagName);
                    }
                } else if (endTagName == psiElement && !(tag instanceof HtmlTag) && !tag.getName().equals(endTagName.getText())) {
                    XmlWrongClosingTagNameInspection.registerProblemEnd(holder, tag, endTagName);
                }
            } else if (parent instanceof PsiErrorElement && XmlTokenType.XML_NAME == ((XmlToken)psiElement).getTokenType() && (psiFile = psiElement.getContainingFile()) != null && (HTMLLanguage.INSTANCE == psiFile.getViewProvider().getBaseLanguage() || HTMLLanguage.INSTANCE == parent.getLanguage()) && (message = XmlErrorMessages.message("xml.parsing.closing.tag.matches.nothing", new Object[0])).equals(((PsiErrorElement)parent).getErrorDescription()) && psiFile.getContext() == null) {
                Annotation annotation = holder.createWarningAnnotation(parent, message);
                annotation.registerFix((IntentionAction)new RemoveExtraClosingTagIntentionAction());
            }
        }
    }

    private static void registerProblemStart(@NotNull AnnotationHolder holder, @NotNull XmlTag tag, @NotNull XmlToken start2, @NotNull XmlToken end) {
        ASTNode contextNode;
        ParserDefinition parserDefinition;
        PsiElement context = tag.getContainingFile().getContext();
        if (context != null && (parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(context.getLanguage())) != null && (contextNode = context.getNode()) != null && contextNode.getChildren(parserDefinition.getStringLiteralElements()) != null) {
            return;
        }
        String tagName = tag.getName();
        String endTokenText = end.getText();
        RenameTagBeginOrEndIntentionAction renameEndAction = new RenameTagBeginOrEndIntentionAction(tagName, endTokenText, false);
        RenameTagBeginOrEndIntentionAction renameStartAction = new RenameTagBeginOrEndIntentionAction(endTokenText, tagName, true);
        Annotation annotation = holder.createErrorAnnotation((PsiElement)start2, XmlErrorMessages.message("tag.has.wrong.closing.tag.name", new Object[0]));
        annotation.registerFix((IntentionAction)renameEndAction);
        annotation.registerFix((IntentionAction)renameStartAction);
    }

    private static void registerProblemEnd(@NotNull AnnotationHolder holder, @NotNull XmlTag tag, @NotNull XmlToken end) {
        ASTNode contextNode;
        ParserDefinition parserDefinition;
        PsiElement context = tag.getContainingFile().getContext();
        if (context != null && (parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(context.getLanguage())) != null && (contextNode = context.getNode()) != null && contextNode.getChildren(parserDefinition.getStringLiteralElements()) != null) {
            return;
        }
        String tagName = tag.getName();
        String endTokenText = end.getText();
        RenameTagBeginOrEndIntentionAction renameEndAction = new RenameTagBeginOrEndIntentionAction(tagName, endTokenText, false);
        RenameTagBeginOrEndIntentionAction renameStartAction = new RenameTagBeginOrEndIntentionAction(endTokenText, tagName, true);
        Annotation annotation = holder.createErrorAnnotation((PsiElement)end, XmlErrorMessages.message("wrong.closing.tag.name", new Object[0]));
        annotation.registerFix((IntentionAction)new RemoveExtraClosingTagIntentionAction());
        annotation.registerFix((IntentionAction)renameEndAction);
        annotation.registerFix((IntentionAction)renameStartAction);
    }

    @Nullable
    static XmlToken findEndTagName(@Nullable PsiErrorElement element) {
        ASTNode current;
        if (element == null) {
            return null;
        }
        ASTNode astNode = element.getNode();
        if (astNode == null) {
            return null;
        }
        ASTNode prev2 = current = astNode.getLastChildNode();
        while (current != null) {
            IElementType elementType = prev2.getElementType();
            if ((elementType == XmlTokenType.XML_NAME || elementType == XmlTokenType.XML_TAG_NAME) && current.getElementType() == XmlTokenType.XML_END_TAG_START) {
                return (XmlToken)prev2.getPsi();
            }
            prev2 = current;
            current = current.getTreePrev();
        }
        return null;
    }
}

