/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.offlineViewer;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.CommonProblemDescriptorImpl;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ModuleProblemDescriptorImpl;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.actions.RunInspectionAction;
import com.intellij.codeInspection.ex.BatchModeDescriptorsUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.UnfairLocalInspectionTool;
import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OfflineDescriptorResolveResult {
    private static final Logger LOG = Logger.getInstance(OfflineDescriptorResolveResult.class);
    private final RefEntity myResolvedEntity;
    private final CommonProblemDescriptor myResolvedDescriptor;
    private volatile boolean myExcluded;

    private OfflineDescriptorResolveResult(RefEntity resolvedEntity, CommonProblemDescriptor resolvedDescriptor) {
        this.myResolvedEntity = resolvedEntity;
        this.myResolvedDescriptor = resolvedDescriptor;
    }

    @Nullable
    RefEntity getResolvedEntity() {
        return this.myResolvedEntity;
    }

    @Nullable
    CommonProblemDescriptor getResolvedDescriptor() {
        return this.myResolvedDescriptor;
    }

    public boolean isExcluded() {
        return this.myExcluded;
    }

    public void setExcluded(boolean excluded) {
        this.myExcluded = excluded;
    }

    @NotNull
    static OfflineDescriptorResolveResult resolve(@NotNull OfflineProblemDescriptor descriptor, @NotNull InspectionToolWrapper wrapper2, @NotNull InspectionToolPresentation presentation) {
        RefEntity element = descriptor.getRefElement(presentation.getContext().getRefManager());
        CommonProblemDescriptor resolvedDescriptor = (CommonProblemDescriptor)ReadAction.compute(() -> OfflineDescriptorResolveResult.createDescriptor(element, descriptor, wrapper2, presentation));
        return new OfflineDescriptorResolveResult(element, resolvedDescriptor);
    }

    @Nullable
    private static CommonProblemDescriptor createDescriptor(@Nullable RefEntity element, @NotNull OfflineProblemDescriptor offlineDescriptor, @NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionToolPresentation presentation) {
        if (toolWrapper instanceof GlobalInspectionToolWrapper) {
            CommonProblemDescriptor descriptor;
            LocalInspectionToolWrapper localTool = ((GlobalInspectionToolWrapper)toolWrapper).getSharedLocalInspectionToolWrapper();
            if (localTool != null && (descriptor = OfflineDescriptorResolveResult.createDescriptor(element, offlineDescriptor, localTool, presentation)) != null) {
                return descriptor;
            }
            return OfflineDescriptorResolveResult.createRerunGlobalToolDescriptor((GlobalInspectionToolWrapper)toolWrapper, element, offlineDescriptor);
        }
        Project project = presentation.getContext().getProject();
        InspectionManager inspectionManager = InspectionManager.getInstance((Project)project);
        if (toolWrapper instanceof LocalInspectionToolWrapper && !(toolWrapper.getTool() instanceof UnfairLocalInspectionTool) && element instanceof RefElement) {
            ProblemDescriptor descriptor;
            PsiElement psiElement = ((RefElement)element).getPsiElement();
            if (psiElement != null && (descriptor = (ProblemDescriptor)ProgressManager.getInstance().runProcess(() -> OfflineDescriptorResolveResult.runLocalTool(psiElement, offlineDescriptor, (LocalInspectionToolWrapper)toolWrapper, inspectionManager, presentation.getContext()), (ProgressIndicator)new DaemonProgressIndicator())) != null) {
                return descriptor;
            }
            return null;
        }
        CommonProblemDescriptor descriptor = OfflineDescriptorResolveResult.createProblemDescriptorFromOfflineDescriptor(element, offlineDescriptor, QuickFix.EMPTY_ARRAY, project);
        QuickFix[] quickFixes = OfflineDescriptorResolveResult.getFixes(descriptor, element, presentation, offlineDescriptor.getHints());
        if (quickFixes != null) {
            descriptor = OfflineDescriptorResolveResult.createProblemDescriptorFromOfflineDescriptor(element, offlineDescriptor, quickFixes, project);
        }
        return descriptor;
    }

    @NotNull
    private static CommonProblemDescriptor createProblemDescriptorFromOfflineDescriptor(@Nullable RefEntity element, @NotNull OfflineProblemDescriptor offlineDescriptor, @NotNull QuickFix[] fixes, @NotNull Project project) {
        InspectionManager inspectionManager = InspectionManager.getInstance((Project)project);
        if (element instanceof RefElement) {
            return new ProblemDescriptorBackedByRefElement((RefElement)element, offlineDescriptor, fixes);
        }
        if (element instanceof RefModule) {
            return inspectionManager.createProblemDescriptor(offlineDescriptor.getDescription(), ((RefModule)element).getModule(), fixes);
        }
        return inspectionManager.createProblemDescriptor(offlineDescriptor.getDescription(), fixes);
    }

    private static ProblemDescriptor runLocalTool(@NotNull PsiElement psiElement, @NotNull OfflineProblemDescriptor offlineProblemDescriptor, @NotNull LocalInspectionToolWrapper toolWrapper, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContextImpl context) {
        PsiFile containingFile = psiElement.getContainingFile();
        ProblemsHolder holder = new ProblemsHolder(inspectionManager, containingFile, false);
        LocalInspectionTool localTool = (LocalInspectionTool)toolWrapper.getTool();
        TextRange textRange = psiElement.getTextRange();
        LOG.assertTrue(textRange != null, (Object)("text range muse be not null here; isValid = " + psiElement.isValid() + ", isPhysical = " + psiElement.isPhysical() + ", containingFile = " + containingFile.getName() + ", inspection = " + toolWrapper.getShortName()));
        int startOffset = textRange.getStartOffset();
        int endOffset = textRange.getEndOffset();
        LocalInspectionToolSession session2 = new LocalInspectionToolSession(containingFile, startOffset, endOffset);
        final PsiElementVisitor visitor = localTool.buildVisitor(holder, true, session2);
        localTool.inspectionStarted(session2, false);
        PsiElement[] elementsInRange = OfflineDescriptorResolveResult.getElementsIntersectingRange(containingFile, startOffset, endOffset);
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)context.getProject());
        for (PsiElement element : elementsInRange) {
            List injectedPsiFiles = injectedLanguageManager.getInjectedPsiFiles(element);
            if (injectedPsiFiles != null) {
                for (Pair file2 : injectedPsiFiles) {
                    ((PsiElement)file2.getFirst()).accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                        public void visitElement(PsiElement element) {
                            element.accept(visitor);
                            super.visitElement(element);
                        }
                    });
                }
            }
            element.accept(visitor);
        }
        localTool.inspectionFinished(session2, holder);
        if (holder.hasResults()) {
            List list2 = holder.getResults();
            int idx = offlineProblemDescriptor.getProblemIndex();
            int curIdx = 0;
            for (ProblemDescriptor descriptor : list2) {
                PsiNamedElement member = BatchModeDescriptorsUtil.getContainerElement(descriptor.getPsiElement(), localTool, context);
                if (!(psiElement instanceof PsiFile) && !psiElement.equals(member)) continue;
                if (curIdx == idx) {
                    return descriptor;
                }
                ++curIdx;
            }
        }
        return null;
    }

    @NotNull
    private static PsiElement[] getElementsIntersectingRange(PsiFile file2, int startOffset, int endOffset) {
        FileViewProvider viewProvider = file2.getViewProvider();
        LinkedHashSet<PsiElement> result2 = new LinkedHashSet<PsiElement>();
        for (Language language : viewProvider.getLanguages()) {
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (!HighlightingLevelManager.getInstance(file2.getProject()).shouldInspect((PsiElement)psiRoot)) continue;
            result2.addAll(CollectHighlightsUtil.getElementsInRange((PsiElement)psiRoot, startOffset, endOffset, true));
        }
        return PsiUtilCore.toPsiElementArray(result2);
    }

    @Nullable
    private static QuickFix[] getFixes(@NotNull CommonProblemDescriptor descriptor, RefEntity entity, InspectionToolPresentation presentation, List<String> hints) {
        ArrayList fixes = new ArrayList(hints == null ? 1 : hints.size());
        if (hints == null) {
            OfflineDescriptorResolveResult.addFix(descriptor, entity, fixes, null, presentation);
        } else {
            for (String hint : hints) {
                OfflineDescriptorResolveResult.addFix(descriptor, entity, fixes, hint, presentation);
            }
        }
        return fixes.isEmpty() ? null : fixes.toArray(QuickFix.EMPTY_ARRAY);
    }

    private static void addFix(@NotNull CommonProblemDescriptor descriptor, RefEntity entity, List<? super QuickFix> fixes, String hint, InspectionToolPresentation presentation) {
        ContainerUtil.addAllNotNull(fixes, (Object[])new QuickFix[]{presentation.findQuickFixes(descriptor, entity, hint)});
    }

    private static CommonProblemDescriptor createRerunGlobalToolDescriptor(final @NotNull GlobalInspectionToolWrapper wrapper2, final @Nullable RefEntity entity, OfflineProblemDescriptor offlineDescriptor) {
        QuickFix rerunFix = new QuickFix(){

            @Nls
            @NotNull
            public String getFamilyName() {
                return "Rerun '" + wrapper2.getDisplayName() + "' inspection";
            }

            public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor descriptor) {
                VirtualFile file2 = null;
                if (entity != null && entity.isValid() && entity instanceof RefElement) {
                    file2 = ((RefElement)entity).getPointer().getVirtualFile();
                }
                PsiFile psiFile = null;
                if (file2 != null) {
                    psiFile = PsiManager.getInstance((Project)project).findFile(file2);
                }
                RunInspectionAction.runInspection(project, wrapper2.getShortName(), file2, null, psiFile);
            }

            public boolean startInWriteAction() {
                return false;
            }
        };
        List hints = offlineDescriptor.getHints();
        if (hints != null && entity instanceof RefModule) {
            List<QuickFix> fixes = hints.stream().map(hint -> ((GlobalInspectionTool)wrapper2.getTool()).getQuickFix(hint)).filter(f -> f != null).collect(Collectors.toList());
            return new ModuleProblemDescriptorImpl((QuickFix[])ArrayUtil.append((Object[])fixes.toArray(QuickFix.EMPTY_ARRAY), (Object)rerunFix), offlineDescriptor.getDescription(), ((RefModule)entity).getModule());
        }
        return new CommonProblemDescriptorImpl(new QuickFix[]{rerunFix}, offlineDescriptor.getDescription());
    }

    private static class ProblemDescriptorBackedByRefElement
    implements ProblemDescriptor {
        private final RefElement myElement;
        private final OfflineProblemDescriptor myOfflineProblemDescriptor;
        private final QuickFix[] myFixes;

        private ProblemDescriptorBackedByRefElement(RefElement element, OfflineProblemDescriptor descriptor, QuickFix[] fixes) {
            this.myElement = element;
            this.myOfflineProblemDescriptor = descriptor;
            this.myFixes = fixes;
        }

        public PsiElement getPsiElement() {
            return this.myElement.getPsiElement();
        }

        public PsiElement getStartElement() {
            return this.getPsiElement();
        }

        public PsiElement getEndElement() {
            return this.getPsiElement();
        }

        public TextRange getTextRangeInElement() {
            return null;
        }

        public int getLineNumber() {
            return 0;
        }

        @NotNull
        public ProblemHighlightType getHighlightType() {
            return ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        }

        public boolean isAfterEndOfLine() {
            return false;
        }

        public void setTextAttributes(TextAttributesKey key) {
        }

        @Nullable
        public ProblemGroup getProblemGroup() {
            return null;
        }

        public void setProblemGroup(@Nullable ProblemGroup problemGroup) {
        }

        public boolean showTooltip() {
            return false;
        }

        @NotNull
        public String getDescriptionTemplate() {
            return this.myOfflineProblemDescriptor.getDescription();
        }

        @Nullable
        public QuickFix[] getFixes() {
            return this.myFixes;
        }
    }
}

