/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.offlineViewer;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.codeInspection.offlineViewer.OfflineDescriptorResolveResult;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeModel;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.FactoryMap;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OfflineInspectionRVContentProvider
extends InspectionRVContentProvider {
    private final Map<String, Map<String, Set<OfflineProblemDescriptor>>> myContent;
    private final Map<String, Map<OfflineProblemDescriptor, OfflineDescriptorResolveResult>> myResolvedDescriptor = FactoryMap.create(key -> new THashMap());

    public OfflineInspectionRVContentProvider(@NotNull Map<String, Map<String, Set<OfflineProblemDescriptor>>> content) {
        this.myContent = content;
    }

    @Override
    public boolean checkReportedProblems(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionToolWrapper toolWrapper) {
        Map<String, Set<OfflineProblemDescriptor>> content = this.getFilteredContent(context, toolWrapper);
        return content != null && !content.values().isEmpty();
    }

    @Override
    public Iterable<? extends ScopeToolState> getTools(Tools tools) {
        return Collections.singletonList(tools.getDefaultState());
    }

    @Override
    @NotNull
    public QuickFixAction[] getCommonQuickFixes(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionTree tree) {
        GlobalInspectionContextImpl context = tree.getContext();
        InspectionToolPresentation presentation = context.getPresentation(toolWrapper);
        return OfflineInspectionRVContentProvider.getCommonFixes(presentation, tree.getSelectedDescriptors());
    }

    @Override
    public boolean isContentLoaded() {
        return false;
    }

    @Override
    public void appendToolNodeContent(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionToolWrapper wrapper2, @NotNull InspectionTreeNode parentNode, boolean showStructure, boolean groupBySeverity, @NotNull Map<String, Set<RefEntity>> contents, @NotNull Function<? super RefEntity, CommonProblemDescriptor[]> problems) {
        Map filteredContent = this.getFilteredContent(context, wrapper2);
        InspectionResultsView view = context.getView();
        if (filteredContent != null && !filteredContent.values().isEmpty()) {
            this.buildTree(context, filteredContent, wrapper2, descriptor -> {
                RefEntity element = descriptor.getRefElement(context.getRefManager());
                return new InspectionRVContentProvider.RefEntityContainer<OfflineProblemDescriptor>(element, new OfflineProblemDescriptor[]{descriptor}){

                    @Override
                    @Nullable
                    protected String getModuleName() {
                        String module = super.getModuleName();
                        return module == null ? descriptor.getModuleName() : module;
                    }
                };
            }, showStructure, parentNode, view.getTree().getInspectionTreeModel());
        }
    }

    @Nullable
    private Map<String, Set<OfflineProblemDescriptor>> getFilteredContent(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionToolWrapper toolWrapper) {
        Map<String, Set<OfflineProblemDescriptor>> content = this.myContent.get(toolWrapper.getShortName());
        if (content == null) {
            return null;
        }
        if (context.getUIOptions().FILTER_RESOLVED_ITEMS) {
            HashMap<String, Set<OfflineProblemDescriptor>> current = new HashMap<String, Set<OfflineProblemDescriptor>>(content);
            content = null;
            Map<OfflineProblemDescriptor, OfflineDescriptorResolveResult> resolvedDescriptors = this.myResolvedDescriptor.get(toolWrapper.getShortName());
            resolvedDescriptors.forEach((descriptor, descriptorResolveResult) -> {
                RefEntity entity;
                if (descriptorResolveResult.isExcluded() && (entity = descriptorResolveResult.getResolvedEntity()) != null) {
                    OfflineInspectionRVContentProvider.excludeProblem(entity.getExternalName(), current);
                }
            });
            InspectionToolPresentation presentation = context.getPresentation(toolWrapper);
            for (RefEntity refEntity : presentation.getResolvedElements()) {
                if (!(refEntity instanceof RefElement)) continue;
                OfflineInspectionRVContentProvider.excludeProblem(refEntity.getExternalName(), current);
            }
            return current;
        }
        return content;
    }

    private static void excludeProblem(String externalName, Map<String, Set<OfflineProblemDescriptor>> content) {
        Iterator<String> iter = content.keySet().iterator();
        while (iter.hasNext()) {
            String packageName = iter.next();
            HashSet excluded = new HashSet(content.get(packageName));
            Iterator it = excluded.iterator();
            while (it.hasNext()) {
                OfflineProblemDescriptor ex = (OfflineProblemDescriptor)it.next();
                if (!Comparing.strEqual((String)ex.getFQName(), (String)externalName)) continue;
                it.remove();
            }
            if (excluded.isEmpty()) {
                iter.remove();
                continue;
            }
            content.put(packageName, excluded);
        }
    }

    @Override
    protected void appendDescriptor(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionRVContentProvider.RefEntityContainer container, @NotNull InspectionTreeNode parent) {
        InspectionToolPresentation presentation = context.getPresentation(toolWrapper);
        InspectionTreeModel model = context.getView().getTree().getInspectionTreeModel();
        for (OfflineProblemDescriptor descriptor : (OfflineProblemDescriptor[])container.getDescriptors()) {
            OfflineDescriptorResolveResult resolveResult = this.myResolvedDescriptor.get(toolWrapper.getShortName()).computeIfAbsent(descriptor, d -> OfflineDescriptorResolveResult.resolve(d, toolWrapper, presentation));
            RefEntity resolvedEntity = resolveResult.getResolvedEntity();
            CommonProblemDescriptor resolvedDescriptor = resolveResult.getResolvedDescriptor();
            if (resolvedEntity != null && resolvedDescriptor != null) {
                presentation.getProblemElements().put(resolvedEntity, (CommonProblemDescriptor[])new CommonProblemDescriptor[]{resolvedDescriptor});
                model.createProblemDescriptorNode(resolvedEntity, resolvedDescriptor, presentation, parent);
                continue;
            }
            model.createOfflineProblemDescriptorNode(descriptor, resolveResult, presentation, parent);
        }
    }
}

