/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.offlineViewer;

import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.codeInspection.offlineViewer.OfflineDescriptorResolveResult;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class OfflineProblemDescriptorNode
extends ProblemDescriptionNode {
    private final OfflineDescriptorResolveResult myDescriptorResolveResult;
    private final OfflineProblemDescriptor myOfflineDescriptor;

    public OfflineProblemDescriptorNode(OfflineDescriptorResolveResult descriptorResolveResult, @NotNull InspectionToolPresentation presentation, @NotNull OfflineProblemDescriptor offlineDescriptor, @NotNull InspectionTreeNode parent) {
        super(descriptorResolveResult.getResolvedEntity(), descriptorResolveResult.getResolvedDescriptor(), presentation, () -> ((OfflineProblemDescriptor)offlineDescriptor).getLine(), parent);
        this.myDescriptorResolveResult = descriptorResolveResult;
        this.myOfflineDescriptor = offlineDescriptor;
    }

    @Override
    @NotNull
    protected String calculatePresentableName() {
        String presentableName = super.calculatePresentableName();
        return presentableName.isEmpty() && this.getDescriptor() == null ? ProblemDescriptorUtil.unescapeTags(StringUtil.notNullize((String)this.myOfflineDescriptor.getDescription())).trim() : presentableName;
    }

    @Override
    protected boolean calculateIsValid() {
        return false;
    }

    @Override
    public void excludeElement() {
        this.myDescriptorResolveResult.setExcluded(true);
    }

    @Override
    public void amnestyElement() {
        this.myDescriptorResolveResult.setExcluded(false);
    }

    @Override
    public boolean isExcluded() {
        return this.myDescriptorResolveResult.isExcluded();
    }
}

