/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefDirectory;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.reference.WritableRefElement;
import com.intellij.codeInspection.reference.WritableRefEntity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefDirectoryImpl
extends RefElementImpl
implements RefDirectory {
    private volatile RefModule myRefModule;

    protected RefDirectoryImpl(PsiDirectory psiElement, RefManager refManager) {
        super(psiElement.getName(), (PsiElement)psiElement, refManager);
    }

    @Override
    protected void initialize() {
        WritableRefElement refElement;
        PsiDirectory psiElement = (PsiDirectory)ObjectUtils.tryCast((Object)this.getPsiElement(), PsiDirectory.class);
        LOG.assertTrue(psiElement != null);
        PsiDirectory parentDirectory = psiElement.getParentDirectory();
        if (parentDirectory != null && ProjectFileIndex.getInstance((Project)psiElement.getProject()).isInSourceContent(parentDirectory.getVirtualFile()) && (refElement = (WritableRefElement)this.getRefManager().getReference((PsiElement)parentDirectory)) != null) {
            refElement.add(this);
            return;
        }
        this.myRefModule = this.getRefManager().getRefModule(ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement));
        if (this.myRefModule != null) {
            ((WritableRefEntity)this.myRefModule).add(this);
            return;
        }
        ((WritableRefEntity)this.myManager.getRefProject()).add(this);
    }

    @Override
    public void accept(@NotNull RefVisitor visitor) {
        ApplicationManager.getApplication().runReadAction(() -> visitor.visitDirectory((RefDirectory)this));
    }

    @Override
    public boolean isValid() {
        if (this.isDeleted()) {
            return false;
        }
        return (Boolean)ReadAction.compute(() -> {
            if (this.getRefManager().getProject().isDisposed()) {
                return false;
            }
            VirtualFile directory = this.getVirtualFile();
            return directory != null && directory.isValid();
        });
    }

    @Override
    @Nullable
    public RefModule getModule() {
        return this.myRefModule != null ? this.myRefModule : super.getModule();
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        return this.getName();
    }

    @Override
    public String getExternalName() {
        PsiElement element = this.getPsiElement();
        assert (element != null);
        return ((PsiDirectory)element).getVirtualFile().getPath();
    }
}

