/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.reference.WritableRefEntity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.util.BitUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RefEntityImpl
implements RefEntity,
WritableRefEntity {
    private volatile WritableRefEntity myOwner;
    protected List<RefEntity> myChildren;
    private final String myName;
    private Map<Key, Object> myUserMap;
    protected long myFlags;
    protected final RefManagerImpl myManager;

    protected RefEntityImpl(@NotNull String name, @NotNull RefManager manager) {
        this.myManager = (RefManagerImpl)manager;
        this.myName = this.myManager.internName(name);
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getQualifiedName() {
        return this.myName;
    }

    @NotNull
    public synchronized List<RefEntity> getChildren() {
        return (List)ObjectUtils.notNull(this.myChildren, (Object)ContainerUtil.emptyList());
    }

    public WritableRefEntity getOwner() {
        return this.myOwner;
    }

    @Override
    public void setOwner(@Nullable WritableRefEntity owner) {
        this.myOwner = owner;
    }

    @Override
    public synchronized void add(@NotNull RefEntity child2) {
        List<RefEntity> children2 = this.myChildren;
        if (children2 == null) {
            this.myChildren = children2 = new ArrayList<RefEntity>(1);
        }
        children2.add(child2);
        ((RefEntityImpl)child2).setOwner(this);
    }

    @Override
    public synchronized void removeChild(@NotNull RefEntity child2) {
        if (this.myChildren != null) {
            this.myChildren.remove(child2);
            ((WritableRefEntity)child2).setOwner(null);
        }
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        RefEntityImpl refEntityImpl = this;
        synchronized (refEntityImpl) {
            if (this.myUserMap == null) {
                return null;
            }
            return (T)this.myUserMap.get(key);
        }
    }

    public void accept(@NotNull RefVisitor refVisitor) {
        ApplicationManager.getApplication().runReadAction(() -> refVisitor.visitElement((RefEntity)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void putUserData(@NotNull Key<T> key, T value) {
        RefEntityImpl refEntityImpl = this;
        synchronized (refEntityImpl) {
            THashMap userMap = this.myUserMap;
            if (userMap == null) {
                if (value == null) {
                    return;
                }
                this.myUserMap = userMap = new THashMap();
            }
            if (value != null) {
                userMap.put(key, value);
            } else {
                userMap.remove(key);
                if (userMap.isEmpty()) {
                    this.myUserMap = null;
                }
            }
        }
    }

    public synchronized boolean checkFlag(long mask) {
        return BitUtil.isSet((long)this.myFlags, (long)mask);
    }

    public synchronized void setFlag(boolean value, long mask) {
        this.myFlags = BitUtil.set((long)this.myFlags, (long)mask, (boolean)value);
    }

    public String getExternalName() {
        return this.myName;
    }

    @NotNull
    public RefManagerImpl getRefManager() {
        return this.myManager;
    }
}

