/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.DescriptorComposer;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.actions.ExportHTMLAction;
import com.intellij.codeInspection.ui.util.SynchronizedBidiMultiMap;
import com.intellij.configurationStore.JbXmlOutputter;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultInspectionToolPresentation
implements InspectionToolPresentation {
    protected static final Logger LOG = Logger.getInstance(DefaultInspectionToolPresentation.class);
    @NotNull
    private final InspectionToolWrapper myToolWrapper;
    @NotNull
    protected final GlobalInspectionContextImpl myContext;
    private final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> myProblemElements = DefaultInspectionToolPresentation.createBidiMap();
    private final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> mySuppressedElements = DefaultInspectionToolPresentation.createBidiMap();
    private final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> myResolvedElements = DefaultInspectionToolPresentation.createBidiMap();
    private final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> myExcludedElements = DefaultInspectionToolPresentation.createBidiMap();
    protected final Map<String, Set<RefEntity>> myContents = Collections.synchronizedMap(new HashMap(1));
    private DescriptorComposer myComposer;
    private volatile boolean isDisposed;

    public DefaultInspectionToolPresentation(@NotNull InspectionToolWrapper toolWrapper, @NotNull GlobalInspectionContextImpl context) {
        this.myToolWrapper = toolWrapper;
        this.myContext = context;
    }

    public void resolveProblem(@NotNull CommonProblemDescriptor descriptor) {
        RefEntity entity = this.myProblemElements.removeValue(descriptor);
        if (entity != null) {
            this.myResolvedElements.put(entity, (CommonProblemDescriptor[])new CommonProblemDescriptor[]{descriptor});
        }
    }

    @Override
    public boolean isProblemResolved(@Nullable CommonProblemDescriptor descriptor) {
        return this.myResolvedElements.containsValue(descriptor);
    }

    @Override
    public boolean isProblemResolved(@Nullable RefEntity entity) {
        return this.myResolvedElements.containsKey(entity) && !this.myProblemElements.containsKey(entity);
    }

    @Override
    @NotNull
    public Collection<RefEntity> getResolvedElements() {
        return this.myResolvedElements.keys();
    }

    @Override
    @NotNull
    public CommonProblemDescriptor[] getResolvedProblems(@NotNull RefEntity entity) {
        return this.myResolvedElements.getOrDefault(entity, (CommonProblemDescriptor[])CommonProblemDescriptor.EMPTY_ARRAY);
    }

    @Override
    public void suppressProblem(@NotNull CommonProblemDescriptor descriptor) {
        this.mySuppressedElements.put(this.myProblemElements.removeValue(descriptor), (CommonProblemDescriptor[])new CommonProblemDescriptor[]{descriptor});
    }

    @Override
    public void suppressProblem(@NotNull RefEntity entity) {
        CommonProblemDescriptor[] removed = this.myProblemElements.remove(entity);
        if (removed != null) {
            this.mySuppressedElements.put(entity, (CommonProblemDescriptor[])removed);
        }
    }

    @Override
    public boolean isSuppressed(RefEntity element) {
        return this.mySuppressedElements.containsKey(element);
    }

    @Override
    public boolean isSuppressed(CommonProblemDescriptor descriptor) {
        return this.mySuppressedElements.containsValue(descriptor);
    }

    @Override
    @NotNull
    public CommonProblemDescriptor[] getSuppressedProblems(@NotNull RefEntity entity) {
        return this.mySuppressedElements.getOrDefault(entity, (CommonProblemDescriptor[])CommonProblemDescriptor.EMPTY_ARRAY);
    }

    @Override
    @Nullable
    public HighlightSeverity getSeverity(@NotNull RefElement element) {
        PsiFile psiElement = ((RefElement)element.getRefManager().getRefinedElement((RefEntity)element)).getPointer().getContainingFile();
        if (psiElement != null) {
            GlobalInspectionContextImpl context = this.getContext();
            String shortName = this.getSeverityDelegateName();
            Tools tools = context.getTools().get(shortName);
            if (tools != null) {
                for (ScopeToolState state : tools.getTools()) {
                    InspectionToolWrapper toolWrapper = state.getTool();
                    if (toolWrapper != this.getToolWrapper()) continue;
                    return context.getCurrentProfile().getErrorLevel(HighlightDisplayKey.find((String)shortName), (PsiElement)psiElement).getSeverity();
                }
            }
            InspectionProfileImpl profile2 = InspectionProjectProfileManager.getInstance(context.getProject()).getCurrentProfile();
            HighlightDisplayLevel level = profile2.getErrorLevel(HighlightDisplayKey.find((String)shortName), (PsiElement)psiElement);
            return level.getSeverity();
        }
        return null;
    }

    @Override
    public boolean isExcluded(@NotNull CommonProblemDescriptor descriptor) {
        return this.myExcludedElements.containsValue(descriptor);
    }

    @Override
    public boolean isExcluded(@NotNull RefEntity entity) {
        Object[] excluded = this.myExcludedElements.get(entity);
        Object[] problems = this.myProblemElements.get(entity);
        return excluded != null && problems != null && Comparing.equal((Object)ContainerUtil.set((Object[])excluded), (Object)ContainerUtil.set((Object[])problems));
    }

    @Override
    public void amnesty(@NotNull RefEntity element) {
        this.myExcludedElements.remove(element);
    }

    @Override
    public void exclude(@NotNull RefEntity element) {
        this.myExcludedElements.put(element, (CommonProblemDescriptor[])this.myProblemElements.getOrDefault(element, (CommonProblemDescriptor[])CommonProblemDescriptor.EMPTY_ARRAY));
    }

    @Override
    public void amnesty(@NotNull CommonProblemDescriptor descriptor) {
        this.myExcludedElements.removeValue(descriptor);
    }

    @Override
    public void exclude(@NotNull CommonProblemDescriptor descriptor) {
        RefEntity entity = (RefEntity)ObjectUtils.chooseNotNull((Object)this.myProblemElements.getKeyFor(descriptor), (Object)this.myResolvedElements.getKeyFor(descriptor));
        if (entity != null) {
            this.myExcludedElements.put(entity, (CommonProblemDescriptor[])new CommonProblemDescriptor[]{descriptor});
        }
    }

    protected String getSeverityDelegateName() {
        return this.getToolWrapper().getShortName();
    }

    @Override
    @NotNull
    public InspectionToolWrapper getToolWrapper() {
        return this.myToolWrapper;
    }

    @NotNull
    public RefManager getRefManager() {
        return this.getContext().getRefManager();
    }

    @Override
    @NotNull
    public GlobalInspectionContextImpl getContext() {
        return this.myContext;
    }

    @Override
    public void exportResults(final @NotNull Consumer<Element> resultConsumer, final @NotNull Predicate<? super RefEntity> excludedEntities, final @NotNull Predicate<? super CommonProblemDescriptor> excludedDescriptors) {
        this.getRefManager().iterate(new RefVisitor(){

            public void visitElement(@NotNull RefEntity elem) {
                if (!excludedEntities.test(elem)) {
                    DefaultInspectionToolPresentation.this.exportResults((Consumer<Element>)resultConsumer, elem, (Predicate<? super CommonProblemDescriptor>)excludedDescriptors);
                }
            }
        });
    }

    public void addProblemElement(@Nullable RefEntity refElement, CommonProblemDescriptor ... descriptions) {
        this.addProblemElement(refElement, true, descriptions);
    }

    @Override
    public void addProblemElement(@Nullable RefEntity refElement, boolean filterSuppressed, CommonProblemDescriptor ... descriptors) {
        if (refElement == null || descriptors.length == 0) {
            return;
        }
        DefaultInspectionToolPresentation.checkFromSameFile(refElement, descriptors);
        if (filterSuppressed) {
            if (this.myContext.getOutputPath() == null || !(this.myToolWrapper instanceof LocalInspectionToolWrapper)) {
                this.myProblemElements.put(refElement, (CommonProblemDescriptor[])descriptors);
            } else {
                this.writeOutput(descriptors, refElement);
            }
        } else {
            this.myProblemElements.put(refElement, (CommonProblemDescriptor[])descriptors);
        }
        GlobalInspectionContextImpl context = this.getContext();
        if (context.isViewClosed() || !(refElement instanceof RefElement)) {
            return;
        }
        if (this.myToolWrapper instanceof LocalInspectionToolWrapper && (!ApplicationManager.getApplication().isUnitTestMode() || GlobalInspectionContextImpl.TESTING_VIEW)) {
            context.initializeViewIfNeed().doWhenDone(() -> context.getView().addProblemDescriptors(this.myToolWrapper, refElement, descriptors));
        }
    }

    protected boolean isDisposed() {
        return this.isDisposed;
    }

    private synchronized void writeOutput(@NotNull CommonProblemDescriptor[] descriptions, @NotNull RefEntity refElement) {
        File file2 = ExportHTMLAction.getInspectionResultFile(this.myContext.getOutputPath(), this.myToolWrapper.getShortName());
        boolean exists = file2.exists();
        FileUtil.createParentDirs((File)file2);
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2, true), CharsetToolkit.UTF8_CHARSET)));){
            if (!exists) {
                XMLStreamWriter xmlWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(writer);
                xmlWriter.writeStartElement("problems");
                xmlWriter.writeAttribute("is_local_tool", Boolean.toString(this.myToolWrapper instanceof LocalInspectionToolWrapper));
                xmlWriter.writeCharacters("\n");
                xmlWriter.flush();
            }
            this.exportResults(descriptions, refElement, p -> {
                try {
                    JbXmlOutputter.collapseMacrosAndWrite(p, (ComponentManager)this.getContext().getProject(), writer);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }, d -> false);
            writer.append("\n");
        }
        catch (IOException | XMLStreamException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    @NotNull
    public Collection<CommonProblemDescriptor> getProblemDescriptors() {
        return this.myProblemElements.getValues();
    }

    public void ignoreElement(@NotNull RefEntity refEntity) {
        this.myProblemElements.remove(refEntity);
    }

    @Override
    public void cleanup() {
        this.isDisposed = true;
    }

    @Nullable
    public CommonProblemDescriptor[] getDescriptions(@NotNull RefEntity refEntity) {
        CommonProblemDescriptor[] problems = this.getProblemElements().getOrDefault(refEntity, null);
        if (problems == null) {
            return null;
        }
        if (!refEntity.isValid()) {
            this.ignoreElement(refEntity);
            return null;
        }
        return problems;
    }

    @Override
    @NotNull
    public HTMLComposerImpl getComposer() {
        if (this.myComposer == null) {
            this.myComposer = new DescriptorComposer(this);
        }
        return this.myComposer;
    }

    @Override
    public void exportResults(@NotNull Consumer<Element> resultConsumer, @NotNull RefEntity refEntity, @NotNull Predicate<? super CommonProblemDescriptor> isDescriptorExcluded) {
        CommonProblemDescriptor[] descriptions = this.getProblemElements().get(refEntity);
        if (descriptions != null) {
            this.exportResults(descriptions, refEntity, resultConsumer, isDescriptorExcluded);
        }
    }

    private void exportResults(@NotNull CommonProblemDescriptor[] descriptors, @NotNull RefEntity refEntity, @NotNull Consumer<Element> problemSink, @NotNull Predicate<? super CommonProblemDescriptor> isDescriptorExcluded) {
        for (CommonProblemDescriptor descriptor : descriptors) {
            if (isDescriptorExcluded.test((CommonProblemDescriptor)descriptor)) continue;
            int line = descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getLineNumber() : -1;
            Element element = refEntity.getRefManager().export(refEntity, line);
            if (element == null) {
                return;
            }
            this.exportResult(refEntity, descriptor, element);
            problemSink.accept(element);
        }
    }

    private void exportResult(@NotNull RefEntity refEntity, @NotNull CommonProblemDescriptor descriptor, @NotNull Element element) {
        try {
            PsiElement psiElement = descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getPsiElement() : null;
            Element problemClassElement = new Element(InspectionsBundle.message((String)"inspection.export.results.problem.element.tag", (Object[])new Object[0]));
            problemClassElement.addContent(this.myToolWrapper.getDisplayName());
            HighlightSeverity severity = InspectionToolPresentation.getSeverity(refEntity, psiElement, this);
            SeverityRegistrar severityRegistrar = this.myContext.getCurrentProfile().getProfileManager().getSeverityRegistrar();
            HighlightInfoType type = descriptor instanceof ProblemDescriptor ? ProblemDescriptorUtil.highlightTypeFromDescriptor((ProblemDescriptor)descriptor, severity, severityRegistrar) : ProblemDescriptorUtil.getHighlightInfoType(ProblemHighlightType.GENERIC_ERROR_OR_WARNING, severity, severityRegistrar);
            problemClassElement.setAttribute("severity", type.getSeverity(psiElement).getName());
            problemClassElement.setAttribute("attribute_key", type.getAttributesKey().getExternalName());
            element.addContent(problemClassElement);
            if (this.myToolWrapper instanceof GlobalInspectionToolWrapper) {
                GlobalInspectionTool globalInspectionTool = (GlobalInspectionTool)((GlobalInspectionToolWrapper)this.myToolWrapper).getTool();
                QuickFix[] fixes = descriptor.getFixes();
                if (fixes != null) {
                    Element hintsElement = new Element("hints");
                    for (QuickFix fix : fixes) {
                        String hint = globalInspectionTool.getHint(fix);
                        if (hint == null) continue;
                        Element hintElement = new Element("hint");
                        hintElement.setAttribute("value", hint);
                        hintsElement.addContent(hintElement);
                    }
                    element.addContent(hintsElement);
                }
            }
            String template = descriptor.getDescriptionTemplate();
            String problemText = StringUtil.replace((String)StringUtil.replace((String)template, (String)"#ref", (String)(psiElement != null ? ProblemDescriptorUtil.extractHighlightedText(descriptor, psiElement) : "")), (String)" #loc ", (String)" ");
            Element descriptionElement = new Element(InspectionsBundle.message((String)"inspection.export.results.description.tag", (Object[])new Object[0]));
            descriptionElement.addContent(problemText);
            element.addContent(descriptionElement);
        }
        catch (RuntimeException e) {
            LOG.info("Cannot save results for " + refEntity.getName() + ", inspection which caused problem: " + this.myToolWrapper.getShortName() + ", problem descriptor " + descriptor);
        }
    }

    @Override
    public synchronized boolean hasReportedProblems() {
        return !this.myContents.isEmpty();
    }

    @Override
    public synchronized void updateContent() {
        this.myContents.clear();
        this.updateProblemElements();
    }

    protected void updateProblemElements() {
        Object elements;
        if (this.getContext().getUIOptions().FILTER_RESOLVED_ITEMS) {
            elements = this.getProblemElements().keys().stream().filter(entity -> !this.isExcluded((RefEntity)entity)).collect(Collectors.toSet());
        } else {
            elements = new THashSet(this.getProblemElements().keys());
            elements.addAll(this.getResolvedElements());
            elements.addAll(this.mySuppressedElements.keys());
        }
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            RefEntity element = (RefEntity)iterator.next();
            String groupName = element instanceof RefElement ? element.getRefManager().getGroupName((RefElement)element) : element.getQualifiedName();
            this.registerContentEntry(element, groupName);
        }
    }

    protected void registerContentEntry(RefEntity element, String packageName) {
        Set content = this.myContents.computeIfAbsent(packageName, k -> new HashSet());
        content.add(element);
    }

    @Override
    @NotNull
    public Map<String, Set<RefEntity>> getContent() {
        return this.myContents;
    }

    @Override
    @NotNull
    public QuickFixAction[] getQuickFixes(RefEntity ... refElements) {
        return QuickFixAction.EMPTY;
    }

    public RefEntity getElement(@NotNull CommonProblemDescriptor descriptor) {
        return this.myProblemElements.getKeyFor(descriptor);
    }

    @Override
    @NotNull
    public SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> getProblemElements() {
        return this.myProblemElements;
    }

    @Override
    @Nullable
    public QuickFix findQuickFixes(@NotNull CommonProblemDescriptor problemDescriptor, RefEntity entity, String hint) {
        InspectionProfileEntry tool = this.getToolWrapper().getTool();
        return !(tool instanceof GlobalInspectionTool) ? null : ((GlobalInspectionTool)tool).getQuickFix(hint);
    }

    private static SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> createBidiMap() {
        return new SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor>(){

            @Override
            @NotNull
            protected ArrayFactory<CommonProblemDescriptor> arrayFactory() {
                return CommonProblemDescriptor.ARRAY_FACTORY;
            }
        };
    }

    private static void checkFromSameFile(RefEntity element, CommonProblemDescriptor[] descriptors) {
        if (!(element instanceof RefElement)) {
            return;
        }
        SmartPsiElementPointer pointer = ((RefElement)element).getPointer();
        if (pointer == null) {
            return;
        }
        VirtualFile entityFile = DefaultInspectionToolPresentation.ensureNotInjectedFile(pointer.getVirtualFile());
        if (entityFile == null) {
            return;
        }
        StreamEx.of((Object[])descriptors).select(ProblemDescriptorBase.class).forEach(d -> {
            VirtualFile file2 = d.getContainingFile();
            if (file2 != null) {
                LOG.assertTrue(DefaultInspectionToolPresentation.ensureNotInjectedFile(file2).equals(entityFile), (Object)("descriptor and containing entity files should be the same; descriptor: " + d.getDescriptionTemplate()));
            }
        });
    }

    @Contract(value="null -> null")
    private static VirtualFile ensureNotInjectedFile(VirtualFile file2) {
        return file2 instanceof VirtualFileWindow ? ((VirtualFileWindow)file2).getDelegate() : file2;
    }
}

