/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.offlineViewer.OfflineInspectionRVContentProvider;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionGroupNode;
import com.intellij.codeInspection.ui.InspectionModuleNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionNodeInfo;
import com.intellij.codeInspection.ui.InspectionPackageNode;
import com.intellij.codeInspection.ui.InspectionResultsViewUtil;
import com.intellij.codeInspection.ui.InspectionSeverityGroupNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeLoadingProgressAware;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.InspectionViewChangeAdapter;
import com.intellij.codeInspection.ui.InspectionViewNavigationPanel;
import com.intellij.codeInspection.ui.InspectionViewSuppressActionHolder;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.ProblemPreviewEditorPresentation;
import com.intellij.codeInspection.ui.QuickFixPreviewPanelFactory;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.codeInspection.ui.RerunAction;
import com.intellij.codeInspection.ui.actions.ExportHTMLAction;
import com.intellij.codeInspection.ui.actions.InvokeQuickFixAction;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.exclusion.ExclusionHandler;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionResultsView
extends JPanel
implements Disposable,
DataProvider,
OccurenceNavigator {
    private static final Logger LOG = Logger.getInstance(InspectionResultsView.class);
    public static final DataKey<InspectionResultsView> DATA_KEY = DataKey.create((String)"inspectionView");
    private static final Key<Boolean> PREVIEW_EDITOR_IS_REUSED_KEY = Key.create((String)"inspection.tool.window.preview.editor.is.reused");
    @NotNull
    private final InspectionTree myTree;
    private volatile InspectionProfileImpl myInspectionProfile;
    private final boolean mySettingsEnabled;
    @NotNull
    private final AnalysisScope myScope;
    @NonNls
    public static final String HELP_ID = "reference.toolWindows.inspections";
    private final Splitter mySplitter;
    @NotNull
    private final GlobalInspectionContextImpl myGlobalInspectionContext;
    private boolean myRerun;
    private volatile boolean myDisposed;
    private boolean myApplyingFix;
    @NotNull
    private final InspectionRVContentProvider myProvider;
    @NotNull
    private final ExclusionHandler<InspectionTreeNode> myExclusionHandler;
    private EditorEx myPreviewEditor;
    private InspectionTreeLoadingProgressAware myLoadingProgressPreview;
    private final Alarm myLoadingProgressPreviewAlarm = new Alarm((Disposable)this);
    private final InspectionViewSuppressActionHolder mySuppressActionHolder = new InspectionViewSuppressActionHolder();
    private final ExecutorService myTreeUpdater = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"Inspection-View-Tree-Updater");
    private volatile boolean myUpdating;

    public InspectionResultsView(@NotNull GlobalInspectionContextImpl globalInspectionContext, @NotNull InspectionRVContentProvider provider) {
        String toolId;
        InspectionProfileImpl profile2;
        InspectionToolWrapper tool;
        JComponent toolPanel;
        this.setLayout(new BorderLayout());
        this.myInspectionProfile = globalInspectionContext.getCurrentProfile();
        this.myScope = globalInspectionContext.getCurrentScope();
        this.myGlobalInspectionContext = globalInspectionContext;
        this.myProvider = provider;
        this.myTree = new InspectionTree(globalInspectionContext, this);
        this.mySplitter = new OnePixelSplitter(false, AnalysisUIOptions.getInstance((Project)globalInspectionContext.getProject()).SPLITTER_PROPORTION);
        this.mySplitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree), (int)1));
        this.mySplitter.setHonorComponentsMinimumSize(false);
        this.mySplitter.addPropertyChangeListener(evt -> {
            if ("proportion".equals(evt.getPropertyName())) {
                this.myGlobalInspectionContext.setSplitterProportion(((Float)evt.getNewValue()).floatValue());
            }
        });
        this.add((Component)this.mySplitter, "Center");
        this.myExclusionHandler = new ExclusionHandler<InspectionTreeNode>(){

            public boolean isNodeExclusionAvailable(@NotNull InspectionTreeNode node) {
                return true;
            }

            public boolean isNodeExcluded(@NotNull InspectionTreeNode node) {
                return node.isExcluded();
            }

            public void excludeNode(@NotNull InspectionTreeNode node) {
                node.excludeElement();
                node.dropProblemCountCaches();
            }

            public void includeNode(@NotNull InspectionTreeNode node) {
                node.amnestyElement();
                node.dropProblemCountCaches();
            }

            public boolean isActionEnabled(boolean isExcludeAction) {
                return isExcludeAction || !((InspectionResultsView)InspectionResultsView.this).myGlobalInspectionContext.getUIOptions().FILTER_RESOLVED_ITEMS;
            }

            public void onDone(boolean isExcludeAction) {
                if (isExcludeAction) {
                    InspectionResultsView.this.myTree.removeSelectedProblems();
                } else {
                    InspectionResultsView.this.myTree.repaint();
                }
                InspectionResultsView.this.syncRightPanel();
            }
        };
        this.createActionsToolbar();
        PsiManager.getInstance((Project)this.getProject()).addPsiTreeChangeListener((PsiTreeChangeListener)new InspectionViewChangeAdapter(this), (Disposable)this);
        final ProjectInspectionProfileManager profileManager = ProjectInspectionProfileManager.getInstance(this.getProject());
        profileManager.addProfileChangeListener(new ProfileChangeAdapter(){

            public void profileChanged(InspectionProfile profile2) {
                if (profile2 == profileManager.getCurrentProfile()) {
                    InspectionResultsView.this.profileChanged();
                }
            }
        }, this);
        this.mySettingsEnabled = !this.isSingleInspectionRun() ? true : (toolPanel = (tool = (InspectionToolWrapper)ObjectUtils.notNull((Object)(profile2 = this.getCurrentProfile()).getInspectionTool(toolId = (String)ObjectUtils.notNull((Object)profile2.getSingleTool()), this.getProject()))).getTool().createOptionsPanel()) != null;
    }

    void profileChanged() {
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myTree.revalidate();
            this.myTree.repaint();
            this.syncRightPanel();
        });
    }

    private void createActionsToolbar() {
        BorderLayoutPanel westPanel = JBUI.Panels.simplePanel().addToLeft((Component)this.createLeftActionsToolbar()).addToRight((Component)this.createRightActionsToolbar());
        this.add((Component)westPanel, "West");
    }

    private JComponent createRightActionsToolbar() {
        DefaultActionGroup specialGroup = new DefaultActionGroup();
        specialGroup.add(this.myGlobalInspectionContext.getUIOptions().createGroupBySeverityAction(this));
        specialGroup.add(this.myGlobalInspectionContext.getUIOptions().createGroupByDirectoryAction(this));
        specialGroup.add(this.myGlobalInspectionContext.getUIOptions().createFilterResolvedItemsAction(this));
        specialGroup.add((AnAction)this.myGlobalInspectionContext.createToggleAutoscrollAction());
        specialGroup.add((AnAction)new ExportHTMLAction(this));
        specialGroup.add((AnAction)new InvokeQuickFixAction(this));
        return InspectionResultsView.createToolbar(specialGroup);
    }

    private JComponent createLeftActionsToolbar() {
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new RerunAction(this));
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)((Object)this.myTree));
        group.add(actionsManager.createExpandAllAction((TreeExpander)treeExpander, (JComponent)((Object)this.myTree)));
        group.add(actionsManager.createCollapseAllAction((TreeExpander)treeExpander, (JComponent)((Object)this.myTree)));
        group.add(actionsManager.createPrevOccurenceAction(this.myTree.getOccurenceNavigator()));
        group.add(actionsManager.createNextOccurenceAction(this.myTree.getOccurenceNavigator()));
        group.add(ActionManager.getInstance().getAction("EditInspectionSettings"));
        return InspectionResultsView.createToolbar(group);
    }

    public boolean hasNextOccurence() {
        return this.myTree.getOccurenceNavigator().hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        return this.myTree.getOccurenceNavigator().hasPreviousOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.myTree.getOccurenceNavigator().goNextOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.myTree.getOccurenceNavigator().goPreviousOccurence();
    }

    @NotNull
    public String getNextOccurenceActionName() {
        return this.myTree.getOccurenceNavigator().getNextOccurenceActionName();
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        return this.myTree.getOccurenceNavigator().getPreviousOccurenceActionName();
    }

    private static JComponent createToolbar(DefaultActionGroup specialGroup) {
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("CodeInspection", (ActionGroup)specialGroup, false);
        return toolbar.getComponent();
    }

    public void dispose() {
        InspectionResultsViewUtil.releaseEditor(this.myPreviewEditor);
        this.mySplitter.dispose();
        this.myInspectionProfile = null;
        this.myDisposed = true;
        if (this.myLoadingProgressPreview != null) {
            Disposer.dispose((Disposable)this.myLoadingProgressPreview);
            this.myLoadingProgressPreview = null;
        }
    }

    boolean isAutoScrollMode() {
        String activeToolWindowId = ToolWindowManager.getInstance((Project)this.getProject()).getActiveToolWindowId();
        return this.myGlobalInspectionContext.getUIOptions().AUTOSCROLL_TO_SOURCE && (activeToolWindowId == null || activeToolWindowId.equals(ToolWindowId.INSPECTION));
    }

    public void setApplyingFix(boolean applyingFix) {
        this.myApplyingFix = applyingFix;
        this.syncRightPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncRightPanel() {
        EditorEx oldEditor = this.myPreviewEditor;
        try {
            if (this.myLoadingProgressPreview != null) {
                Disposer.dispose((Disposable)this.myLoadingProgressPreview);
                this.myLoadingProgressPreview = null;
            }
            if (this.myApplyingFix) {
                InspectionToolWrapper wrapper2 = this.myTree.getSelectedToolWrapper(true);
                LOG.assertTrue(wrapper2 != null);
                this.mySplitter.setSecondComponent(InspectionResultsViewUtil.getApplyingFixLabel(wrapper2));
            } else if (this.myTree.getSelectionModel().getSelectionCount() != 1) {
                if (this.myTree.getSelectedToolWrapper(true) == null) {
                    this.mySplitter.setSecondComponent((JComponent)InspectionResultsViewUtil.getNothingToShowTextLabel());
                } else {
                    this.showInRightPanel(this.myTree.getCommonSelectedElement());
                }
            } else {
                TreePath pathSelected = this.myTree.getSelectionModel().getLeadSelectionPath();
                if (pathSelected != null) {
                    InspectionTreeNode node = (InspectionTreeNode)pathSelected.getLastPathComponent();
                    if (node instanceof ProblemDescriptionNode) {
                        ProblemDescriptionNode problemNode = (ProblemDescriptionNode)node;
                        this.showInRightPanel(problemNode.getElement());
                    } else if (node instanceof InspectionPackageNode || node instanceof InspectionModuleNode || node instanceof RefElementNode || this.isSingleInspectionRun() && node instanceof InspectionSeverityGroupNode) {
                        this.showInRightPanel(node.getContainingFileLocalEntity());
                    } else if (node instanceof InspectionNode) {
                        if (this.myGlobalInspectionContext.getPresentation(((InspectionNode)node).getToolWrapper()).isDummy()) {
                            this.mySplitter.setSecondComponent((JComponent)InspectionResultsViewUtil.getNothingToShowTextLabel());
                        } else {
                            this.showInRightPanel(null);
                        }
                    } else if (node instanceof InspectionGroupNode || node instanceof InspectionSeverityGroupNode) {
                        InspectionViewNavigationPanel panel2 = new InspectionViewNavigationPanel(node, this.myTree);
                        this.myLoadingProgressPreview = panel2;
                        this.mySplitter.setSecondComponent((JComponent)panel2);
                    } else {
                        LOG.error("Unexpected node: " + node.getClass());
                    }
                }
            }
        }
        finally {
            if (oldEditor != null) {
                if (Boolean.TRUE.equals(oldEditor.getUserData(PREVIEW_EDITOR_IS_REUSED_KEY))) {
                    oldEditor.putUserData(PREVIEW_EDITOR_IS_REUSED_KEY, null);
                } else {
                    InspectionResultsViewUtil.releaseEditor(oldEditor);
                    if (oldEditor == this.myPreviewEditor) {
                        this.myPreviewEditor = null;
                    }
                }
            }
        }
    }

    private void showInRightPanel(@Nullable RefEntity refEntity) {
        JComponent fixToolbar;
        JPanel editorPanel = new JPanel();
        editorPanel.setLayout(new BorderLayout());
        JPanel actionsPanel = new JPanel(new BorderLayout());
        editorPanel.add((Component)actionsPanel, "North");
        int problemCount = this.myTree.getSelectedProblemCount();
        JComponent previewPanel = null;
        InspectionToolWrapper tool = this.myTree.getSelectedToolWrapper(true);
        if (tool != null) {
            InspectionToolPresentation presentation = this.myGlobalInspectionContext.getPresentation(tool);
            TreePath path = this.myTree.getSelectionPath();
            if (path != null) {
                Object last = path.getLastPathComponent();
                if (last instanceof ProblemDescriptionNode) {
                    CommonProblemDescriptor descriptor = ((ProblemDescriptionNode)last).getDescriptor();
                    if (descriptor != null) {
                        previewPanel = presentation.getCustomPreviewPanel(descriptor, this);
                        JComponent customActions = presentation.getCustomActionsPanel(descriptor, this);
                        if (customActions != null) {
                            actionsPanel.add((Component)customActions, "East");
                        }
                    }
                } else if (refEntity != null && refEntity.isValid()) {
                    previewPanel = presentation.getCustomPreviewPanel(refEntity);
                }
            }
        }
        EditorEx previewEditor = null;
        if (previewPanel == null) {
            Pair<JComponent, EditorEx> panelAndEditor = this.createBaseRightComponentFor(problemCount, refEntity);
            previewPanel = (JComponent)panelAndEditor.getFirst();
            previewEditor = (EditorEx)panelAndEditor.getSecond();
        }
        editorPanel.add(previewPanel, "Center");
        if (problemCount > 0 && (fixToolbar = QuickFixPreviewPanelFactory.create(this)) != null) {
            if (fixToolbar instanceof InspectionTreeLoadingProgressAware) {
                this.myLoadingProgressPreview = (InspectionTreeLoadingProgressAware)((Object)fixToolbar);
            }
            if (previewEditor != null) {
                previewPanel.setBorder(IdeBorderFactory.createBorder((int)2));
            }
            actionsPanel.add((Component)fixToolbar, "West");
        }
        if (previewEditor != null) {
            ProblemPreviewEditorPresentation.setupFoldingsAndHighlightProblems(previewEditor, this);
        }
        this.mySplitter.setSecondComponent((JComponent)editorPanel);
    }

    private Pair<JComponent, EditorEx> createBaseRightComponentFor(int problemCount, RefEntity selectedEntity) {
        if (selectedEntity instanceof RefElement && selectedEntity.isValid() && !(((RefElement)selectedEntity).getPsiElement() instanceof PsiDirectory)) {
            PsiFile file2;
            Document document;
            PsiElement element;
            CommonProblemDescriptor descriptor;
            CommonProblemDescriptor[] descriptors;
            PsiElement selectedElement = ((RefElement)selectedEntity).getPsiElement();
            if (problemCount == 1 && (descriptors = this.myTree.getSelectedDescriptors()).length != 0 && (descriptor = descriptors[0]) instanceof ProblemDescriptorBase && (element = ((ProblemDescriptorBase)descriptor).getPsiElement()) != null) {
                selectedElement = element;
            }
            if ((document = PsiDocumentManager.getInstance((Project)(file2 = selectedElement.getContainingFile()).getProject()).getDocument(file2)) == null) {
                return Pair.create((Object)InspectionResultsViewUtil.createLabelForText("Can't open preview for '" + file2.getName() + "'"), null);
            }
            if (this.reuseEditorFor(document)) {
                this.myPreviewEditor.putUserData(PREVIEW_EDITOR_IS_REUSED_KEY, true);
                this.myPreviewEditor.getFoldingModel().runBatchFoldingOperation(() -> this.myPreviewEditor.getFoldingModel().clearFoldRegions());
                this.myPreviewEditor.getMarkupModel().removeAllHighlighters();
            } else {
                this.myPreviewEditor = (EditorEx)EditorFactory.getInstance().createEditor(document, this.getProject(), file2.getVirtualFile(), true);
                DiffUtil.setFoldingModelSupport(this.myPreviewEditor);
                EditorSettings settings = this.myPreviewEditor.getSettings();
                settings.setLineNumbersShown(false);
                settings.setFoldingOutlineShown(true);
                settings.setLineMarkerAreaShown(true);
                settings.setGutterIconsShown(false);
                settings.setAdditionalColumnsCount(0);
                settings.setAdditionalLinesCount(0);
                settings.setLeadingWhitespaceShown(true);
                this.myPreviewEditor.getColorsScheme().setColor(EditorColors.GUTTER_BACKGROUND, this.myPreviewEditor.getColorsScheme().getDefaultBackground());
                this.myPreviewEditor.getScrollPane().setBorder((Border)JBUI.Borders.empty());
            }
            if (problemCount == 0) {
                this.myPreviewEditor.getScrollingModel().scrollTo(this.myPreviewEditor.offsetToLogicalPosition(selectedElement.getTextOffset()), ScrollType.CENTER_UP);
            }
            this.myPreviewEditor.getComponent().setBorder((Border)JBUI.Borders.empty());
            return Pair.create((Object)this.myPreviewEditor.getComponent(), (Object)this.myPreviewEditor);
        }
        if (selectedEntity == null) {
            return Pair.create((Object)new InspectionNodeInfo(this.myTree, this.getProject()), null);
        }
        if (selectedEntity.isValid()) {
            return Pair.create((Object)InspectionResultsViewUtil.getPreviewIsNotAvailable(selectedEntity), null);
        }
        return Pair.create((Object)InspectionResultsViewUtil.getInvalidEntityLabel(selectedEntity), null);
    }

    private boolean reuseEditorFor(Document document) {
        return this.myPreviewEditor != null && !this.myPreviewEditor.isDisposed() && this.myPreviewEditor.getDocument() == document;
    }

    private void addTool(@NotNull InspectionToolWrapper toolWrapper, HighlightDisplayLevel errorLevel, boolean groupedBySeverity, boolean isSingleInspectionRun) {
        InspectionTreeNode toolNode = this.myTree.getToolProblemsRootNode(toolWrapper, errorLevel, groupedBySeverity, isSingleInspectionRun);
        this.myProvider.appendToolNodeContent(this.myGlobalInspectionContext, toolWrapper, toolNode, this.myGlobalInspectionContext.getUIOptions().SHOW_STRUCTURE, groupedBySeverity);
        InspectionToolPresentation presentation = this.myGlobalInspectionContext.getPresentation(toolWrapper);
        presentation.patchToolNode(toolNode, this.myProvider, this.myGlobalInspectionContext.getUIOptions().SHOW_STRUCTURE, groupedBySeverity);
        this.registerActionShortcuts(presentation);
    }

    private void registerActionShortcuts(@NotNull InspectionToolPresentation presentation) {
        ApplicationManager.getApplication().invokeLater(() -> {
            for (QuickFixAction fix : presentation.getQuickFixes(RefEntity.EMPTY_ELEMENTS_ARRAY)) {
                fix.registerCustomShortcutSet(fix.getShortcutSet(), this);
            }
        });
    }

    public InspectionViewSuppressActionHolder getSuppressActionHolder() {
        return this.mySuppressActionHolder;
    }

    @Nullable
    public String getCurrentProfileName() {
        return this.myInspectionProfile == null ? null : this.myInspectionProfile.getDisplayName();
    }

    public InspectionProfileImpl getCurrentProfile() {
        return this.myInspectionProfile;
    }

    void addProblemDescriptors(InspectionToolWrapper wrapper2, RefEntity refElement, CommonProblemDescriptor[] descriptors) {
        this.updateTree(() -> ReadAction.run(() -> {
            if (!this.isDisposed()) {
                ApplicationManager.getApplication().assertReadAccessAllowed();
                AnalysisUIOptions uiOptions = this.myGlobalInspectionContext.getUIOptions();
                InspectionToolPresentation presentation = this.myGlobalInspectionContext.getPresentation(wrapper2);
                InspectionTreeNode toolNode = this.myTree.getToolProblemsRootNode(wrapper2, HighlightDisplayLevel.find((HighlightSeverity)presentation.getSeverity((RefElement)refElement)), uiOptions.GROUP_BY_SEVERITY, this.isSingleInspectionRun());
                HashMap<RefEntity, CommonProblemDescriptor[]> problems = new HashMap<RefEntity, CommonProblemDescriptor[]>(1);
                problems.put(refElement, descriptors);
                HashMap<String, Set<RefEntity>> contents = new HashMap<String, Set<RefEntity>>();
                String groupName = refElement.getRefManager().getGroupName((RefElement)refElement);
                Set content = contents.computeIfAbsent(groupName, __ -> new HashSet());
                content.add(refElement);
                this.getProvider().appendToolNodeContent(this.myGlobalInspectionContext, wrapper2, toolNode, uiOptions.SHOW_STRUCTURE, true, contents, problems::get);
                this.myLoadingProgressPreviewAlarm.cancelAllRequests();
                this.myLoadingProgressPreviewAlarm.addRequest(() -> {
                    if (this.myLoadingProgressPreview != null) {
                        this.myLoadingProgressPreview.updateLoadingProgress();
                    }
                }, 200);
            }
        }));
    }

    public void update() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Application app = ApplicationManager.getApplication();
        ArrayList<Tools> tools = new ArrayList<Tools>(this.myGlobalInspectionContext.getTools().values());
        Runnable buildAction = () -> {
            try {
                this.setUpdating(true);
                this.myTree.removeAllNodes();
                this.addToolsSynchronously(tools);
            }
            finally {
                this.setUpdating(false);
            }
        };
        if (app.isUnitTestMode()) {
            buildAction.run();
        } else {
            this.updateTree(buildAction);
        }
    }

    public void setUpdating(boolean isUpdating) {
        this.myUpdating = isUpdating;
        if (!isUpdating) {
            this.myLoadingProgressPreviewAlarm.cancelAllRequests();
            this.myLoadingProgressPreviewAlarm.addRequest(() -> {
                if (this.myLoadingProgressPreview != null) {
                    this.myLoadingProgressPreview.treeLoaded();
                }
            }, 200);
        }
        EdtInvocationManager.getInstance().invokeLater(() -> this.myTree.setPaintBusy(this.myUpdating));
    }

    public void addTools(Collection<? extends Tools> tools) {
        this.updateTree(() -> this.addToolsSynchronously(tools));
    }

    private void addToolsSynchronously(Collection<? extends Tools> tools) {
        if (this.isDisposed()) {
            return;
        }
        InspectionProfileImpl profile2 = this.myInspectionProfile;
        boolean isGroupedBySeverity = this.myGlobalInspectionContext.getUIOptions().GROUP_BY_SEVERITY;
        boolean singleInspectionRun = this.isSingleInspectionRun();
        for (Tools tools2 : tools) {
            InspectionToolWrapper defaultToolWrapper = tools2.getDefaultState().getTool();
            HighlightDisplayKey key = HighlightDisplayKey.find((String)defaultToolWrapper.getShortName());
            for (ScopeToolState scopeToolState : this.myProvider.getTools(tools2)) {
                InspectionToolWrapper toolWrapper = scopeToolState.getTool();
                if (!((Boolean)ReadAction.compute(() -> this.myProvider.checkReportedProblems(this.myGlobalInspectionContext, toolWrapper))).booleanValue()) continue;
                this.addTool(toolWrapper, profile2.getErrorLevel(key, scopeToolState.getScope(this.getProject()), this.getProject()), isGroupedBySeverity, singleInspectionRun);
            }
        }
    }

    @NotNull
    public Project getProject() {
        return this.myGlobalInspectionContext.getProject();
    }

    public Object getData(@NotNull String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        if (DATA_KEY.is(dataId)) {
            return this;
        }
        if (ExclusionHandler.EXCLUSION_HANDLER.is(dataId)) {
            return this.myExclusionHandler;
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return null;
        }
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return null;
        }
        if (paths.length > 1) {
            if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                RefEntity[] refElements = this.myTree.getSelectedElements();
                ArrayList<PsiElement> psiElements = new ArrayList<PsiElement>();
                for (RefEntity refElement : refElements) {
                    PsiElement psiElement;
                    PsiElement psiElement2 = psiElement = refElement instanceof RefElement ? ((RefElement)refElement).getPsiElement() : null;
                    if (psiElement == null || !psiElement.isValid()) continue;
                    psiElements.add(psiElement);
                }
                return PsiUtilCore.toPsiElementArray(psiElements);
            }
            return null;
        }
        TreePath path = paths[0];
        InspectionTreeNode selectedNode = (InspectionTreeNode)path.getLastPathComponent();
        if (!CommonDataKeys.NAVIGATABLE.is(dataId) && !CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return null;
        }
        if (selectedNode instanceof RefElementNode) {
            PsiElement psiElement;
            RefElementNode refElementNode = (RefElementNode)selectedNode;
            RefEntity refElement = refElementNode.getElement();
            if (refElement == null || !refElement.isValid()) {
                return null;
            }
            RefEntity item = refElement.getRefManager().getRefinedElement(refElement);
            if (!item.isValid()) {
                return null;
            }
            PsiElement psiElement3 = psiElement = item instanceof RefElement ? ((RefElement)item).getPsiElement() : null;
            if (psiElement == null) {
                return null;
            }
            if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
                return InspectionResultsView.getSelectedNavigatable(null, psiElement);
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                return psiElement.isValid() ? psiElement : null;
            }
        } else if (selectedNode instanceof ProblemDescriptionNode && CommonDataKeys.NAVIGATABLE.is(dataId)) {
            Navigatable navigatable = InspectionResultsView.getSelectedNavigatable(((ProblemDescriptionNode)selectedNode).getDescriptor());
            return navigatable == null ? InspectionResultsViewUtil.getNavigatableForInvalidNode((ProblemDescriptionNode)selectedNode) : navigatable;
        }
        return null;
    }

    @Nullable
    public static Navigatable getSelectedNavigatable(CommonProblemDescriptor descriptor) {
        return InspectionResultsView.getSelectedNavigatable(descriptor, descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getPsiElement() : null);
    }

    @Nullable
    private static Navigatable getSelectedNavigatable(CommonProblemDescriptor descriptor, PsiElement psiElement) {
        VirtualFile virtualFile;
        Navigatable navigatable;
        if (descriptor instanceof ProblemDescriptorBase && (navigatable = ((ProblemDescriptorBase)descriptor).getNavigatable()) != null) {
            return navigatable;
        }
        if (psiElement == null || !psiElement.isValid()) {
            return null;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        VirtualFile virtualFile2 = virtualFile = containingFile == null ? null : containingFile.getVirtualFile();
        if (virtualFile != null) {
            TextRange textRange;
            int startOffset = psiElement.getTextOffset();
            if (descriptor instanceof ProblemDescriptorBase && (textRange = ((ProblemDescriptorBase)descriptor).getTextRangeForNavigation()) != null) {
                if (virtualFile instanceof VirtualFileWindow) {
                    virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
                }
                startOffset = textRange.getStartOffset();
            }
            return PsiNavigationSupport.getInstance().createNavigatable(psiElement.getProject(), virtualFile, startOffset);
        }
        return null;
    }

    @NotNull
    public InspectionTree getTree() {
        return this.myTree;
    }

    @NotNull
    public GlobalInspectionContextImpl getGlobalInspectionContext() {
        return this.myGlobalInspectionContext;
    }

    @NotNull
    public InspectionRVContentProvider getProvider() {
        return this.myProvider;
    }

    public boolean isSingleToolInSelection() {
        return this.myTree.getSelectedToolWrapper(true) != null;
    }

    public boolean isRerun() {
        boolean rerun = this.myRerun;
        this.myRerun = false;
        return rerun;
    }

    public boolean areSettingsEnabled() {
        return this.mySettingsEnabled;
    }

    public boolean isSingleInspectionRun() {
        return this.myInspectionProfile.getSingleTool() != null;
    }

    public static void showPopup(AnActionEvent e, JBPopup popup2) {
        InputEvent event = e.getInputEvent();
        if (event instanceof MouseEvent) {
            popup2.showUnderneathOf(event.getComponent());
        } else {
            popup2.showInBestPositionFor(e.getDataContext());
        }
    }

    @NotNull
    public AnalysisScope getScope() {
        return this.myScope;
    }

    public boolean isUpdating() {
        return this.myUpdating;
    }

    public boolean hasProblems() {
        return InspectionResultsView.hasProblems(this.myGlobalInspectionContext.getTools().values(), this.myGlobalInspectionContext, this.myProvider);
    }

    public static boolean hasProblems(@NotNull Collection<? extends Tools> tools, @NotNull GlobalInspectionContextImpl context, @NotNull InspectionRVContentProvider contentProvider) {
        for (Tools tools2 : tools) {
            for (ScopeToolState scopeToolState : contentProvider.getTools(tools2)) {
                InspectionToolWrapper toolWrapper = scopeToolState.getTool();
                if (!context.getPresentation(toolWrapper).hasReportedProblems() && !contentProvider.checkReportedProblems(context, toolWrapper)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public boolean isRerunAvailable() {
        return !(this.myProvider instanceof OfflineInspectionRVContentProvider) && this.myScope.isValid();
    }

    public void rerun() {
        this.myRerun = true;
        if (this.myScope.isValid()) {
            this.myGlobalInspectionContext.doInspections(this.myScope);
        } else {
            GlobalInspectionContextImpl.NOTIFICATION_GROUP.createNotification(InspectionsBundle.message((String)"inspection.view.invalid.scope.message", (Object[])new Object[0]), NotificationType.INFORMATION).notify(this.getProject());
        }
    }

    private void updateTree(@NotNull Runnable action) {
        this.myTreeUpdater.submit(() -> ProgressManager.getInstance().runProcess(action, (ProgressIndicator)new EmptyProgressIndicator()));
    }

    public void dispatchTreeUpdate() throws ExecutionException, InterruptedException {
        this.myTreeUpdater.submit(EmptyRunnable.getInstance()).get();
    }
}

