/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionTreeModel;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.codeInspection.ui.util.SynchronizedBidiMultiMap;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface InspectionToolPresentation
extends ProblemDescriptionsProcessor {
    @NotNull
    public InspectionToolWrapper getToolWrapper();

    default public void patchToolNode(@NotNull InspectionTreeNode node, @NotNull InspectionRVContentProvider provider, boolean showStructure, boolean groupBySeverity) {
    }

    @NotNull
    default public RefElementNode createRefNode(@Nullable RefEntity entity, @NotNull InspectionTreeModel model, @NotNull InspectionTreeNode parent) {
        return new RefElementNode(entity, this, parent);
    }

    public void updateContent();

    public boolean hasReportedProblems();

    @NotNull
    public Map<String, Set<RefEntity>> getContent();

    public boolean isProblemResolved(@Nullable CommonProblemDescriptor var1);

    public boolean isProblemResolved(@Nullable RefEntity var1);

    @NotNull
    public Collection<RefEntity> getResolvedElements();

    @NotNull
    public CommonProblemDescriptor[] getResolvedProblems(@NotNull RefEntity var1);

    public void suppressProblem(@NotNull CommonProblemDescriptor var1);

    public void suppressProblem(@NotNull RefEntity var1);

    public boolean isSuppressed(RefEntity var1);

    public boolean isSuppressed(CommonProblemDescriptor var1);

    @NotNull
    public CommonProblemDescriptor[] getSuppressedProblems(@NotNull RefEntity var1);

    public void cleanup();

    @Nullable
    public QuickFix findQuickFixes(@NotNull CommonProblemDescriptor var1, RefEntity var2, String var3);

    @NotNull
    public HTMLComposerImpl getComposer();

    @NotNull
    public QuickFixAction[] getQuickFixes(RefEntity ... var1);

    @NotNull
    public SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> getProblemElements();

    @NotNull
    public Collection<CommonProblemDescriptor> getProblemDescriptors();

    public void addProblemElement(@Nullable RefEntity var1, boolean var2, CommonProblemDescriptor ... var3);

    @NotNull
    public GlobalInspectionContextImpl getContext();

    public void exportResults(@NotNull Consumer<Element> var1, @NotNull RefEntity var2, @NotNull Predicate<? super CommonProblemDescriptor> var3);

    public void exportResults(@NotNull Consumer<Element> var1, @NotNull Predicate<? super RefEntity> var2, @NotNull Predicate<? super CommonProblemDescriptor> var3);

    @Nullable
    default public JComponent getCustomPreviewPanel(@NotNull RefEntity entity) {
        return null;
    }

    @Nullable
    default public JComponent getCustomPreviewPanel(@NotNull CommonProblemDescriptor descriptor, @NotNull Disposable parent) {
        return null;
    }

    @Nullable
    default public JComponent getCustomActionsPanel(@NotNull CommonProblemDescriptor descriptor, @NotNull Disposable parent) {
        return null;
    }

    default public boolean isDummy() {
        return false;
    }

    default public boolean showProblemCount() {
        return true;
    }

    @Nullable
    public HighlightSeverity getSeverity(@NotNull RefElement var1);

    public boolean isExcluded(@NotNull CommonProblemDescriptor var1);

    public boolean isExcluded(@NotNull RefEntity var1);

    public void amnesty(@NotNull RefEntity var1);

    public void exclude(@NotNull RefEntity var1);

    public void amnesty(@NotNull CommonProblemDescriptor var1);

    public void exclude(@NotNull CommonProblemDescriptor var1);

    @NotNull
    public static HighlightSeverity getSeverity(@Nullable RefEntity entity, @Nullable PsiElement psiElement, @NotNull InspectionToolPresentation presentation) {
        HighlightSeverity severity = null;
        InspectionProfileImpl profile2 = InspectionProjectProfileManager.getInstance(presentation.getContext().getProject()).getCurrentProfile();
        if (entity instanceof RefElement) {
            RefElement refElement = (RefElement)entity;
            severity = presentation.getSeverity(refElement);
        }
        if (severity == null) {
            severity = profile2.getErrorLevel(HighlightDisplayKey.find((String)presentation.getToolWrapper().getShortName()), psiElement).getSeverity();
        }
        return severity;
    }
}

