/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionResultsViewComparator;
import com.intellij.codeInspection.ui.LevelAndCount;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakInterner;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionTreeNode
implements TreeNode {
    private static final WeakInterner<LevelAndCount[]> LEVEL_AND_COUNT_INTERNER = new WeakInterner((TObjectHashingStrategy)new TObjectHashingStrategy<LevelAndCount[]>(){

        public int computeHashCode(LevelAndCount[] object) {
            return Arrays.hashCode(object);
        }

        public boolean equals(LevelAndCount[] o1, LevelAndCount[] o2) {
            return Arrays.equals(o1, o2);
        }
    });
    protected final ProblemLevels myProblemLevels = new ProblemLevels();
    @NotNull
    final Children myChildren = new Children();
    final InspectionTreeNode myParent;

    protected InspectionTreeNode(InspectionTreeNode parent) {
        this.myParent = parent;
    }

    protected boolean doesNeedInternProblemLevels() {
        return false;
    }

    @Nullable
    public Icon getIcon(boolean expanded) {
        return null;
    }

    @NotNull
    LevelAndCount[] getProblemLevels() {
        if (!this.isProblemCountCacheValid()) {
            this.dropProblemCountCaches();
        }
        return this.myProblemLevels.getValue();
    }

    void dropProblemCountCaches() {
        for (InspectionTreeNode current = this; current != null && this.getParent() != null; current = current.getParent()) {
            current.myProblemLevels.drop();
        }
    }

    protected boolean isProblemCountCacheValid() {
        return true;
    }

    protected void visitProblemSeverities(@NotNull TObjectIntHashMap<HighlightDisplayLevel> counter) {
        for (InspectionTreeNode inspectionTreeNode : this.getChildren()) {
            for (LevelAndCount levelAndCount : inspectionTreeNode.getProblemLevels()) {
                if (counter.adjustValue((Object)levelAndCount.getLevel(), levelAndCount.getCount())) continue;
                counter.put((Object)levelAndCount.getLevel(), levelAndCount.getCount());
            }
        }
    }

    public boolean isValid() {
        return true;
    }

    public boolean isExcluded() {
        List<? extends InspectionTreeNode> children2 = this.getChildren();
        for (InspectionTreeNode inspectionTreeNode : children2) {
            if (inspectionTreeNode.isExcluded()) continue;
            return false;
        }
        return !children2.isEmpty();
    }

    public boolean appearsBold() {
        return false;
    }

    @Nullable
    public String getTailText() {
        return null;
    }

    public void excludeElement() {
        for (InspectionTreeNode inspectionTreeNode : this.getChildren()) {
            inspectionTreeNode.excludeElement();
        }
        this.dropProblemCountCaches();
    }

    public void amnestyElement() {
        for (InspectionTreeNode inspectionTreeNode : this.getChildren()) {
            inspectionTreeNode.amnestyElement();
        }
        this.dropProblemCountCaches();
    }

    public RefEntity getContainingFileLocalEntity() {
        RefEntity current = null;
        for (InspectionTreeNode inspectionTreeNode : this.getChildren()) {
            RefEntity entity = inspectionTreeNode.getContainingFileLocalEntity();
            if (entity == null || current != null) {
                return null;
            }
            current = entity;
        }
        return current;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildren().isEmpty();
    }

    public abstract String getPresentableText();

    @NotNull
    public List<? extends InspectionTreeNode> getChildren() {
        return ContainerUtil.immutableList((Object[])this.myChildren.myChildren);
    }

    @Override
    public InspectionTreeNode getParent() {
        return this.myParent;
    }

    @Override
    public int getChildCount() {
        return this.getChildren().size();
    }

    @Override
    public InspectionTreeNode getChildAt(int idx) {
        return this.getChildren().get(idx);
    }

    @Override
    public int getIndex(TreeNode node) {
        return Collections.binarySearch(this.getChildren(), (InspectionTreeNode)node, InspectionResultsViewComparator.INSTANCE);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    public Enumeration children() {
        return Collections.enumeration(this.getChildren());
    }

    public String toString() {
        return this.getPresentableText();
    }

    void uiRequested() {
    }

    class ProblemLevels {
        private volatile LevelAndCount[] myLevels;

        ProblemLevels() {
        }

        @NotNull
        private LevelAndCount[] compute() {
            TObjectIntHashMap counter = new TObjectIntHashMap();
            InspectionTreeNode.this.visitProblemSeverities((TObjectIntHashMap<HighlightDisplayLevel>)counter);
            LevelAndCount[] arr = new LevelAndCount[counter.size()];
            int[] i = new int[]{0};
            counter.forEachEntry((l, c) -> {
                int n = i[0];
                i[0] = n + 1;
                arr[n] = new LevelAndCount((HighlightDisplayLevel)l, c);
                return true;
            });
            Arrays.sort(arr, Comparator.comparing(levelAndCount -> levelAndCount.getLevel().getSeverity()).reversed());
            return InspectionTreeNode.this.doesNeedInternProblemLevels() ? (LevelAndCount[])LEVEL_AND_COUNT_INTERNER.intern((Object)arr) : arr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public LevelAndCount[] getValue() {
            LevelAndCount[] result2 = this.myLevels;
            if (result2 == null) {
                ProblemLevels problemLevels = this;
                synchronized (problemLevels) {
                    result2 = this.myLevels;
                    if (result2 == null) {
                        result2 = this.compute();
                        this.myLevels = result2;
                    }
                }
            }
            return result2;
        }

        public void drop() {
            this.myLevels = null;
        }
    }

    static class Children {
        private static final InspectionTreeNode[] EMPTY_ARRAY = new InspectionTreeNode[0];
        volatile InspectionTreeNode[] myChildren = EMPTY_ARRAY;
        final BidirectionalMap<Object, InspectionTreeNode> myUserObject2Node = new BidirectionalMap();

        Children() {
        }

        void clear() {
            this.myChildren = EMPTY_ARRAY;
            this.myUserObject2Node.clear();
        }
    }
}

