/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeLoadingProgressAware;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class InspectionViewNavigationPanel
extends JPanel
implements InspectionTreeLoadingProgressAware {
    private final InspectionTreeNode myNode;
    private final InspectionTree myTree;
    private final JPanel myLinks;
    private int myShownChildrenCount;

    public InspectionViewNavigationPanel(InspectionTreeNode node, InspectionTree tree) {
        this.myNode = node;
        this.myTree = tree;
        this.setLayout(new BorderLayout());
        this.setBorder((Border)JBUI.Borders.empty((int)18, (int)12, (int)0, (int)0));
        String titleLabelText = InspectionViewNavigationPanel.getTitleText(true);
        this.add((Component)new JBLabel(titleLabelText), "North");
        this.myLinks = new JPanel();
        this.myLinks.setLayout(new BoxLayout(this.myLinks, 1));
        this.add("Center", this.myLinks);
        this.resetChildrenNavigation();
    }

    @Override
    public void updateLoadingProgress() {
        this.resetChildrenAndRepaint();
    }

    @Override
    public void treeLoaded() {
        this.resetChildrenAndRepaint();
    }

    @NotNull
    public static String getTitleText(boolean addColon) {
        return "Select inspection to see problems" + (addColon ? ":" : ".");
    }

    private void resetChildrenNavigation() {
        int currentChildrenCount = this.myNode.getChildCount();
        if (this.myShownChildrenCount != currentChildrenCount) {
            this.myLinks.removeAll();
            this.myLinks.add(Box.createVerticalStrut(JBUI.scale((int)10)));
            for (int i = 0; i < currentChildrenCount; ++i) {
                final InspectionTreeNode child2 = this.myNode.getChildAt(i);
                LinkLabel link2 = new LinkLabel(child2.getPresentableText(), null){

                    public void doClick() {
                        InspectionViewNavigationPanel.this.myTree.selectNode(child2);
                    }
                };
                link2.setBorder((Border)JBUI.Borders.empty((int)1, (int)17, (int)3, (int)1));
                this.myLinks.add((Component)link2);
            }
            this.myShownChildrenCount = currentChildrenCount;
        }
    }

    private void resetChildrenAndRepaint() {
        this.resetChildrenNavigation();
        this.revalidate();
        this.repaint();
    }
}

