/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.Interner;
import gnu.trove.THashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionViewSuppressActionHolder {
    private final Map<String, Map<ContextDescriptor, SuppressIntentionAction[]>> mySuppressActions = FactoryMap.create(__ -> new THashMap());
    private final Interner<Set<SuppressIntentionAction>> myActionSetInterner = new Interner();

    @NotNull
    public synchronized SuppressIntentionAction[] getSuppressActions(@NotNull InspectionToolWrapper wrapper2, @NotNull PsiElement context) {
        ContextDescriptor descriptor = ContextDescriptor.from(context);
        if (descriptor == null) {
            return SuppressIntentionAction.EMPTY_ARRAY;
        }
        return this.mySuppressActions.get(wrapper2.getShortName()).computeIfAbsent(descriptor, __ -> {
            InspectionProfileEntry tool = wrapper2.getTool();
            SuppressIntentionAction[] actions = tool instanceof CustomSuppressableInspectionTool ? ((CustomSuppressableInspectionTool)tool).getSuppressActions(null) : (SuppressIntentionAction[])Stream.of(tool.getBatchSuppressActions(context)).map(fix -> SuppressIntentionActionFromFix.convertBatchToSuppressIntentionAction(fix)).toArray(SuppressIntentionAction[]::new);
            return actions == null ? SuppressIntentionAction.EMPTY_ARRAY : actions;
        });
    }

    @NotNull
    public synchronized Set<SuppressIntentionAction> getSuppressActions(@NotNull InspectionToolWrapper wrapper2) {
        return this.mySuppressActions.get(wrapper2.getShortName()).values().stream().flatMap(Arrays::stream).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<SuppressIntentionAction> internSuppressActions(@NotNull Set<SuppressIntentionAction> set2) {
        Interner<Set<SuppressIntentionAction>> interner = this.myActionSetInterner;
        synchronized (interner) {
            return (Set)this.myActionSetInterner.intern(set2);
        }
    }

    private static class ContextDescriptor {
        @NotNull
        private final Language myElementLanguage;
        @NotNull
        private final Language myFileBaseLanguage;
        @NotNull
        private final Set<Language> myFileLanguages;
        @Nullable
        private final ContextDescriptor myInjectionDescriptor;

        private static ContextDescriptor from(@NotNull PsiElement element) {
            return ContextDescriptor.from(element, true);
        }

        private static ContextDescriptor from(@NotNull PsiElement element, boolean calculateInjectionDescriptor) {
            PsiFile file2 = element.getContainingFile();
            if (file2 == null) {
                return null;
            }
            FileViewProvider provider = file2.getViewProvider();
            PsiLanguageInjectionHost injectionHost = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectionHost(element);
            ContextDescriptor injectionDescriptor = calculateInjectionDescriptor && injectionHost != null ? ContextDescriptor.from((PsiElement)injectionHost, false) : null;
            return new ContextDescriptor(element.getLanguage(), provider.getBaseLanguage(), provider.getLanguages(), injectionDescriptor);
        }

        private ContextDescriptor(@NotNull Language elementLanguage, @NotNull Language fileBaseLanguage, @NotNull Set<Language> languages, @Nullable ContextDescriptor descriptor) {
            this.myElementLanguage = elementLanguage;
            this.myFileBaseLanguage = fileBaseLanguage;
            this.myFileLanguages = languages;
            this.myInjectionDescriptor = descriptor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContextDescriptor that = (ContextDescriptor)o;
            if (!this.myElementLanguage.equals(that.myElementLanguage)) {
                return false;
            }
            if (!this.myFileBaseLanguage.equals(that.myFileBaseLanguage)) {
                return false;
            }
            if (!this.myFileLanguages.equals(that.myFileLanguages)) {
                return false;
            }
            return Objects.equals(this.myInjectionDescriptor, that.myInjectionDescriptor);
        }

        public int hashCode() {
            int result2 = this.myElementLanguage.hashCode();
            result2 = 31 * result2 + this.myFileBaseLanguage.hashCode();
            result2 = 31 * result2 + this.myFileLanguages.hashCode();
            result2 = 31 * result2 + (this.myInjectionDescriptor != null ? this.myInjectionDescriptor.hashCode() : 0);
            return result2;
        }
    }
}

