/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.WeakStringInterner;
import gnu.trove.TObjectIntHashMap;
import java.util.function.IntSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProblemDescriptionNode
extends SuppressableInspectionTreeNode {
    private final CommonProblemDescriptor myDescriptor;
    private final HighlightDisplayLevel myLevel;
    protected final int myLineNumber;
    protected final RefEntity myElement;
    private static final WeakStringInterner NAME_INTERNER = new WeakStringInterner();

    public ProblemDescriptionNode(RefEntity element, @NotNull CommonProblemDescriptor descriptor, @NotNull InspectionToolPresentation presentation, @NotNull InspectionTreeNode parent) {
        this(element, descriptor, presentation, null, parent);
    }

    protected ProblemDescriptionNode(@Nullable RefEntity element, CommonProblemDescriptor descriptor, @NotNull InspectionToolPresentation presentation, @Nullable IntSupplier lineNumberCounter, @NotNull InspectionTreeNode parent) {
        super(presentation, parent);
        this.myElement = element;
        this.myDescriptor = descriptor;
        this.myLevel = (HighlightDisplayLevel)ObjectUtils.notNull((Object)ProblemDescriptionNode.calculatePreciseLevel(element, descriptor, presentation), () -> {
            String shortName = presentation.getToolWrapper().getShortName();
            InspectionProfileImpl profile2 = presentation.getContext().getCurrentProfile();
            return profile2.getTools(shortName, presentation.getContext().getProject()).getLevel();
        });
        this.myLineNumber = this.myDescriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)this.myDescriptor).getLineNumber() : (lineNumberCounter == null ? -1 : lineNumberCounter.getAsInt());
    }

    private static HighlightDisplayLevel calculatePreciseLevel(@Nullable RefEntity element, @Nullable CommonProblemDescriptor descriptor, @NotNull InspectionToolPresentation presentation) {
        if (element == null) {
            return null;
        }
        InspectionProfileImpl profile2 = presentation.getContext().getCurrentProfile();
        String shortName = presentation.getToolWrapper().getShortName();
        if (descriptor instanceof ProblemDescriptor) {
            BaseInspectionProfileManager inspectionProfileManager = profile2.getProfileManager();
            RefElement refElement = (RefElement)element;
            SeverityRegistrar severityRegistrar = inspectionProfileManager.getSeverityRegistrar();
            HighlightSeverity severity = presentation.getSeverity(refElement);
            if (severity == null) {
                return null;
            }
            HighlightInfoType highlightInfoType = ProblemDescriptorUtil.highlightTypeFromDescriptor((ProblemDescriptor)descriptor, severity, severityRegistrar);
            HighlightSeverity highlightSeverity = highlightInfoType.getSeverity(refElement.getPsiElement());
            return HighlightDisplayLevel.find((HighlightSeverity)highlightSeverity);
        }
        return profile2.getTools(shortName, presentation.getContext().getProject()).getLevel();
    }

    @Nullable
    public String getToolTipText() {
        if (!this.isValid()) {
            return null;
        }
        CommonProblemDescriptor descriptor = this.getDescriptor();
        if (descriptor == null) {
            return null;
        }
        PsiElement element = descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getPsiElement() : null;
        return ProblemDescriptorUtil.renderDescriptionMessage(descriptor, element, false);
    }

    @Override
    public final boolean isAlreadySuppressedFromView() {
        return this.myDescriptor != null && this.getPresentation().isSuppressed(this.myDescriptor);
    }

    public int getLineNumber() {
        return this.myLineNumber;
    }

    @Override
    public boolean canSuppress() {
        return super.canSuppress() && !this.isQuickFixAppliedFromView();
    }

    @NotNull
    public InspectionToolWrapper getToolWrapper() {
        return this.getPresentation().getToolWrapper();
    }

    @Override
    @Nullable
    public RefEntity getElement() {
        return this.myElement;
    }

    @Nullable
    public CommonProblemDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    @Override
    public void excludeElement() {
        CommonProblemDescriptor descriptor = this.getDescriptor();
        if (descriptor != null) {
            this.getPresentation().exclude(descriptor);
        }
    }

    @Override
    public void amnestyElement() {
        CommonProblemDescriptor descriptor = this.getDescriptor();
        if (descriptor != null) {
            this.getPresentation().amnesty(descriptor);
        }
    }

    @Override
    protected void visitProblemSeverities(@NotNull TObjectIntHashMap<HighlightDisplayLevel> counter) {
        if (this.isValid() && !this.isExcluded() && !this.isQuickFixAppliedFromView() && !this.isAlreadySuppressedFromView()) {
            counter.put((Object)this.myLevel, counter.get((Object)this.myLevel) + 1);
        }
    }

    @Override
    protected boolean calculateIsValid() {
        if (this.myDescriptor == null) {
            return false;
        }
        if (this.myElement == null || !this.myElement.isValid()) {
            return false;
        }
        if (this.myDescriptor instanceof ProblemDescriptor) {
            PsiElement psiElement = ((ProblemDescriptor)this.myDescriptor).getPsiElement();
            return psiElement != null && psiElement.isValid();
        }
        return true;
    }

    @Override
    public boolean isExcluded() {
        CommonProblemDescriptor descriptor = this.getDescriptor();
        return descriptor != null && this.getPresentation().isExcluded(descriptor);
    }

    @Override
    @NotNull
    protected String calculatePresentableName() {
        CommonProblemDescriptor descriptor = this.getDescriptor();
        if (descriptor == null) {
            return "";
        }
        PsiElement element = descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getPsiElement() : null;
        String name = StringUtil.removeHtmlTags((String)ProblemDescriptorUtil.renderDescriptionMessage(descriptor, element, 4), (boolean)true);
        return NAME_INTERNER.intern(name);
    }

    @Override
    public boolean isQuickFixAppliedFromView() {
        return this.myDescriptor != null && this.getPresentation().isProblemResolved(this.myDescriptor) && !this.isAlreadySuppressedFromView();
    }

    @Override
    @Nullable
    public String getTailText() {
        String text = super.getTailText();
        return text == null ? "" : text;
    }

    @Override
    @NotNull
    public Pair<PsiElement, CommonProblemDescriptor> getSuppressContent() {
        RefEntity refElement = this.getElement();
        CommonProblemDescriptor descriptor = this.getDescriptor();
        PsiElement element = descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getPsiElement() : (refElement instanceof RefElement ? ((RefElement)refElement).getPsiElement() : null);
        return Pair.create((Object)element, (Object)descriptor);
    }
}

