/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.PreviewEditorFoldingRegion;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ProblemPreviewEditorPresentation {
    private static final int VIEW_ADDITIONAL_OFFSET = 4;

    static void setupFoldingsAndHighlightProblems(@NotNull EditorEx editor, @NotNull InspectionResultsView view) {
        List usages = Arrays.stream(view.getTree().getAllValidSelectedDescriptors()).filter(ProblemDescriptorBase.class::isInstance).map(ProblemDescriptorBase.class::cast).map(d -> {
            PsiElement psi = d.getPsiElement();
            if (psi == null) {
                return null;
            }
            TextRange range2 = d.getTextRangeInElement();
            return range2 == null ? new UsageInfo(psi) : new UsageInfo(psi, range2.getStartOffset(), range2.getEndOffset());
        }).collect(Collectors.toList());
        ProblemPreviewEditorPresentation.setupFoldingsAndHighlightProblems(editor, view, usages, view.getProject());
    }

    public static void setupFoldingsAndHighlightProblems(@NotNull EditorEx editor, @NotNull Container editorContainer, @NotNull List<? extends UsageInfo> usages, @NotNull Project project) {
        DocumentEx doc = editor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        if (documentManager.isUncommited((Document)doc)) {
            WriteAction.run(() -> documentManager.commitDocument(doc));
        }
        TreeSet<PreviewEditorFoldingRegion> foldingRegions = new TreeSet<PreviewEditorFoldingRegion>();
        foldingRegions.add(new PreviewEditorFoldingRegion(0, doc.getLineCount()));
        boolean isUpdated = false;
        for (UsageInfo usageInfo : usages) {
            if (usageInfo == null) {
                return;
            }
            isUpdated |= ProblemPreviewEditorPresentation.makeVisible(foldingRegions, usageInfo.getSegment(), doc);
        }
        if (isUpdated) {
            ProblemPreviewEditorPresentation.setupFoldings(editor, foldingRegions);
        }
        ProblemPreviewEditorPresentation.highlightProblems(editor, editorContainer, usages, project);
    }

    private static void highlightProblems(EditorEx editor, Container editorContainer, List<? extends UsageInfo> usages, @NotNull Project project) {
        List validUsages = ContainerUtil.filter(usages, Objects::nonNull);
        PsiDocumentManager.getInstance((Project)project).performLaterWhenAllCommitted(() -> {
            if (!editor.isDisposed()) {
                PsiElement element;
                editorContainer.invalidate();
                editorContainer.validate();
                UsagePreviewPanel.highlight((List)validUsages, (Editor)editor, (Project)project, (boolean)false, (int)6000);
                if (validUsages.size() == 1 && (element = ((UsageInfo)validUsages.get(0)).getElement()) != null) {
                    DocumentEx document = editor.getDocument();
                    int offset = Math.min(element.getTextRange().getEndOffset() + 4, document.getLineEndOffset(document.getLineNumber(element.getTextRange().getEndOffset())));
                    editor.getScrollingModel().scrollTo(editor.offsetToLogicalPosition(offset), ScrollType.CENTER);
                    return;
                }
                editor.getScrollingModel().scrollTo(editor.offsetToLogicalPosition(0), ScrollType.CENTER_UP);
            }
        });
    }

    public static void setupFoldings(EditorEx editor, SortedSet<? extends PreviewEditorFoldingRegion> foldingRegions) {
        editor.getFoldingModel().runBatchFoldingOperation(() -> {
            editor.getFoldingModel().clearFoldRegions();
            editor.getMarkupModel().removeAllHighlighters();
            for (PreviewEditorFoldingRegion region : foldingRegions) {
                FoldRegion currentRegion;
                if (region.getEndLine() - region.getStartLine() <= 1 || (currentRegion = FoldingModelSupport.addFolding(editor, region.getStartLine(), region.getEndLine(), false)) == null) continue;
                DiffDrawUtil.createLineSeparatorHighlighter(editor, editor.getDocument().getLineStartOffset(region.getStartLine()), editor.getDocument().getLineEndOffset(region.getEndLine() - 1), () -> currentRegion.isValid() && !currentRegion.isExpanded());
            }
        });
    }

    private static boolean makeVisible(SortedSet<PreviewEditorFoldingRegion> foldingRegions, Segment toShowRange, Document document) {
        if (toShowRange == null) {
            return false;
        }
        boolean isUpdated = false;
        int startLine = Math.max(0, document.getLineNumber(toShowRange.getStartOffset()) - 1);
        int endLine = Math.min(document.getLineCount(), document.getLineNumber(toShowRange.getEndOffset()) + 2);
        for (PreviewEditorFoldingRegion range2 : new ArrayList<PreviewEditorFoldingRegion>(foldingRegions)) {
            boolean startInRegion = range2.contain(startLine);
            boolean endInRegion = range2.contain(endLine);
            if (startInRegion && endInRegion) {
                foldingRegions.remove(range2);
                if (range2.getStartLine() != startLine) {
                    foldingRegions.add(new PreviewEditorFoldingRegion(range2.getStartLine(), startLine));
                }
                if (endLine != range2.getEndLine()) {
                    foldingRegions.add(new PreviewEditorFoldingRegion(endLine, range2.getEndLine()));
                }
                return true;
            }
            if (startInRegion) {
                foldingRegions.remove(range2);
                if (range2.getStartLine() != startLine) {
                    foldingRegions.add(new PreviewEditorFoldingRegion(range2.getStartLine(), startLine));
                }
                isUpdated = true;
            }
            if (!endInRegion) continue;
            foldingRegions.remove(range2);
            if (endLine != range2.getEndLine()) {
                foldingRegions.add(new PreviewEditorFoldingRegion(endLine, range2.getEndLine()));
            }
            return true;
        }
        return isUpdated;
    }
}

