/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.reference.RefDirectory;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import gnu.trove.TObjectIntHashMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefElementNode
extends SuppressableInspectionTreeNode {
    private final Icon myIcon;
    @Nullable
    private final RefEntity myRefEntity;

    public RefElementNode(@Nullable RefEntity refEntity, @NotNull InspectionToolPresentation presentation, @NotNull InspectionTreeNode parent) {
        super(presentation, parent);
        this.myRefEntity = refEntity;
        this.myIcon = refEntity == null ? null : refEntity.getIcon(false);
    }

    @Override
    public final boolean isAlreadySuppressedFromView() {
        return this.getElement() != null && this.getPresentation().isSuppressed(this.getElement());
    }

    @Override
    @Nullable
    public RefEntity getElement() {
        return this.myRefEntity;
    }

    @Override
    @Nullable
    public Icon getIcon(boolean expanded) {
        return this.myIcon;
    }

    @Override
    protected String calculatePresentableName() {
        RefEntity element = this.getElement();
        if (element == null) {
            return InspectionsBundle.message((String)"inspection.reference.invalid", (Object[])new Object[0]);
        }
        return element.getRefManager().getRefinedElement(element).getName();
    }

    @Override
    protected boolean calculateIsValid() {
        RefEntity refEntity = this.getElement();
        return refEntity != null && refEntity.isValid();
    }

    @Override
    public boolean isExcluded() {
        RefEntity element = this.getElement();
        if (this.isLeaf() && element != null) {
            return this.getPresentation().isExcluded(element);
        }
        return super.isExcluded();
    }

    @Override
    public void excludeElement() {
        RefEntity element = this.getElement();
        if (this.isLeaf() && element != null) {
            this.getPresentation().exclude(element);
            return;
        }
        super.excludeElement();
    }

    @Override
    public void amnestyElement() {
        RefEntity element = this.getElement();
        if (this.isLeaf() && element != null) {
            this.getPresentation().amnesty(element);
            return;
        }
        super.amnestyElement();
    }

    @Override
    public RefEntity getContainingFileLocalEntity() {
        RefEntity element = this.getElement();
        return element instanceof RefElement && !(element instanceof RefDirectory) ? element : super.getContainingFileLocalEntity();
    }

    @Override
    protected void visitProblemSeverities(@NotNull TObjectIntHashMap<HighlightDisplayLevel> counter) {
        if (!this.isExcluded() && this.isLeaf() && !this.getPresentation().isProblemResolved(this.getElement()) && !this.getPresentation().isSuppressed(this.getElement())) {
            HighlightSeverity severity = InspectionToolPresentation.getSeverity(this.getElement(), null, this.getPresentation());
            HighlightDisplayLevel level = HighlightDisplayLevel.find((HighlightSeverity)severity);
            if (!counter.adjustValue((Object)level, 1)) {
                counter.put((Object)level, 1);
            }
            return;
        }
        super.visitProblemSeverities(counter);
    }

    @Override
    public boolean isQuickFixAppliedFromView() {
        return this.isLeaf() && this.getPresentation().isProblemResolved(this.getElement());
    }

    @Override
    @Nullable
    public String getTailText() {
        if (this.getPresentation().isDummy()) {
            return "";
        }
        String customizedText = super.getTailText();
        if (customizedText != null) {
            return customizedText;
        }
        return this.isLeaf() ? "" : null;
    }

    @Override
    @NotNull
    public Pair<PsiElement, CommonProblemDescriptor> getSuppressContent() {
        RefEntity refElement = this.getElement();
        PsiElement element = refElement instanceof RefElement ? ((RefElement)refElement).getPsiElement() : null;
        return Pair.create((Object)element, null);
    }
}

