/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions.suppress;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SequentialTask;
import com.intellij.util.ThrowableRunnable;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressActionSequentialTask
implements SequentialTask {
    private static final Logger LOG = Logger.getInstance(SuppressActionSequentialTask.class);
    private final SuppressableInspectionTreeNode[] myNodesToSuppress;
    @NotNull
    private final SuppressIntentionAction mySuppressAction;
    @NotNull
    private final InspectionToolWrapper myWrapper;
    private int myCount = 0;

    public SuppressActionSequentialTask(@NotNull SuppressableInspectionTreeNode[] nodesToSuppress, @NotNull SuppressIntentionAction suppressAction, @NotNull InspectionToolWrapper wrapper2) {
        this.myNodesToSuppress = nodesToSuppress;
        this.mySuppressAction = suppressAction;
        this.myWrapper = wrapper2;
    }

    public boolean iteration() {
        return true;
    }

    public boolean iteration(@NotNull ProgressIndicator indicator) {
        SuppressableInspectionTreeNode node = this.myNodesToSuppress[this.myCount++];
        indicator.setFraction((double)this.myCount / (double)this.myNodesToSuppress.length);
        Pair<PsiElement, CommonProblemDescriptor> content = node.getSuppressContent();
        if (content.first != null) {
            this.suppress((PsiElement)content.first, (CommonProblemDescriptor)content.second, this.mySuppressAction, this.myWrapper, node);
        }
        return this.isDone();
    }

    public boolean isDone() {
        return this.myCount > this.myNodesToSuppress.length - 1;
    }

    public void stop() {
    }

    public void prepare() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setText(InspectionsBundle.message((String)"inspection.action.suppress", (Object[])new Object[]{this.myWrapper.getDisplayName()}));
        }
    }

    private void suppress(@NotNull PsiElement element, @Nullable CommonProblemDescriptor descriptor, @NotNull SuppressIntentionAction action, @NotNull InspectionToolWrapper wrapper2, @NotNull SuppressableInspectionTreeNode node) {
        if (action instanceof SuppressIntentionActionFromFix && !(descriptor instanceof ProblemDescriptor)) {
            LOG.info("local suppression fix for specific problem descriptor:  " + wrapper2.getTool().getClass().getName());
        }
        Project project = element.getProject();
        try {
            PsiElement container = null;
            if (action instanceof SuppressIntentionActionFromFix) {
                container = ((SuppressIntentionActionFromFix)action).getContainer(element);
            }
            if (container == null) {
                container = element;
            }
            if (action.isAvailable(project, null, element)) {
                ThrowableRunnable runnable2 = () -> action.invoke(project, null, element);
                if (action.startInWriteAction()) {
                    WriteAction.run((ThrowableRunnable)runnable2);
                } else {
                    runnable2.run();
                }
            }
            Set<GlobalInspectionContextImpl> globalInspectionContexts = ((InspectionManagerEx)InspectionManager.getInstance((Project)element.getProject())).getRunningContexts();
            for (GlobalInspectionContextImpl context : globalInspectionContexts) {
                context.resolveElement(wrapper2.getTool(), container);
                if (descriptor == null) continue;
                context.getPresentation(wrapper2).suppressProblem(descriptor);
            }
        }
        catch (IncorrectOperationException e1) {
            LOG.error((Throwable)e1);
        }
        node.removeSuppressActionFromAvailable(this.mySuppressAction);
    }
}

