/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeStyle;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeStyle.AbstractConvertLineSeparatorsAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class InconsistentLineSeparatorsInspection
extends LocalInspectionTool {
    @NotNull
    private static final LocalQuickFix SET_PROJECT_LINE_SEPARATORS = new LocalQuickFix(){

        @NotNull
        public String getFamilyName() {
            return "Convert to project line separators";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement psiElement = descriptor.getPsiElement();
            if (!(psiElement instanceof PsiFile)) {
                return;
            }
            String lineSeparator = FileDocumentManager.getInstance().getLineSeparator(null, project);
            VirtualFile virtualFile = ((PsiFile)psiElement).getVirtualFile();
            if (virtualFile != null) {
                AbstractConvertLineSeparatorsAction.changeLineSeparators(project, virtualFile, lineSeparator);
            }
        }
    };

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new PsiElementVisitor(){

            public void visitFile(PsiFile file2) {
                if (!file2.getLanguage().equals(file2.getViewProvider().getBaseLanguage())) {
                    return;
                }
                Project project = holder.getProject();
                String projectLineSeparator = FileDocumentManager.getInstance().getLineSeparator(null, project);
                VirtualFile virtualFile = file2.getVirtualFile();
                if (virtualFile == null || !AbstractConvertLineSeparatorsAction.shouldProcess(virtualFile, project)) {
                    return;
                }
                String curLineSeparator = LoadTextUtil.detectLineSeparator(virtualFile, true);
                if (curLineSeparator != null && !curLineSeparator.equals(projectLineSeparator)) {
                    holder.registerProblem((PsiElement)file2, "Line separators in the current file (" + StringUtil.escapeStringCharacters((String)curLineSeparator) + ") differ from the project defaults (" + StringUtil.escapeStringCharacters((String)projectLineSeparator) + ")", new LocalQuickFix[]{SET_PROJECT_LINE_SEPARATORS});
                }
            }
        };
    }
}

