/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.ConcurrentHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ConcurrentCollectionFactory {
    @NotNull
    @Contract(pure=true)
    public static <T, V> ConcurrentMap<T, V> createMap(@NotNull TObjectHashingStrategy<T> hashStrategy) {
        return new ConcurrentHashMap(hashStrategy);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> ConcurrentMap<T, V> createMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<T> hashStrategy) {
        return new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel, hashStrategy);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> createConcurrentSet(@NotNull TObjectHashingStrategy<T> hashStrategy) {
        return Collections.newSetFromMap(ConcurrentCollectionFactory.createMap(hashStrategy));
    }
}

