/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DataWriter;
import com.intellij.configurationStore.DirectoryBasedStorage$MySaveSession$deleteFiles$;
import com.intellij.configurationStore.DirectoryBasedStorageBase;
import com.intellij.configurationStore.DirectoryBasedStorageKt;
import com.intellij.configurationStore.FileBasedStorageKt;
import com.intellij.configurationStore.ReadOnlyModificationException;
import com.intellij.configurationStore.SaveSession;
import com.intellij.configurationStore.SaveSessionBase;
import com.intellij.configurationStore.SaveSessionProducer;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StateMapKt;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.configurationStore.TrackingPathMacroSubstitutorImpl;
import com.intellij.configurationStore.XmlDataWriter;
import com.intellij.configurationStore.schemeManager.SchemeLoaderKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.JdomKt;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.io.PathKt;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001bB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0017\u0010\u0017\u001a\u00020\u00142\b\u0010\u0002\u001a\u0004\u0018\u00010\nH\u0000\u00a2\u0006\u0002\b\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/configurationStore/DirectoryBasedStorage;", "Lcom/intellij/configurationStore/DirectoryBasedStorageBase;", "dir", "Ljava/nio/file/Path;", "splitter", "Lcom/intellij/openapi/components/StateSplitter;", "pathMacroSubstitutor", "Lcom/intellij/openapi/components/PathMacroSubstitutor;", "(Ljava/nio/file/Path;Lcom/intellij/openapi/components/StateSplitter;Lcom/intellij/openapi/components/PathMacroSubstitutor;)V", "cachedVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isUseVfsForWrite", "", "()Z", "virtualFile", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "createSaveSessionProducer", "Lcom/intellij/configurationStore/SaveSessionProducer;", "setStorageData", "", "newStates", "Lcom/intellij/configurationStore/StateMap;", "setVirtualDir", "setVirtualDir$intellij_platform_configurationStore_impl", "toString", "", "MySaveSession", "intellij.platform.configurationStore.impl"})
public class DirectoryBasedStorage
extends DirectoryBasedStorageBase {
    private volatile VirtualFile cachedVirtualFile;
    private final Path dir;

    public boolean isUseVfsForWrite() {
        return true;
    }

    @Override
    @Nullable
    protected VirtualFile getVirtualFile() {
        VirtualFile result2 = this.cachedVirtualFile;
        if (result2 == null) {
            this.cachedVirtualFile = result2 = LocalFileSystem.getInstance().findFileByPath(PathKt.getSystemIndependentPath((Path)this.dir));
        }
        return result2;
    }

    public final void setVirtualDir$intellij_platform_configurationStore_impl(@Nullable VirtualFile dir) {
        this.cachedVirtualFile = dir;
    }

    @Override
    @Nullable
    public SaveSessionProducer createSaveSessionProducer() {
        return this.checkIsSavingDisabled() ? null : (SaveSessionProducer)new MySaveSession(this, (StateMap)StateStorageBase.getStorageData$default(this, false, 1, null));
    }

    private final void setStorageData(StateMap newStates) {
        this.getStorageDataRef().set(newStates);
    }

    @NotNull
    public String toString() {
        VirtualFile virtualFile = this.getVirtualFile();
        return this.getClass().getSimpleName() + "(file=" + (virtualFile != null ? virtualFile.getPath() : null) + ", componentName=" + this.getComponentName() + ')';
    }

    public DirectoryBasedStorage(@NotNull Path dir, @NotNull StateSplitter splitter, @Nullable PathMacroSubstitutor pathMacroSubstitutor) {
        super(splitter, pathMacroSubstitutor);
        this.dir = dir;
    }

    public /* synthetic */ DirectoryBasedStorage(Path path, StateSplitter stateSplitter, PathMacroSubstitutor pathMacroSubstitutor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            pathMacroSubstitutor = null;
        }
        this(path, stateSplitter, pathMacroSubstitutor);
    }

    public static final /* synthetic */ VirtualFile access$getCachedVirtualFile$p(DirectoryBasedStorage $this) {
        return $this.cachedVirtualFile;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0000H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0012H\u0016J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\u001a\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\n2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0018H\u0014R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/configurationStore/DirectoryBasedStorage$MySaveSession;", "Lcom/intellij/configurationStore/SaveSessionBase;", "Lcom/intellij/configurationStore/SaveSession;", "storage", "Lcom/intellij/configurationStore/DirectoryBasedStorage;", "originalStates", "Lcom/intellij/configurationStore/StateMap;", "(Lcom/intellij/configurationStore/DirectoryBasedStorage;Lcom/intellij/configurationStore/StateMap;)V", "copiedStorageData", "", "", "", "dirtyFileNames", "Lcom/intellij/util/containers/SmartHashSet;", "someFileRemoved", "", "createSaveSession", "deleteFiles", "", "dir", "Lcom/intellij/openapi/vfs/VirtualFile;", "doSetState", "fileName", "subState", "Lorg/jdom/Element;", "save", "saveStates", "states", "setSerializedState", "componentName", "element", "intellij.platform.configurationStore.impl"})
    private static final class MySaveSession
    extends SaveSessionBase
    implements SaveSession {
        private Map<String, Object> copiedStorageData;
        private final SmartHashSet<String> dirtyFileNames;
        private boolean someFileRemoved;
        private final DirectoryBasedStorage storage;
        private final StateMap originalStates;

        @Override
        protected void setSerializedState(@NotNull String componentName, @Nullable Element element) {
            List stateAndFileNameList;
            List list2;
            this.storage.setComponentName(componentName);
            if (JdomKt.isEmpty((Element)element)) {
                list2 = CollectionsKt.emptyList();
            } else {
                StateSplitter stateSplitter = this.storage.getSplitter();
                Element element2 = element;
                if (element2 == null) {
                    Intrinsics.throwNpe();
                }
                list2 = stateAndFileNameList = stateSplitter.splitState(element2);
            }
            if (stateAndFileNameList.isEmpty()) {
                if (this.copiedStorageData != null) {
                    Map<String, Object> map2 = this.copiedStorageData;
                    if (map2 == null) {
                        Intrinsics.throwNpe();
                    }
                    map2.clear();
                } else if (!this.originalStates.isEmpty()) {
                    this.copiedStorageData = (Map)new THashMap();
                }
                return;
            }
            THashSet existingFiles = new THashSet(stateAndFileNameList.size());
            for (com.intellij.openapi.util.Pair pair : stateAndFileNameList) {
                this.doSetState((String)pair.second, (Element)pair.first);
                existingFiles.add(pair.second);
            }
            for (String key : this.originalStates.keys()) {
                if (existingFiles.contains((Object)key)) continue;
                if (this.copiedStorageData == null) {
                    this.copiedStorageData = this.originalStates.toMutableMap();
                }
                this.someFileRemoved = true;
                Map<String, Object> map3 = this.copiedStorageData;
                if (map3 == null) {
                    Intrinsics.throwNpe();
                }
                map3.remove(key);
            }
        }

        private final void doSetState(String fileName2, Element subState) {
            if (this.copiedStorageData == null) {
                this.copiedStorageData = StateMapKt.setStateAndCloneIfNeed$default(fileName2, subState, this.originalStates, null, 8, null);
                if (this.copiedStorageData != null) {
                    this.dirtyFileNames.add((Object)fileName2);
                }
            } else {
                Map<String, Object> map2 = this.copiedStorageData;
                if (map2 == null) {
                    Intrinsics.throwNpe();
                }
                if (StateMapKt.updateState$default(map2, fileName2, subState, null, 8, null)) {
                    this.dirtyFileNames.add((Object)fileName2);
                }
            }
        }

        @Nullable
        public MySaveSession createSaveSession() {
            return this.storage.checkIsSavingDisabled() || this.copiedStorageData == null ? null : this;
        }

        public void save() {
            Map<String, Object> map2 = this.copiedStorageData;
            if (map2 == null) {
                Intrinsics.throwNpe();
            }
            StateMap stateMap = StateMap.Companion.fromMap(map2);
            VirtualFile dir = this.storage.getVirtualFile();
            Map<String, Object> map3 = this.copiedStorageData;
            if (map3 == null) {
                Intrinsics.throwNpe();
            }
            if (map3.isEmpty()) {
                if (dir != null && dir.exists()) {
                    FileBasedStorageKt.deleteFile(this, dir);
                }
                this.storage.setStorageData(stateMap);
                return;
            }
            if (dir == null || !dir.isValid()) {
                dir = SchemeLoaderKt.createDir(this.storage.dir, this);
                this.storage.cachedVirtualFile = dir;
            }
            if (!this.dirtyFileNames.isEmpty()) {
                this.saveStates(dir, stateMap);
            }
            if (this.someFileRemoved && dir.exists()) {
                this.deleteFiles(dir);
            }
            this.storage.setStorageData(stateMap);
        }

        private final void saveStates(VirtualFile dir, StateMap states) {
            for (String fileName2 : states.keys()) {
                if (!this.dirtyFileNames.contains((Object)fileName2)) continue;
                try {
                    Element element;
                    PathMacroManager pathMacroManager;
                    if (StateMap.getElement$default(states, fileName2, null, 2, null) == null) {
                        continue;
                    }
                    VirtualFile file2 = SchemeLoaderKt.getOrCreateChild(dir, fileName2, this);
                    if (this.storage.getPathMacroSubstitutor() == null) {
                        pathMacroManager = null;
                    } else {
                        PathMacroSubstitutor pathMacroSubstitutor = this.storage.getPathMacroSubstitutor();
                        if (pathMacroSubstitutor == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.TrackingPathMacroSubstitutorImpl");
                        }
                        pathMacroManager = ((TrackingPathMacroSubstitutorImpl)pathMacroSubstitutor).getMacroManager$intellij_platform_configurationStore_impl();
                    }
                    PathMacroManager macroManager = pathMacroManager;
                    List list2 = CollectionsKt.listOf((Object)element);
                    String string = this.storage.getComponentName();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    XmlDataWriter xmlDataWriter = new XmlDataWriter("component", list2, MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)string)), macroManager, dir.getPath());
                    DataWriter dataWriter = xmlDataWriter;
                    LineSeparator lineSeparator = DirectoryBasedStorageKt.access$getOrDetectLineSeparator(file2);
                    if (lineSeparator == null) {
                        lineSeparator = LineSeparator.getSystemLineSeparator();
                    }
                    FileBasedStorageKt.writeFile(null, this, file2, dataWriter, lineSeparator, false);
                }
                catch (IOException e) {
                    ComponentStoreImplKt.getLOG().error((Throwable)e);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void deleteFiles(VirtualFile dir) {
            void resultRef$iv$iv;
            boolean $i$f$runUndoTransparentWriteAction = false;
            boolean $i$f$computeDelegated = false;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            Function1 it$iv = (Function1)new Function1<Unit, Unit>((Ref.ObjectRef)resultRef$iv$iv){
                final /* synthetic */ Ref.ObjectRef $resultRef;
                {
                    this.$resultRef = objectRef;
                    super(1);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final void invoke(Object it) {
                    this.$resultRef.element = it;
                }
            };
            boolean bl = false;
            CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(it$iv, this, dir){
                final /* synthetic */ Function1 $it;
                final /* synthetic */ MySaveSession this$0;
                final /* synthetic */ VirtualFile $dir$inlined;
                {
                    this.$it = function1;
                    this.this$0 = mySaveSession;
                    this.$dir$inlined = virtualFile;
                }

                public final void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(this){
                        final /* synthetic */ MySaveSession$deleteFiles$$inlined$runUndoTransparentWriteAction$2 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final void run() {
                            Function1 function1 = this.this$0.$it;
                            boolean bl = false;
                            for (VirtualFile file2 : this.this$0.$dir$inlined.getChildren()) {
                                String fileName2 = file2.getName();
                                if (!StringsKt.endsWith$default((String)fileName2, (String)".xml", (boolean)false, (int)2, null)) continue;
                                Map map2 = MySaveSession.access$getCopiedStorageData$p(this.this$0.this$0);
                                if (map2 == null) {
                                    Intrinsics.throwNpe();
                                }
                                if (map2.containsKey(fileName2)) continue;
                                if (file2.isWritable()) {
                                    file2.delete((Object)this.this$0.this$0);
                                    continue;
                                }
                                throw (Throwable)new ReadOnlyModificationException(file2, null);
                            }
                            Unit unit = Unit.INSTANCE;
                            function1.invoke((Object)unit);
                        }
                    });
                }
            });
            Object cfr_ignored_0 = resultRef$iv$iv.element;
        }

        public MySaveSession(@NotNull DirectoryBasedStorage storage2, @NotNull StateMap originalStates) {
            this.storage = storage2;
            this.originalStates = originalStates;
            this.dirtyFileNames = new SmartHashSet();
        }

        public static final /* synthetic */ Map access$getCopiedStorageData$p(MySaveSession $this) {
            return $this.copiedStorageData;
        }

        public static final /* synthetic */ void access$setCopiedStorageData$p(MySaveSession $this, Map map2) {
            $this.copiedStorageData = map2;
        }
    }
}

