/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.AbstractBundle;
import com.intellij.CommonBundle;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ExportSettingsActionKt;
import com.intellij.configurationStore.ExportableItem;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StateStorageManagerImplKt;
import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.configurationStore.UnknownMacroException;
import com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceBean;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.ServiceManagerImpl;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.ZipUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a$\u0010\u0004\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a>\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\u0012H\u0082\b\u001a&\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000e2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002\u001aD\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e2\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u00162\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u0010\b\u0002\u0010#\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0006\u001a\b\u0010$\u001a\u00020\u0016H\u0000\u001a\u0018\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0016H\u0002\u001a \u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u000bH\u0002\u00a8\u0006."}, d2={"exportInstalledPlugins", "", "zipOut", "Ljava/util/zip/ZipOutputStream;", "exportSettings", "exportFiles", "", "Ljava/nio/file/Path;", "out", "Ljava/io/OutputStream;", "configPath", "", "getAdditionalExportFile", "stateAnnotation", "Lcom/intellij/openapi/components/State;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManager;", "isSkipFile", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "file", "", "getComponentPresentableName", "state", "aClass", "Ljava/lang/Class;", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "getExportableComponentsMap", "", "", "Lcom/intellij/configurationStore/ExportableItem;", "isOnlyExisting", "isComputePresentableNames", "onlyPaths", "isImportExportActionApplicable", "isStorageExportable", "storage", "Lcom/intellij/openapi/components/Storage;", "isRoamable", "messageOrDefault", "classLoader", "Ljava/lang/ClassLoader;", "bundleName", "defaultName", "intellij.platform.configurationStore.impl"})
public final class ExportSettingsActionKt {
    public static final boolean isImportExportActionApplicable() {
        Application app = ApplicationManager.getApplication();
        StateStorageManager stateStorageManager = ServiceKt.getStateStore((ComponentManager)app).getStorageManager();
        if (!(stateStorageManager instanceof StateStorageManagerImpl)) {
            stateStorageManager = null;
        }
        StateStorageManagerImpl stateStorageManagerImpl = (StateStorageManagerImpl)stateStorageManager;
        if (stateStorageManagerImpl == null) {
            return true;
        }
        StateStorageManagerImpl storageManager2 = stateStorageManagerImpl;
        return !storageManager2.isStreamProviderPreventExportAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void exportSettings(@NotNull Set<? extends Path> exportFiles, @NotNull OutputStream out, @NotNull String configPath) {
        Closeable closeable = new ZipOutputStream(out);
        Throwable throwable = null;
        try {
            ZipOutputStream zipOut = (ZipOutputStream)closeable;
            boolean bl = false;
            THashSet writtenItemRelativePaths = new THashSet();
            for (Path path : exportFiles) {
                String relativePath;
                BasicFileAttributes fileInfo;
                if (PathKt.basicAttributesIfExists((Path)path) == null) {
                    continue;
                }
                if (FileUtilRt.getRelativePath((String)configPath, (String)PathKt.getSystemIndependentPath((Path)path.toAbsolutePath()), (char)'/') == null) {
                    Intrinsics.throwNpe();
                }
                if (fileInfo.isDirectory()) {
                    ZipUtil.addDirToZipRecursively((ZipOutputStream)zipOut, null, (File)path.toFile(), (String)relativePath, null, (Set)((Set)writtenItemRelativePaths));
                    continue;
                }
                ZipUtil.addFileToZip((ZipOutputStream)zipOut, (File)path.toFile(), (String)relativePath, (Set)((Set)writtenItemRelativePaths), null, (ZipUtil.FileContentProcessor)new ZipUtil.FileContentProcessor(path){
                    final /* synthetic */ Path $file;

                    @NotNull
                    public final InputStream getContent(@NotNull File it) {
                        return PathKt.inputStream((Path)this.$file);
                    }
                    {
                        this.$file = path;
                    }
                }, (boolean)false);
            }
            ExportSettingsActionKt.exportInstalledPlugins(zipOut);
            zipOut.putNextEntry(new ZipEntry("IntelliJ IDEA Global Settings"));
            zipOut.closeEntry();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void exportInstalledPlugins(@NotNull ZipOutputStream zipOut) {
        void $receiver$iv$iv;
        void $receiver$iv$iv$iv;
        IdeaPluginDescriptor[] $receiver$iv;
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = $receiver$iv = PluginManagerCore.getPlugins();
        Collection destination$iv$iv = new ArrayList();
        void var6_6 = $receiver$iv$iv$iv = $receiver$iv$iv;
        int n = ((void)var6_6).length;
        for (int i = 0; i < n; ++i) {
            String string;
            void element$iv$iv$iv;
            void element$iv$iv;
            void it = element$iv$iv = (element$iv$iv$iv = var6_6[i]);
            boolean bl = false;
            String string2 = !it.isBundled() && it.isEnabled() ? it.getPluginId().getIdString() : null;
            if (string2 == null) continue;
            String it$iv$iv = string = string2;
            destination$iv$iv.add(it$iv$iv);
        }
        List plugins2 = (List)destination$iv$iv;
        if (!plugins2.isEmpty()) {
            zipOut.putNextEntry(new ZipEntry("installed.txt"));
            try {
                PluginManagerCore.writePluginsList(plugins2, new OutputStreamWriter((OutputStream)zipOut, Charsets.UTF_8));
            }
            finally {
                zipOut.closeEntry();
            }
        }
    }

    @NotNull
    public static final Map<Path, List<ExportableItem>> getExportableComponentsMap(boolean isOnlyExisting, boolean isComputePresentableNames, @NotNull StateStorageManager storageManager2, @Nullable Set<String> onlyPaths) {
        Object $receiver$iv;
        LinkedHashMap result2 = new LinkedHashMap();
        Function1 processor2 = (Function1)new Function1<ExportableComponent, Unit>(result2){
            final /* synthetic */ LinkedHashMap $result;

            public final void invoke(@NotNull ExportableComponent component) {
                for (File file2 : component.getExportFiles()) {
                    ExportableItem item = new ExportableItem(file2.toPath(), component.getPresentableName(), RoamingType.DEFAULT);
                    UtilKt.putValue((Map)this.$result, (Object)item.getFile(), (Object)item);
                }
            }
            {
                this.$result = linkedHashMap;
                super(1);
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.application.impl.ApplicationImpl");
        }
        ApplicationImpl app = (ApplicationImpl)application;
        for (ExportableApplicationComponent element$iv : $receiver$iv = app.getComponents(ExportableApplicationComponent.class)) {
            processor2.invoke((Object)element$iv);
        }
        $receiver$iv = ServiceBean.loadServicesFromBeans((ExtensionPointName)ExportableComponent.EXTENSION_POINT, ExportableComponent.class);
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            processor2.invoke(element$iv);
        }
        String configPath = storageManager2.expandMacros("$ROOT_CONFIG$");
        Function1<Path, Boolean> isSkipFile$ = new Function1<Path, Boolean>(onlyPaths, configPath, isOnlyExisting){
            final /* synthetic */ Set $onlyPaths;
            final /* synthetic */ String $configPath;
            final /* synthetic */ boolean $isOnlyExisting;

            public final boolean invoke(@NotNull Path file2) {
                if (this.$onlyPaths != null) {
                    String string = FileUtilRt.getRelativePath((String)this.$configPath, (String)PathKt.getSystemIndependentPath((Path)file2), (char)'/');
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    String relativePath = string;
                    if (!StringsKt.contains$default((CharSequence)((Object)file2.getFileName()).toString(), (char)'.', (boolean)false, (int)2, null) && !PathKt.isFile((Path)file2)) {
                        relativePath = relativePath + '/';
                    }
                    if (!this.$onlyPaths.contains(relativePath)) {
                        return true;
                    }
                }
                return this.$isOnlyExisting && !PathKt.exists((Path)file2);
            }
            {
                this.$onlyPaths = set2;
                this.$configPath = string;
                this.$isOnlyExisting = bl;
                super(1);
            }
        };
        if (isOnlyExisting || onlyPaths != null) {
            CollectionsKt.removeAll((Iterable)result2.keySet(), (Function1)((Function1)new Function1<Path, Boolean>(isSkipFile$){
                final /* synthetic */ getExportableComponentsMap.1 $isSkipFile$1;

                public final boolean invoke(@NotNull Path p1) {
                    return this.$isSkipFile$1.invoke(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return null;
                }

                public final String getName() {
                    return "isSkipFile";
                }

                public final String getSignature() {
                    return "invoke(Ljava/nio/file/Path;)Z";
                }
                {
                    this.$isSkipFile$1 = var1_1;
                    super(1);
                }
            }));
        }
        THashMap fileToContent = new THashMap();
        ServiceManagerImpl.processAllImplementationClasses(app, new BiPredicate<Class<?>, PluginDescriptor>(storageManager2, isSkipFile$, isComputePresentableNames, isOnlyExisting, fileToContent, result2){
            final /* synthetic */ StateStorageManager $storageManager;
            final /* synthetic */ getExportableComponentsMap.1 $isSkipFile$1;
            final /* synthetic */ boolean $isComputePresentableNames;
            final /* synthetic */ boolean $isOnlyExisting;
            final /* synthetic */ THashMap $fileToContent;
            final /* synthetic */ LinkedHashMap $result;

            public final boolean test(Class<?> aClass, PluginDescriptor pluginDescriptor) {
                boolean isFileIncluded;
                boolean isRoamable;
                CharSequence charSequence;
                State stateAnnotation = StoreUtilKt.getStateSpec(aClass);
                if (stateAnnotation == null || (charSequence = (CharSequence)stateAnnotation.name()).length() == 0 || ExportableComponent.class.isAssignableFrom(aClass)) {
                    return true;
                }
                Storage storage2 = (Storage)CollectionsKt.firstOrNull(ComponentStoreImplKt.sortByDeprecated(stateAnnotation.storages()));
                if (storage2 == null) {
                    return true;
                }
                Storage storage3 = storage2;
                boolean bl = isRoamable = StateStorageManagerImplKt.getEffectiveRoamingType(storage3.roamingType(), StateStorageManagerImplKt.getPath(storage3)) != RoamingType.DISABLED;
                if (!ExportSettingsActionKt.access$isStorageExportable(storage3, isRoamable)) {
                    return true;
                }
                Path additionalExportFile = null;
                Path file2 = null;
                try {
                    Path path;
                    StateStorageManager storageManager$iv = this.$storageManager;
                    boolean $i$f$getAdditionalExportFile = false;
                    String additionalExportPath$iv = stateAnnotation.additionalExportFile();
                    CharSequence charSequence2 = additionalExportPath$iv;
                    if (!(charSequence2.length() > 0)) {
                        path = null;
                    } else {
                        Path additionalExportFile$iv = null;
                        additionalExportFile$iv = additionalExportPath$iv.charAt(0) == '$' ? Paths.get(storageManager$iv.expandMacros(additionalExportPath$iv), new String[0]) : Paths.get(storageManager$iv.expandMacros("$ROOT_CONFIG$"), additionalExportPath$iv);
                        Path p1 = additionalExportFile$iv;
                        boolean bl2 = false;
                        path = this.$isSkipFile$1.invoke(p1) ? null : additionalExportFile$iv;
                    }
                    additionalExportFile = path;
                    file2 = Paths.get(this.$storageManager.expandMacros(StateStorageManagerImplKt.getPath(storage3)), new String[0]);
                }
                catch (UnknownMacroException e) {
                    ComponentStoreImplKt.getLOG().error("Cannot expand macro for component \"" + stateAnnotation.name() + '\"', (Throwable)e);
                    return true;
                }
                boolean bl3 = isFileIncluded = !this.$isSkipFile$1.invoke(file2);
                if (isFileIncluded || additionalExportFile != null) {
                    String presentableName;
                    if (this.$isComputePresentableNames && this.$isOnlyExisting && additionalExportFile == null && StringsKt.endsWith$default((String)((Object)file2.getFileName()).toString(), (String)".xml", (boolean)false, (int)2, null)) {
                        String content;
                        Object object;
                        Map $receiver$iv = (Map)this.$fileToContent;
                        V value$iv = $receiver$iv.get(file2);
                        if (value$iv == null) {
                            boolean bl4 = false;
                            String answer$iv = PathKt.readText((Path)file2);
                            $receiver$iv.put(file2, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        if (!StringsKt.contains$default((CharSequence)(content = (String)object), (CharSequence)("<component name=\"" + stateAnnotation.name() + '\"'), (boolean)false, (int)2, null)) {
                            return true;
                        }
                    }
                    String string = presentableName = this.$isComputePresentableNames ? ExportSettingsActionKt.access$getComponentPresentableName(stateAnnotation, aClass, pluginDescriptor) : "";
                    if (isFileIncluded) {
                        UtilKt.putValue((Map)this.$result, (Object)file2, (Object)new ExportableItem(file2, presentableName, storage3.roamingType()));
                    }
                    if (additionalExportFile != null) {
                        UtilKt.putValue((Map)this.$result, (Object)additionalExportFile, (Object)new ExportableItem(additionalExportFile, presentableName + " (schemes)", RoamingType.DEFAULT));
                    }
                }
                return true;
            }
            {
                this.$storageManager = stateStorageManager;
                this.$isSkipFile$1 = var2_2;
                this.$isComputePresentableNames = bl;
                this.$isOnlyExisting = bl2;
                this.$fileToContent = tHashMap;
                this.$result = linkedHashMap;
            }
        });
        SchemeManagerFactory schemeManagerFactory = SchemeManagerFactory.Companion.getInstance();
        if (schemeManagerFactory == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase");
        }
        ((SchemeManagerFactoryBase)schemeManagerFactory).process((Function1<? super SchemeManagerImpl<Scheme, Scheme>, Unit>)((Function1)new Function1<SchemeManagerImpl<Scheme, Scheme>, Unit>(storageManager2, result2, isSkipFile$){
            final /* synthetic */ StateStorageManager $storageManager;
            final /* synthetic */ LinkedHashMap $result;
            final /* synthetic */ getExportableComponentsMap.1 $isSkipFile$1;

            public final void invoke(@NotNull SchemeManagerImpl<Scheme, Scheme> it) {
                if (it.getRoamingType() != RoamingType.DISABLED) {
                    Path file2;
                    Character c = StringsKt.getOrNull((CharSequence)it.getFileSpec(), (int)0);
                    if (!(c != null && c.charValue() == '$' || this.$result.containsKey(file2 = Paths.get(this.$storageManager.expandMacros("$ROOT_CONFIG$"), it.getFileSpec())) || this.$isSkipFile$1.invoke(file2))) {
                        Map map2 = this.$result;
                        String string = it.getPresentableName();
                        if (string == null) {
                            string = "";
                        }
                        UtilKt.putValue((Map)map2, (Object)file2, (Object)new ExportableItem(file2, string, it.getRoamingType()));
                    }
                }
            }
            {
                this.$storageManager = stateStorageManager;
                this.$result = linkedHashMap;
                this.$isSkipFile$1 = var3_3;
                super(1);
            }
        }));
        return result2;
    }

    @NotNull
    public static /* synthetic */ Map getExportableComponentsMap$default(boolean bl, boolean bl2, StateStorageManager stateStorageManager, Set set2, int n, Object object) {
        if ((n & 4) != 0) {
            stateStorageManager = ServiceKt.getStateStore((ComponentManager)ApplicationManager.getApplication()).getStorageManager();
        }
        if ((n & 8) != 0) {
            set2 = null;
        }
        return ExportSettingsActionKt.getExportableComponentsMap(bl, bl2, stateStorageManager, set2);
    }

    private static final Path getAdditionalExportFile(State stateAnnotation, StateStorageManager storageManager2, Function1<? super Path, Boolean> isSkipFile) {
        int $i$f$getAdditionalExportFile = 0;
        String additionalExportPath = stateAnnotation.additionalExportFile();
        CharSequence charSequence = additionalExportPath;
        if (!(charSequence.length() > 0)) {
            return null;
        }
        Path additionalExportFile = null;
        additionalExportFile = additionalExportPath.charAt(0) == '$' ? Paths.get(storageManager2.expandMacros(additionalExportPath), new String[0]) : Paths.get(storageManager2.expandMacros("$ROOT_CONFIG$"), additionalExportPath);
        return (Boolean)isSkipFile.invoke((Object)additionalExportFile) != false ? null : additionalExportFile;
    }

    private static final boolean isStorageExportable(Storage storage2, boolean isRoamable) {
        CharSequence charSequence;
        if (storage2.exportable()) {
            return true;
        }
        return isRoamable && Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass((Class)storage2.storageClass()), (Object)Reflection.getOrCreateKotlinClass(StateStorage.class)) && !((charSequence = (CharSequence)StateStorageManagerImplKt.getPath(storage2)).length() == 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String getComponentPresentableName(State state, Class<?> aClass, PluginDescriptor pluginDescriptor) {
        Object classLoader;
        Object object;
        Class presentableName = state.presentableName();
        if (Intrinsics.areEqual((Object)presentableName, State.NameGetter.class) ^ true) {
            try {
                return (String)((State.NameGetter)ReflectionUtil.newInstance((Class)presentableName)).get();
            }
            catch (Exception e) {
                ComponentStoreImplKt.getLOG().error((Throwable)e);
            }
        }
        String defaultName = state.name();
        Function0<String> trimDefaultName$ = new Function0<String>(defaultName){
            final /* synthetic */ String $defaultName;

            @NotNull
            public final String invoke() {
                return StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)this.$defaultName, (CharSequence)".Settings"), (CharSequence)".Settings");
            }
            {
                this.$defaultName = string;
                super(0);
            }
        };
        String resourceBundleName = null;
        if (pluginDescriptor instanceof IdeaPluginDescriptor && Intrinsics.areEqual((Object)"com.intellij", (Object)((IdeaPluginDescriptor)pluginDescriptor).getPluginId().getIdString()) ^ true) {
            resourceBundleName = ((IdeaPluginDescriptor)pluginDescriptor).getResourceBundleBaseName();
            if (resourceBundleName == null) {
                if (!Intrinsics.areEqual((Object)((IdeaPluginDescriptor)pluginDescriptor).getVendor(), (Object)"JetBrains")) return trimDefaultName$.invoke();
                resourceBundleName = "messages.OptionsBundle";
            }
        } else {
            resourceBundleName = "messages.OptionsBundle";
        }
        if ((object = pluginDescriptor) == null || (object = object.getPluginClassLoader()) == null) {
            object = classLoader = aClass.getClassLoader();
        }
        if (classLoader == null) return trimDefaultName$.invoke();
        String message = ExportSettingsActionKt.messageOrDefault((ClassLoader)classLoader, resourceBundleName, defaultName);
        if (message != defaultName) {
            return message;
        }
        if (!PlatformUtils.isRubyMine()) return trimDefaultName$.invoke();
        return ExportSettingsActionKt.messageOrDefault((ClassLoader)classLoader, "org.jetbrains.plugins.ruby.RBundle", defaultName);
    }

    private static final String messageOrDefault(ClassLoader classLoader, String bundleName, String defaultName) {
        ResourceBundle resourceBundle = AbstractBundle.getResourceBundle((String)bundleName, (ClassLoader)classLoader);
        if (resourceBundle == null) {
            return defaultName;
        }
        ResourceBundle bundle = resourceBundle;
        return CommonBundle.messageOrDefault((ResourceBundle)bundle, (String)("exportable." + defaultName + ".presentable.name"), (String)defaultName, (Object[])new Object[0]);
    }

    public static final /* synthetic */ boolean access$isStorageExportable(Storage storage2, boolean isRoamable) {
        return ExportSettingsActionKt.isStorageExportable(storage2, isRoamable);
    }

    public static final /* synthetic */ Path access$getAdditionalExportFile(State stateAnnotation, StateStorageManager storageManager2, Function1 isSkipFile) {
        return ExportSettingsActionKt.getAdditionalExportFile(stateAnnotation, storageManager2, (Function1<? super Path, Boolean>)isSkipFile);
    }

    public static final /* synthetic */ String access$getComponentPresentableName(State state, Class aClass, PluginDescriptor pluginDescriptor) {
        return ExportSettingsActionKt.getComponentPresentableName(state, aClass, pluginDescriptor);
    }
}

