/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DataWriter;
import com.intellij.configurationStore.FileBasedStorageConfiguration;
import com.intellij.configurationStore.FileBasedStorageConfigurationKt;
import com.intellij.configurationStore.FileBasedStorageKt;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.XmlElementStorage;
import com.intellij.configurationStore.XmlElementStorageKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import com.intellij.util.io.IoKt;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u0001@BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0014J\b\u0010,\u001a\u00020-H\u0014J\n\u0010.\u001a\u0004\u0018\u00010/H\u0014J\n\u00100\u001a\u0004\u0018\u00010/H\u0002J\n\u00101\u001a\u0004\u0018\u00010/H\u0002J\u000e\u00102\u001a\u00020-2\u0006\u00103\u001a\u00020\u0018J\u0018\u00104\u001a\u00020-2\u000e\u00105\u001a\n\u0018\u000106j\u0004\u0018\u0001`7H\u0002J$\u00108\u001a\u0004\u0018\u0001H9\"\u0004\b\u0000\u001092\f\u0010:\u001a\b\u0012\u0004\u0012\u0002H90;H\u0082\b\u00a2\u0006\u0002\u0010<J\u001a\u0010=\u001a\u00020-2\b\u0010%\u001a\u0004\u0018\u00010\u000f2\b\u0010>\u001a\u0004\u0018\u00010\u0003J\b\u0010?\u001a\u00020\u0005H\u0016R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0019R\u0011\u0010\u001d\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019R\u0014\u0010\u001e\u001a\u00020\u0018X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0019R\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0013\u0010%\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006A"}, d2={"Lcom/intellij/configurationStore/FileBasedStorage;", "Lcom/intellij/configurationStore/XmlElementStorage;", "file", "Ljava/nio/file/Path;", "fileSpec", "", "rootElementName", "pathMacroManager", "Lcom/intellij/openapi/components/PathMacroSubstitutor;", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "provider", "Lcom/intellij/configurationStore/StreamProvider;", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/components/PathMacroSubstitutor;Lcom/intellij/openapi/components/RoamingType;Lcom/intellij/configurationStore/StreamProvider;)V", "cachedVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "configuration", "Lcom/intellij/configurationStore/FileBasedStorageConfiguration;", "getConfiguration", "()Lcom/intellij/configurationStore/FileBasedStorageConfiguration;", "<set-?>", "getFile", "()Ljava/nio/file/Path;", "isBlockSavingTheContent", "", "()Z", "setBlockSavingTheContent", "(Z)V", "isUseUnixLineSeparator", "isUseVfsForWrite", "isUseXmlProlog", "lineSeparator", "Lcom/intellij/util/LineSeparator;", "getLineSeparator", "()Lcom/intellij/util/LineSeparator;", "setLineSeparator", "(Lcom/intellij/util/LineSeparator;)V", "virtualFile", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "createSaveSession", "Lcom/intellij/configurationStore/FileBasedStorage$FileSaveSession;", "states", "Lcom/intellij/configurationStore/StateMap;", "handleVirtualFileNotFound", "", "loadLocalData", "Lorg/jdom/Element;", "loadLocalDataUsingIo", "loadUsingVfs", "preloadStorageData", "isEmpty", "processReadException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "runAndHandleExceptions", "T", "task", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "setFile", "ioFileIfChanged", "toString", "FileSaveSession", "intellij.platform.configurationStore.impl"})
public class FileBasedStorage
extends XmlElementStorage {
    private volatile VirtualFile cachedVirtualFile;
    @Nullable
    private LineSeparator lineSeparator;
    private boolean isBlockSavingTheContent;
    @NotNull
    private volatile Path file;
    @NotNull
    private final FileBasedStorageConfiguration configuration;
    private final boolean isUseXmlProlog = false;

    @Nullable
    protected final LineSeparator getLineSeparator() {
        return this.lineSeparator;
    }

    protected final void setLineSeparator(@Nullable LineSeparator lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    protected final boolean isBlockSavingTheContent() {
        return this.isBlockSavingTheContent;
    }

    protected final void setBlockSavingTheContent(boolean bl) {
        this.isBlockSavingTheContent = bl;
    }

    @NotNull
    public final Path getFile() {
        return this.file;
    }

    @NotNull
    protected FileBasedStorageConfiguration getConfiguration() {
        return this.configuration;
    }

    protected boolean isUseXmlProlog() {
        return this.isUseXmlProlog;
    }

    public final boolean isUseVfsForWrite() {
        return this.getConfiguration().isUseVfsForWrite();
    }

    private final boolean isUseUnixLineSeparator() {
        return !this.isUseXmlProlog();
    }

    public final void setFile(@Nullable VirtualFile virtualFile, @Nullable Path ioFileIfChanged) {
        this.cachedVirtualFile = virtualFile;
        if (ioFileIfChanged != null) {
            this.file = ioFileIfChanged;
        }
    }

    @Override
    @NotNull
    protected FileSaveSession createSaveSession(@NotNull StateMap states) {
        return new FileSaveSession(states, this);
    }

    @Nullable
    public final VirtualFile getVirtualFile() {
        VirtualFile result2 = this.cachedVirtualFile;
        if (result2 == null) {
            VirtualFile virtualFile = result2 = this.getConfiguration().resolveVirtualFile(PathKt.getSystemIndependentPath((Path)this.file));
            if (virtualFile != null) {
                virtualFile.setCharset(Charsets.UTF_8);
            }
            this.cachedVirtualFile = result2;
        }
        return this.cachedVirtualFile;
    }

    private final <T> T runAndHandleExceptions(Function0<? extends T> task2) {
        int $i$f$runAndHandleExceptions = 0;
        try {
            return (T)task2.invoke();
        }
        catch (JDOMException e) {
            this.processReadException((Exception)((Object)e));
        }
        catch (IOException e) {
            this.processReadException(e);
        }
        return null;
    }

    public final void preloadStorageData(boolean isEmpty2) {
        if (isEmpty2) {
            this.getStorageDataRef().set(StateMap.Companion.getEMPTY());
        } else {
            StateStorageBase.getStorageData$default(this, false, 1, null);
        }
    }

    @Override
    @Nullable
    protected Element loadLocalData() {
        Element element;
        block3: {
            this.isBlockSavingTheContent = false;
            FileBasedStorage this_$iv = this;
            boolean $i$f$runAndHandleExceptions = false;
            try {
                boolean bl = false;
                element = this.getConfiguration().isUseVfsForRead() ? this.loadUsingVfs() : this.loadLocalDataUsingIo();
                break block3;
            }
            catch (JDOMException e$iv) {
                this_$iv.processReadException((Exception)((Object)e$iv));
            }
            catch (IOException e$iv) {
                this_$iv.processReadException(e$iv);
            }
            element = null;
        }
        return element;
    }

    private final Element loadLocalDataUsingIo() {
        BasicFileAttributes attributes = null;
        try {
            attributes = Files.readAttributes(this.file, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (NoSuchFileException e) {
            Logger $receiver$iv = ComponentStoreImplKt.getLOG();
            Exception e$iv = null;
            boolean $i$f$debug = false;
            if ($receiver$iv.isDebugEnabled()) {
                Logger logger = $receiver$iv;
                boolean bl = false;
                String string = "Document was not loaded for " + this.getFileSpec() + ", doesn't exist";
                logger.debug(string, (Throwable)e$iv);
            }
            return null;
        }
        if (!attributes.isRegularFile()) {
            Logger $receiver$iv = ComponentStoreImplKt.getLOG();
            Exception e$iv = null;
            boolean $i$f$debug = false;
            if ($receiver$iv.isDebugEnabled()) {
                Logger logger = $receiver$iv;
                boolean bl = false;
                String string = "Document was not loaded for " + this.getFileSpec() + ", not a file";
                logger.debug(string, (Throwable)e$iv);
            }
            return null;
        }
        if (attributes.size() == 0L) {
            this.processReadException(null);
            return null;
        }
        if (this.isUseUnixLineSeparator()) {
            this.lineSeparator = LineSeparator.LF;
            InputStream $receiver$iv = PathKt.inputStreamSkippingBom((Path)this.file);
            Charset charset = Charsets.UTF_8;
            return JDOMUtil.load((Reader)new InputStreamReader($receiver$iv, charset));
        }
        InputStream inputStream = PathKt.inputStreamSkippingBom((Path)this.file);
        Charset charset = Charsets.UTF_8;
        CharSequence data = IoKt.readCharSequence((InputStreamReader)new InputStreamReader(inputStream, charset), (int)((int)attributes.size()));
        this.lineSeparator = FileBasedStorageKt.detectLineSeparators(data, this.isUseXmlProlog() ? null : LineSeparator.LF);
        return JDOMUtil.load((CharSequence)data);
    }

    private final Element loadUsingVfs() {
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile == null || !virtualFile.exists()) {
            this.handleVirtualFileNotFound();
            return null;
        }
        if (virtualFile.getLength() == 0L) {
            this.processReadException(null);
        } else {
            FileBasedStorage this_$iv = this;
            boolean $i$f$runAndHandleExceptions = false;
            try {
                boolean bl = false;
                CharBuffer charBuffer = Charsets.UTF_8.decode(ByteBuffer.wrap(virtualFile.contentsToByteArray()));
                this.lineSeparator = FileBasedStorageKt.detectLineSeparators(charBuffer, this.isUseXmlProlog() ? null : LineSeparator.LF);
                return JDOMUtil.load((CharSequence)charBuffer);
            }
            catch (JDOMException e$iv) {
                this_$iv.processReadException((Exception)((Object)e$iv));
            }
            catch (IOException e$iv) {
                this_$iv.processReadException(e$iv);
            }
        }
        return null;
    }

    protected void handleVirtualFileNotFound() {
    }

    private final void processReadException(Exception e) {
        Application app;
        boolean contentTruncated = e == null;
        boolean bl = this.isBlockSavingTheContent = !contentTruncated && (Intrinsics.areEqual((Object)"$PROJECT_FILE$", (Object)this.getFileSpec()) || StringsKt.startsWith$default((String)this.getFileSpec(), (String)"$PROJECT_CONFIG_DIR$", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)this.getFileSpec(), (Object)"$MODULE_FILE$") || Intrinsics.areEqual((Object)this.getFileSpec(), (Object)"$WORKSPACE_FILE$"));
        if (e != null) {
            ComponentStoreImplKt.getLOG().warn((Throwable)e);
        }
        if (!(app = ApplicationManager.getApplication()).isUnitTestMode() && !app.isHeadlessEnvironment()) {
            String string;
            if (contentTruncated) {
                string = "content truncated";
            } else {
                Exception exception = e;
                if (exception == null) {
                    Intrinsics.throwNpe();
                }
                string = exception.getMessage();
            }
            String reason = string;
            String action = this.isBlockSavingTheContent ? "Please correct the file content" : "File content will be recreated";
            new Notification("System Messages", "Load Settings", "Cannot load settings from file '" + this.file + "': " + reason + '\n' + action, NotificationType.WARNING).notify(null);
        }
    }

    @NotNull
    public String toString() {
        return PathKt.getSystemIndependentPath((Path)this.file);
    }

    public FileBasedStorage(@NotNull Path file2, @NotNull String fileSpec, @Nullable String rootElementName, @Nullable PathMacroSubstitutor pathMacroManager, @Nullable RoamingType roamingType, @Nullable StreamProvider provider) {
        super(fileSpec, rootElementName, pathMacroManager, roamingType, provider);
        this.file = file2;
        this.configuration = FileBasedStorageConfigurationKt.getDefaultFileBasedStorageConfiguration();
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isUnitTestMode() && StringsKt.startsWith$default((CharSequence)((Object)file2).toString(), (char)'$', (boolean)false, (int)2, null)) {
            throw (Throwable)((Object)new AssertionError((Object)("It seems like some macros were not expanded for path: " + file2)));
        }
    }

    public /* synthetic */ FileBasedStorage(Path path, String string, String string2, PathMacroSubstitutor pathMacroSubstitutor, RoamingType roamingType, StreamProvider streamProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            pathMacroSubstitutor = null;
        }
        if ((n & 0x10) != 0) {
            roamingType = null;
        }
        if ((n & 0x20) != 0) {
            streamProvider = null;
        }
        this(path, string, string2, pathMacroSubstitutor, roamingType, streamProvider);
    }

    public static final /* synthetic */ Path access$getFile$p(FileBasedStorage $this) {
        return $this.file;
    }

    public static final /* synthetic */ void access$setFile$p(FileBasedStorage $this, Path path) {
        $this.file = path;
    }

    public static final /* synthetic */ VirtualFile access$getCachedVirtualFile$p(FileBasedStorage $this) {
        return $this.cachedVirtualFile;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0014\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0004J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/configurationStore/FileBasedStorage$FileSaveSession;", "Lcom/intellij/configurationStore/XmlElementStorage$XmlElementStorageSaveSession;", "Lcom/intellij/configurationStore/FileBasedStorage;", "storageData", "Lcom/intellij/configurationStore/StateMap;", "storage", "(Lcom/intellij/configurationStore/StateMap;Lcom/intellij/configurationStore/FileBasedStorage;)V", "isSaveAllowed", "", "saveLocally", "", "dataWriter", "Lcom/intellij/configurationStore/DataWriter;", "intellij.platform.configurationStore.impl"})
    protected static class FileSaveSession
    extends XmlElementStorage.XmlElementStorageSaveSession<FileBasedStorage> {
        @Override
        protected final boolean isSaveAllowed() {
            if (!super.isSaveAllowed()) {
                return false;
            }
            if (((FileBasedStorage)this.getStorage()).isBlockSavingTheContent()) {
                ComponentStoreImplKt.getLOG().info("Save blocked for " + ((FileBasedStorage)this.getStorage()).getFileSpec());
                return false;
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void saveLocally(@Nullable DataWriter dataWriter) {
            boolean isUseVfs;
            VirtualFile virtualFile;
            LineSeparator lineSeparator = ((FileBasedStorage)this.getStorage()).getLineSeparator();
            if (lineSeparator == null) {
                lineSeparator = ((FileBasedStorage)this.getStorage()).isUseUnixLineSeparator() ? LineSeparator.LF : LineSeparator.getSystemLineSeparator();
                ((FileBasedStorage)this.getStorage()).setLineSeparator(lineSeparator);
            }
            VirtualFile virtualFile2 = virtualFile = (isUseVfs = ((FileBasedStorage)this.getStorage()).getConfiguration().isUseVfsForWrite()) ? ((FileBasedStorage)this.getStorage()).getVirtualFile() : null;
            if (dataWriter == null) {
                if (isUseVfs && virtualFile == null) {
                    ComponentStoreImplKt.getLOG().warn("Cannot find virtual file " + virtualFile);
                }
                FileBasedStorageKt.access$deleteFile(((FileBasedStorage)this.getStorage()).getFile(), this, virtualFile);
                ((FileBasedStorage)this.getStorage()).cachedVirtualFile = null;
                return;
            }
            if (isUseVfs) {
                ((FileBasedStorage)this.getStorage()).cachedVirtualFile = FileBasedStorageKt.writeFile(((FileBasedStorage)this.getStorage()).getFile(), this, virtualFile, dataWriter, lineSeparator, ((FileBasedStorage)this.getStorage()).isUseXmlProlog());
                return;
            }
            Path file2 = ((FileBasedStorage)this.getStorage()).getFile();
            Logger $receiver$iv = ComponentStoreImplKt.getLOG();
            Exception e$iv = null;
            boolean $i$f$debugOrInfoIfTestMode = false;
            Application application = ApplicationManager.getApplication();
            if (application != null && application.isUnitTestMode()) {
                Logger logger = $receiver$iv;
                boolean bl = false;
                String string = "Save " + file2;
                logger.info(string);
            } else {
                Logger $receiver$iv$iv = $receiver$iv;
                boolean $i$f$debug = false;
                if ($receiver$iv$iv.isDebugEnabled()) {
                    Logger logger = $receiver$iv$iv;
                    boolean bl = false;
                    String string = "Save " + file2;
                    logger.debug(string, (Throwable)e$iv);
                }
            }
            try {
                XmlElementStorageKt.writeTo(dataWriter, file2, lineSeparator.getSeparatorString());
                return;
            }
            catch (Throwable e) {
                throw (Throwable)new RuntimeException("Cannot write " + file2, e);
            }
        }

        public FileSaveSession(@NotNull StateMap storageData, @NotNull FileBasedStorage storage2) {
            super(storageData, (XmlElementStorage)storage2);
        }
    }
}

