/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.DefaultStateSerializerKt;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.PathUtilRt;
import com.intellij.util.text.UniqueNameGenerator;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0000J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u0017\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0016\b\u0002\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001bJL\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u001b2\u001e\u0010\u001f\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0 H\u0016J.\u0010\"\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0014\u0010#\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010!\u0012\u0004\u0012\u00020\u00110\u001bH\u0016J(\u0010$\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010(\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\rj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/configurationStore/SchemeManagerIprProvider;", "Lcom/intellij/configurationStore/StreamProvider;", "subStateTagName", "", "comparator", "Ljava/util/Comparator;", "(Ljava/lang/String;Ljava/util/Comparator;)V", "isExclusive", "", "()Z", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "nameToData", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "copyIfNotExists", "", "provider", "delete", "fileSpec", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "load", "state", "Lorg/jdom/Element;", "keyGetter", "Lkotlin/Function1;", "processChildren", "path", "filter", "processor", "Lkotlin/Function3;", "Ljava/io/InputStream;", "read", "consumer", "write", "content", "size", "", "writeState", "intellij.platform.projectModel.impl"})
public final class SchemeManagerIprProvider
implements StreamProvider {
    private final ReentrantReadWriteLock lock;
    private LinkedHashMap<String, byte[]> nameToData;
    private final boolean isExclusive = false;
    private final String subStateTagName;
    private final Comparator<String> comparator;

    public boolean isExclusive() {
        return this.isExclusive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read(@NotNull String fileSpec, @NotNull RoamingType roamingType, @NotNull Function1<? super InputStream, Unit> consumer) {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            ByteArrayInputStream byteArrayInputStream;
            boolean bl = false;
            Function1<? super InputStream, Unit> function1 = consumer;
            byte[] byArray = this.nameToData.get(PathUtilRt.getFileName((String)fileSpec));
            if (byArray != null) {
                byte[] byArray2 = byArray;
                Function1<? super InputStream, Unit> function12 = function1;
                byte[] p1 = byArray2;
                boolean bl2 = false;
                byte[] byArray3 = p1;
                ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray3);
                function1 = function12;
                byteArrayInputStream = byteArrayInputStream2;
            } else {
                byteArrayInputStream = null;
            }
            function1.invoke(byteArrayInputStream);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        int n;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2;
        while (n3 < n4) {
            n = n3++;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            byte[] byArray = (byte[])this.nameToData.remove(PathUtilRt.getFileName((String)fileSpec));
        }
        finally {
            n = 0;
            int n5 = n2;
            while (n < n5) {
                int n6 = n++;
                readLock.lock();
            }
            writeLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processChildren(@NotNull String path, @NotNull RoamingType roamingType, @NotNull Function1<? super String, Boolean> filter, @NotNull Function3<? super String, ? super InputStream, ? super Boolean, Boolean> processor2) {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            Map map2 = this.nameToData;
            for (Map.Entry entry : map2.entrySet()) {
                boolean bl2;
                Object object = entry;
                String name = (String)object.getKey();
                object = entry;
                byte[] data = (byte[])object.getValue();
                if (!((Boolean)filter.invoke((Object)name)).booleanValue()) continue;
                object = data;
                object = new ByteArrayInputStream((byte[])object);
                Throwable throwable = null;
                try {
                    ByteArrayInputStream it = (ByteArrayInputStream)object;
                    boolean bl3 = false;
                    bl2 = (Boolean)processor2.invoke((Object)name, (Object)it, (Object)false);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                if (bl2) continue;
                break;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(@NotNull String fileSpec, @NotNull byte[] content, int size, @NotNull RoamingType roamingType) {
        int n;
        Object object = content;
        Logger logger = DefaultStateSerializerKt.getLOG();
        Object object2 = object;
        boolean bl = !(((byte[])object2).length == 0);
        logger.assertTrue(bl);
        object = this.lock;
        object2 = ((ReentrantReadWriteLock)object).readLock();
        int n2 = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2;
        while (n3 < n4) {
            n = n3++;
            ((ReentrantReadWriteLock.ReadLock)object2).unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
        writeLock.lock();
        try {
            boolean bl2 = false;
            byte[] byArray = this.nameToData.put(PathUtilRt.getFileName((String)fileSpec), ArrayUtil.realloc((byte[])content, (int)size));
        }
        finally {
            n = 0;
            int n5 = n2;
            while (n < n5) {
                int n6 = n++;
                ((ReentrantReadWriteLock.ReadLock)object2).lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(@Nullable Element state, @Nullable Function1<? super Element, String> keyGetter) {
        int n;
        if (state == null) {
            int n2;
            ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl = false;
                this.nameToData.clear();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n2 = 0;
                int n6 = n3;
                while (n2 < n6) {
                    int n7 = n2++;
                    readLock.lock();
                }
                writeLock.unlock();
            }
            return;
        }
        LinkedHashMap<String, byte[]> nameToData = new LinkedHashMap<String, byte[]>();
        UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
        for (Element child2 : state.getChildren(this.subStateTagName)) {
            CharSequence charSequence;
            Object name;
            if (JdomKt.isEmpty((Element)child2)) continue;
            Object object = keyGetter;
            if (object == null || (object = (String)object.invoke((Object)child2)) == null) {
                object = name = child2.getAttributeValue("name");
            }
            if (name == null) {
                for (Element optionElement : child2.getChildren("option")) {
                    if (!Intrinsics.areEqual((Object)optionElement.getAttributeValue("name"), (Object)"myName")) continue;
                    name = optionElement.getAttributeValue("value");
                }
            }
            if ((charSequence = (CharSequence)name) == null || charSequence.length() == 0) continue;
            nameToData.put(nameGenerator.generateUniqueName(FileUtil.sanitizeFileName(name, (boolean)false) + ".xml"), JdomKt.toByteArray((Element)child2));
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n8 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n9 = 0;
        int n10 = n8;
        while (n9 < n10) {
            n = n9++;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            if (this.comparator == null) {
                this.nameToData = nameToData;
            } else {
                this.nameToData.clear();
                this.nameToData.putAll(MapsKt.toSortedMap((Map)nameToData, this.comparator));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n = 0;
            int n11 = n8;
            while (n < n11) {
                int n12 = n++;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    public static /* synthetic */ void load$default(SchemeManagerIprProvider schemeManagerIprProvider, Element element, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        schemeManagerIprProvider.load(element, (Function1<? super Element, String>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeState(@NotNull Element state) {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            Comparable[] $receiver$iv = (Comparable[])this.nameToData.keySet();
            if ($receiver$iv == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Comparable[] thisCollection$iv = $receiver$iv;
            Object[] objectArray = thisCollection$iv.toArray(new String[0]);
            if (objectArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] names = objectArray;
            if (this.comparator == null) {
                $receiver$iv = (Comparable[])names;
                if ($receiver$iv == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
                }
                ArraysKt.sort((Object[])$receiver$iv);
            } else {
                ArraysKt.sortWith((Object[])names, this.comparator);
            }
            for (Object name : names) {
                byte[] byArray;
                if (this.nameToData.get(name) == null) continue;
                byte[] it = byArray;
                boolean bl2 = false;
                byte[] byArray2 = it;
                Element element = state;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
                element.addContent(JDOMUtil.load((InputStream)byteArrayInputStream));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void copyIfNotExists(@NotNull SchemeManagerIprProvider provider) {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            int n;
            boolean bl = false;
            ReentrantReadWriteLock reentrantReadWriteLock2 = provider.lock;
            ReentrantReadWriteLock.ReadLock readLock2 = reentrantReadWriteLock2.readLock();
            int n2 = reentrantReadWriteLock2.getWriteHoldCount() == 0 ? reentrantReadWriteLock2.getReadHoldCount() : 0;
            int n3 = 0;
            int n4 = n2;
            while (n3 < n4) {
                n = n3++;
                readLock2.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock2.writeLock();
            writeLock.lock();
            try {
                boolean bl2 = false;
                for (String key : this.nameToData.keySet()) {
                    if (provider.nameToData.containsKey(key)) continue;
                    LinkedHashMap<String, byte[]> linkedHashMap = provider.nameToData;
                    byte[] byArray = this.nameToData.get(key);
                    if (byArray == null) {
                        Intrinsics.throwNpe();
                    }
                    linkedHashMap.put(key, byArray);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n = 0;
                int n5 = n2;
                while (n < n5) {
                    int n6 = n++;
                    readLock2.lock();
                }
                writeLock.unlock();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    public SchemeManagerIprProvider(@NotNull String subStateTagName, @Nullable Comparator<String> comparator2) {
        this.subStateTagName = subStateTagName;
        this.comparator = comparator2;
        this.lock = new ReentrantReadWriteLock();
        this.nameToData = new LinkedHashMap();
    }

    public /* synthetic */ SchemeManagerIprProvider(String string, Comparator comparator2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            comparator2 = null;
        }
        this(string, comparator2);
    }

    public void write(@NotNull String path, @NotNull BufferExposingByteArrayOutputStream content, @NotNull RoamingType roamingType) {
        StreamProvider.DefaultImpls.write((StreamProvider)this, (String)path, (BufferExposingByteArrayOutputStream)content, (RoamingType)roamingType);
    }

    public boolean getEnabled() {
        return StreamProvider.DefaultImpls.getEnabled((StreamProvider)this);
    }

    public boolean isDisableExportAction() {
        return StreamProvider.DefaultImpls.isDisableExportAction((StreamProvider)this);
    }

    public boolean isApplicable(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        return StreamProvider.DefaultImpls.isApplicable((StreamProvider)this, (String)fileSpec, (RoamingType)roamingType);
    }
}

