/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ReloadComponentStoreStatus;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.configurationStore.schemeManager.SchemeChangeApplicator;
import com.intellij.configurationStore.schemeManager.SchemeChangeEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a4\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\t\u001a\u0014\u0010\u0012\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010\u001a\u001e\u0010\u0014\u001a\u00020\u00152\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\n\u001a\u00020\u0003H\u0000\u001a+\u0010\u0016\u001a\u0004\u0018\u0001H\u0017\"\b\b\u0000\u0010\u0017*\u00020\u0018*\b\u0012\u0004\u0012\u0002H\u00170\u00012\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010\u001b\" \u0010\u0000\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\" \u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"CHANGED_FILES_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/configurationStore/ComponentStoreImpl;", "Lcom/intellij/openapi/components/StateStorage;", "CHANGED_SCHEMES_KEY", "Lcom/intellij/configurationStore/schemeManager/SchemeChangeApplicator;", "Lcom/intellij/configurationStore/schemeManager/SchemeChangeEvent;", "askToRestart", "", "store", "Lcom/intellij/openapi/components/impl/stores/IComponentStore;", "notReloadableComponents", "", "", "changedStorages", "", "isApp", "reloadAppStore", "changes", "reloadStore", "Lcom/intellij/configurationStore/ReloadComponentStoreStatus;", "getAndClear", "T", "", "holder", "Lcom/intellij/openapi/util/UserDataHolderEx;", "(Lcom/intellij/openapi/util/Key;Lcom/intellij/openapi/util/UserDataHolderEx;)Ljava/lang/Object;", "intellij.platform.configurationStore.impl"})
public final class StoreAwareProjectManagerKt {
    private static final Key<MultiMap<ComponentStoreImpl, StateStorage>> CHANGED_FILES_KEY = new Key("CHANGED_FILES_KEY");
    private static final Key<MultiMap<SchemeChangeApplicator, SchemeChangeEvent>> CHANGED_SCHEMES_KEY = new Key("CHANGED_SCHEMES_KEY");

    public static final boolean reloadAppStore(@NotNull Set<? extends StateStorage> changes2) {
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)ApplicationManager.getApplication());
        if (iComponentStore == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
        }
        ReloadComponentStoreStatus status = StoreAwareProjectManagerKt.reloadStore(changes2, (ComponentStoreImpl)iComponentStore);
        if (status == ReloadComponentStoreStatus.RESTART_AGREED) {
            ApplicationManagerEx.getApplicationEx().restart(true);
            return false;
        }
        return status == ReloadComponentStoreStatus.SUCCESS || status == ReloadComponentStoreStatus.RESTART_CANCELLED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ReloadComponentStoreStatus reloadStore(@NotNull Set<? extends StateStorage> changedStorages, @NotNull ComponentStoreImpl store) {
        boolean willBeReloaded;
        Collection<String> notReloadableComponents;
        block11: {
            notReloadableComponents = null;
            willBeReloaded = false;
            try {
                notReloadableComponents = store.reload(changedStorages);
            }
            catch (Throwable e) {
                ComponentStoreImplKt.getLOG().warn(e);
                AppUIUtil.invokeOnEdt(new Runnable(e){
                    final /* synthetic */ Throwable $e;

                    public final void run() {
                        Messages.showWarningDialog((String)ProjectBundle.message((String)"project.reload.failed", (Object[])new Object[]{this.$e.getMessage()}), (String)ProjectBundle.message((String)"project.reload.failed.title", (Object[])new Object[0]));
                    }
                    {
                        this.$e = throwable;
                    }
                });
                ReloadComponentStoreStatus reloadComponentStoreStatus = ReloadComponentStoreStatus.ERROR;
                for (StateStorage stateStorage : changedStorages) {
                    if (!(stateStorage instanceof StateStorageBase)) continue;
                    ((StateStorageBase)stateStorage).enableSaving();
                }
                return reloadComponentStoreStatus;
            }
            if (notReloadableComponents != null && !notReloadableComponents.isEmpty()) break block11;
            ReloadComponentStoreStatus reloadComponentStoreStatus = ReloadComponentStoreStatus.SUCCESS;
            for (StateStorage stateStorage : changedStorages) {
                if (!(stateStorage instanceof StateStorageBase)) continue;
                ((StateStorageBase)stateStorage).enableSaving();
            }
            return reloadComponentStoreStatus;
        }
        try {
            willBeReloaded = StoreAwareProjectManagerKt.askToRestart(store, notReloadableComponents, changedStorages, store.getProject$intellij_platform_configurationStore_impl() == null);
            ReloadComponentStoreStatus reloadComponentStoreStatus = willBeReloaded ? ReloadComponentStoreStatus.RESTART_AGREED : ReloadComponentStoreStatus.RESTART_CANCELLED;
            return reloadComponentStoreStatus;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (!willBeReloaded) {
                for (StateStorage stateStorage : changedStorages) {
                    if (!(stateStorage instanceof StateStorageBase)) continue;
                    ((StateStorageBase)stateStorage).enableSaving();
                }
            }
        }
    }

    public static final boolean askToRestart(@NotNull IComponentStore store, @NotNull Collection<String> notReloadableComponents, @Nullable Set<? extends StateStorage> changedStorages, boolean isApp) {
        StringBuilder message = new StringBuilder();
        String storeName = store instanceof IProjectStore ? "Project '" + ((IProjectStore)store).getProjectName() + '\'' : "Application";
        message.append(storeName).append(' ');
        message.append("components were changed externally and cannot be reloaded:\n\n");
        int count = 0;
        for (String string : notReloadableComponents) {
            if (count == 10) {
                message.append('\n').append("and ").append(notReloadableComponents.size() - count).append(" more").append('\n');
                continue;
            }
            message.append(string).append('\n');
            ++count;
        }
        message.append("\nWould you like to ");
        if (isApp) {
            message.append(ApplicationManager.getApplication().isRestartCapable() ? "restart" : "shutdown").append(' ');
            message.append(ApplicationNamesInfo.getInstance().getProductName()).append('?');
        } else {
            message.append("reload project?");
        }
        if (Messages.showYesNoDialog((String)message.toString(), (String)(storeName + " Files Changed"), (Icon)Messages.getQuestionIcon()) == 0) {
            if (changedStorages != null) {
                for (StateStorage stateStorage : changedStorages) {
                    if (!(stateStorage instanceof StateStorageBase)) continue;
                    ((StateStorageBase)stateStorage).disableSaving();
                }
            }
            return true;
        }
        return false;
    }

    private static final <T> T getAndClear(@NotNull Key<T> $receiver, UserDataHolderEx holder) {
        Object object = holder.getUserData($receiver);
        if (object == null) {
            return null;
        }
        Object value = object;
        holder.replace($receiver, value, null);
        return (T)value;
    }

    public static final /* synthetic */ Key access$getCHANGED_FILES_KEY$p() {
        return CHANGED_FILES_KEY;
    }

    public static final /* synthetic */ Key access$getCHANGED_SCHEMES_KEY$p() {
        return CHANGED_SCHEMES_KEY;
    }

    public static final /* synthetic */ Object access$getAndClear(Key $receiver, UserDataHolderEx holder) {
        return StoreAwareProjectManagerKt.getAndClear($receiver, holder);
    }
}

