/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.schemeManager;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.StoreAwareProjectManager;
import com.intellij.configurationStore.schemeManager.AddScheme;
import com.intellij.configurationStore.schemeManager.RemoveAllSchemes;
import com.intellij.configurationStore.schemeManager.RemoveScheme;
import com.intellij.configurationStore.schemeManager.SchemeChangeApplicator;
import com.intellij.configurationStore.schemeManager.SchemeChangeEvent;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.configurationStore.schemeManager.UpdateScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.SmartList;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\rH\u0016J\u001e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\rH\u0002J\u001e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0016H\u0002J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/configurationStore/schemeManager/SchemeFileTracker;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "schemeManager", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;Lcom/intellij/openapi/project/Project;)V", "applicator", "Lcom/intellij/configurationStore/schemeManager/SchemeChangeApplicator;", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "handleDirectoryCreated", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileCreateEvent;", "list", "Lcom/intellij/configurationStore/schemeManager/SchemeChangeEvent;", "handleDirectoryDeleted", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/util/SmartList;", "isMyDirectory", "", "parent", "isMyFileWithoutParentCheck", "intellij.platform.configurationStore.impl"})
public final class SchemeFileTracker
implements BulkFileListener {
    private final SchemeChangeApplicator applicator;
    private final SchemeManagerImpl<Object, Object> schemeManager;
    private final Project project;

    public void after(@NotNull List<? extends VFileEvent> events) {
        SmartList list2 = new SmartList();
        for (VFileEvent collection : events) {
            String string;
            boolean bl;
            Logger logger;
            boolean $i$f$debug;
            Exception e$iv;
            Logger $receiver$iv;
            if (collection.getRequestor() instanceof SchemeManagerImpl) continue;
            VFileEvent vFileEvent = collection;
            if (vFileEvent instanceof VFileContentChangeEvent) {
                VirtualFile file2 = ((VFileContentChangeEvent)collection).getFile();
                if (!this.isMyFileWithoutParentCheck(file2) || !this.isMyDirectory(file2.getParent())) continue;
                $receiver$iv = ComponentStoreImplKt.getLOG();
                e$iv = null;
                $i$f$debug = false;
                if ($receiver$iv.isDebugEnabled()) {
                    logger = $receiver$iv;
                    bl = false;
                    string = "CHANGED " + file2.getPath();
                    logger.debug(string, (Throwable)e$iv);
                }
                list2.add((Object)new UpdateScheme(file2));
                continue;
            }
            if (vFileEvent instanceof VFileCreateEvent) {
                if (((VFileCreateEvent)collection).isDirectory()) {
                    this.handleDirectoryCreated((VFileCreateEvent)collection, (List)list2);
                    continue;
                }
                if (!this.schemeManager.canRead(((VFileCreateEvent)collection).getChildName()) || !this.isMyDirectory(((VFileCreateEvent)collection).getParent())) continue;
                VirtualFile virtualFile = ((VFileCreateEvent)collection).getFile();
                $receiver$iv = ComponentStoreImplKt.getLOG();
                e$iv = null;
                $i$f$debug = false;
                if ($receiver$iv.isDebugEnabled()) {
                    logger = $receiver$iv;
                    bl = false;
                    string = "CREATED " + ((VFileCreateEvent)collection).getPath() + " (virtualFile: " + (virtualFile == null ? "not " : "") + "found)";
                    logger.debug(string, (Throwable)e$iv);
                }
                VirtualFile virtualFile2 = virtualFile;
                if (virtualFile2 != null) {
                    Logger it = $receiver$iv = virtualFile2;
                    boolean bl2 = false;
                    list2.add((Object)new AddScheme((VirtualFile)it));
                }
                continue;
            }
            if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
            VirtualFile file2 = ((VFileDeleteEvent)collection).getFile();
            if (file2.isDirectory()) {
                this.handleDirectoryDeleted(file2, (SmartList<SchemeChangeEvent>)list2);
                continue;
            }
            if (!this.isMyFileWithoutParentCheck(file2) || !this.isMyDirectory(file2.getParent())) continue;
            $receiver$iv = ComponentStoreImplKt.getLOG();
            e$iv = null;
            $i$f$debug = false;
            if ($receiver$iv.isDebugEnabled()) {
                logger = $receiver$iv;
                bl = false;
                string = "DELETED " + file2.getPath();
                logger.debug(string, (Throwable)e$iv);
            }
            list2.add((Object)new RemoveScheme(file2.getName()));
        }
        Collection collection = (Collection)list2;
        if (!collection.isEmpty()) {
            ProjectManager projectManager = ProjectManager.getInstance();
            if (projectManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.StoreAwareProjectManager");
            }
            ((StoreAwareProjectManager)projectManager).registerChangedSchemes$intellij_platform_configurationStore_impl((List)list2, this.applicator, this.project);
        }
    }

    private final boolean isMyFileWithoutParentCheck(VirtualFile file2) {
        return this.schemeManager.canRead(file2.getNameSequence());
    }

    private final boolean isMyDirectory(VirtualFile parent) {
        VirtualFile virtualDirectory = this.schemeManager.getCachedVirtualDirectory$intellij_platform_configurationStore_impl();
        VirtualFile virtualFile = virtualDirectory;
        return virtualFile == null ? Intrinsics.areEqual((Object)PathKt.getSystemIndependentPath((Path)this.schemeManager.getIoDirectory$intellij_platform_configurationStore_impl()), (Object)parent.getPath()) : Intrinsics.areEqual((Object)virtualDirectory, (Object)parent);
    }

    private final void handleDirectoryDeleted(VirtualFile file2, SmartList<SchemeChangeEvent> list2) {
        if (!StringUtil.equals((CharSequence)file2.getNameSequence(), (CharSequence)((Object)this.schemeManager.getIoDirectory$intellij_platform_configurationStore_impl().getFileName()).toString())) {
            return;
        }
        Logger $receiver$iv = ComponentStoreImplKt.getLOG();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger = $receiver$iv;
            boolean bl = false;
            String string = "DIR DELETED " + file2.getPath();
            logger.debug(string, (Throwable)e$iv);
        }
        if (Intrinsics.areEqual((Object)file2, (Object)this.schemeManager.getVirtualDirectory$intellij_platform_configurationStore_impl())) {
            list2.add((Object)new RemoveAllSchemes());
        }
    }

    private final void handleDirectoryCreated(VFileCreateEvent event, List<SchemeChangeEvent> list2) {
        if (Intrinsics.areEqual((Object)event.getChildName(), (Object)((Object)this.schemeManager.getIoDirectory$intellij_platform_configurationStore_impl().getFileName()).toString()) ^ true) {
            return;
        }
        VirtualFile dir = this.schemeManager.getVirtualDirectory$intellij_platform_configurationStore_impl();
        VirtualFile virtualFile = event.getFile();
        if (Intrinsics.areEqual((Object)virtualFile, (Object)dir) ^ true) {
            return;
        }
        Logger $receiver$iv = ComponentStoreImplKt.getLOG();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger = $receiver$iv;
            boolean bl = false;
            VirtualFile virtualFile2 = virtualFile;
            String string = "DIR CREATED " + (virtualFile2 != null ? virtualFile2.getPath() : null);
            logger.debug(string, (Throwable)e$iv);
        }
        VirtualFile virtualFile3 = dir;
        if (virtualFile3 == null) {
            Intrinsics.throwNpe();
        }
        for (VirtualFile file2 : virtualFile3.getChildren()) {
            if (!this.isMyFileWithoutParentCheck(file2)) continue;
            list2.add(new AddScheme(file2));
        }
    }

    public SchemeFileTracker(@NotNull SchemeManagerImpl<Object, Object> schemeManager2, @NotNull Project project) {
        this.schemeManager = schemeManager2;
        this.project = project;
        this.applicator = new SchemeChangeApplicator(this.schemeManager);
    }
}

