/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.core.CoreModule;
import com.intellij.core.CoreProjectLoader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public class CoreModuleManager
extends ModuleManagerImpl {
    private final Disposable myParentDisposable;

    public CoreModuleManager(Project project, Disposable parentDisposable) {
        super(project);
        this.myParentDisposable = parentDisposable;
    }

    @Override
    @NotNull
    protected ModuleEx createModule(@NotNull String filePath) {
        return new CoreModule(this.myParentDisposable, this.myProject, filePath);
    }

    @Override
    @NotNull
    protected ModuleEx createAndLoadModule(@NotNull String filePath) throws IOException {
        ModuleEx module = this.createModule(filePath);
        VirtualFile vFile = StandardFileSystems.local().findFileByPath(filePath);
        try {
            assert (vFile != null);
            ModuleRootManagerImpl.ModuleRootManagerState state = new ModuleRootManagerImpl.ModuleRootManagerState();
            state.readExternal(CoreProjectLoader.loadStorageFile((ComponentManager)module, vFile).get("NewModuleRootManager"));
            ((ModuleRootManagerImpl)ModuleRootManager.getInstance((Module)module)).loadState(state);
        }
        catch (JDOMException e) {
            throw new IOException(e);
        }
        return module;
    }

    public void loadModules() {
        this.loadModules(this.myModuleModel);
    }

    protected Disposable getLifetime() {
        return this.myParentDisposable;
    }
}

