/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.kdbx.HashedBlockInputStream;
import com.intellij.credentialStore.kdbx.IncorrectMasterPasswordException;
import com.intellij.credentialStore.kdbx.KdbxHeader;
import com.intellij.credentialStore.kdbx.KeePassCredentials;
import com.intellij.credentialStore.kdbx.KeePassDatabase;
import com.intellij.credentialStore.kdbx.XmlProtectedValueTransformer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.io.PathKt;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.SkippingStreamCipher;
import org.bouncycastle.crypto.engines.Salsa20Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\b\u0010\u000e\u001a\u00020\u000fH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"SALSA20_IV", "", "createSalsa20StreamCipher", "Lorg/bouncycastle/crypto/SkippingStreamCipher;", "key", "loadKdbx", "Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "file", "Ljava/nio/file/Path;", "credentials", "Lcom/intellij/credentialStore/kdbx/KeePassCredentials;", "readKeePassDatabase", "inputStream", "Ljava/io/InputStream;", "sha256MessageDigest", "Ljava/security/MessageDigest;", "intellij.platform.credentialStore"})
public final class KdbxKt {
    private static final byte[] SALSA20_IV = new byte[]{-24, 48, 9, 75, -105, 32, 93, 42};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final KeePassDatabase loadKdbx(@NotNull Path file2, @NotNull KeePassCredentials credentials) throws IncorrectMasterPasswordException {
        KeePassDatabase keePassDatabase;
        Closeable closeable = PathKt.inputStream((Path)file2);
        int n = 8192;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        Throwable throwable = null;
        try {
            BufferedInputStream it = (BufferedInputStream)closeable;
            boolean bl = false;
            keePassDatabase = KdbxKt.readKeePassDatabase(credentials, it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return keePassDatabase;
    }

    private static final KeePassDatabase readKeePassDatabase(KeePassCredentials credentials, InputStream inputStream) {
        Element element;
        block2: {
            Element element2;
            KdbxHeader kdbxHeader = new KdbxHeader(inputStream);
            InputStream decryptedInputStream = kdbxHeader.createDecryptedStream(credentials.getKey(), inputStream);
            byte[] startBytes = FileUtilRt.loadBytes((InputStream)decryptedInputStream, (int)32);
            if (!Arrays.equals(startBytes, kdbxHeader.getStreamStartBytes())) {
                throw (Throwable)new IncorrectMasterPasswordException(false, 1, null);
            }
            InputStream resultInputStream = new HashedBlockInputStream(decryptedInputStream);
            if (kdbxHeader.getCompressionFlags() == KdbxHeader.CompressionFlags.GZIP) {
                resultInputStream = new GZIPInputStream(resultInputStream);
            }
            element = JDOMUtil.load((InputStream)resultInputStream);
            Element element3 = element.getChild("Root");
            if (element3 == null) break block2;
            Element rootElement = element2 = element3;
            boolean bl = false;
            new XmlProtectedValueTransformer(KdbxKt.createSalsa20StreamCipher(kdbxHeader.getProtectedStreamKey())).processEntries(rootElement);
        }
        return new KeePassDatabase(element);
    }

    @NotNull
    public static final MessageDigest sha256MessageDigest() {
        return MessageDigest.getInstance("SHA-256");
    }

    @NotNull
    public static final SkippingStreamCipher createSalsa20StreamCipher(@NotNull byte[] key) {
        Salsa20Engine streamCipher = new Salsa20Engine();
        KeyParameter keyParameter = new KeyParameter(KdbxKt.sha256MessageDigest().digest(key));
        streamCipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)keyParameter, SALSA20_IV));
        return (SkippingStreamCipher)streamCipher;
    }
}

