/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.configurationStore.JbXmlOutputter;
import com.intellij.credentialStore.kdbx.ProtectedValue;
import com.intellij.credentialStore.kdbx.SecureString;
import com.intellij.credentialStore.kdbx.UnsavedProtectedValue;
import java.io.Writer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.crypto.SkippingStreamCipher;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/credentialStore/kdbx/ProtectedXmlWriter;", "Lcom/intellij/configurationStore/JbXmlOutputter;", "streamCipher", "Lorg/bouncycastle/crypto/SkippingStreamCipher;", "(Lorg/bouncycastle/crypto/SkippingStreamCipher;)V", "writeContent", "", "out", "Ljava/io/Writer;", "element", "Lorg/jdom/Element;", "level", "", "intellij.platform.credentialStore"})
public final class ProtectedXmlWriter
extends JbXmlOutputter {
    private final SkippingStreamCipher streamCipher;

    @Override
    protected boolean writeContent(@NotNull Writer out, @NotNull Element element, int level) {
        Content value;
        if (Intrinsics.areEqual((Object)element.getName(), (Object)"Value") && (value = (Content)CollectionsKt.firstOrNull((List)element.getContent())) instanceof SecureString) {
            ProtectedValue protectedValue = null;
            if (value instanceof ProtectedValue) {
                ((ProtectedValue)value).setNewStreamCipher(this.streamCipher);
                protectedValue = (ProtectedValue)value;
            } else {
                byte[] bytes = ((UnsavedProtectedValue)value).getSecureString().getAsByteArray();
                int position = (int)this.streamCipher.getPosition();
                this.streamCipher.processBytes(bytes, 0, bytes.length, bytes, 0);
                protectedValue = new ProtectedValue(bytes, position, this.streamCipher);
                element.setContent((Content)protectedValue);
            }
            out.write(62);
            out.write(JbXmlOutputter.Companion.escapeElementEntities(protectedValue.encodeToBase64()));
            return true;
        }
        return super.writeContent(out, element, level);
    }

    public ProtectedXmlWriter(@NotNull SkippingStreamCipher streamCipher) {
        super(null, null, null, null, false, null, 47, null);
        this.streamCipher = streamCipher;
    }
}

