/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.propertyTable.editors;

import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.PropertyContext;
import com.intellij.designer.propertyTable.InplaceContext;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditor
extends PropertyEditor {
    public final JBTextField myTextField = new JBTextField();

    public TextEditor() {
        this.myTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextEditor.this.fireValueCommitted(true, true);
            }
        });
        this.myTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                TextEditor.this.preferredSizeChanged();
            }
        });
    }

    @Override
    @NotNull
    public JComponent getComponent(@Nullable PropertiesContainer container, @Nullable PropertyContext context, Object value, @Nullable InplaceContext inplaceContext) {
        this.setEditorValue(container, value);
        if (inplaceContext == null) {
            this.myTextField.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        } else {
            this.myTextField.setBorder(UIUtil.getTextFieldBorder());
            if (inplaceContext.isStartChar()) {
                this.myTextField.setText(inplaceContext.getText(this.myTextField.getText()));
            }
        }
        return this.myTextField;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myTextField;
    }

    @Override
    public Object getValue() throws Exception {
        return this.myTextField.getText();
    }

    protected void setEditorValue(@Nullable PropertiesContainer container, @Nullable Object value) {
        this.myTextField.setText(value == null ? "" : value.toString());
    }

    @Override
    public void updateUI() {
        SwingUtilities.updateComponentTreeUI((Component)this.myTextField);
    }
}

