/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.propertyTable.renderers;

import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.PropertyContext;
import com.intellij.designer.propertyTable.PropertyRenderer;
import com.intellij.designer.propertyTable.PropertyTable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LabelPropertyRenderer
extends JLabel
implements PropertyRenderer {
    @Nullable
    private final String myStaticText;

    public LabelPropertyRenderer(@Nullable String staticText) {
        this.myStaticText = staticText;
        this.setOpaque(true);
        this.putClientProperty("html.disable", true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
    }

    @Override
    @NotNull
    public JComponent getComponent(@Nullable PropertiesContainer container, PropertyContext context, @Nullable Object value, boolean selected, boolean hasFocus) {
        this.setText(null);
        this.setIcon(null);
        PropertyTable.updateRenderer(this, selected);
        if (value != null) {
            this.customize(value);
        }
        return this;
    }

    protected void customize(@NotNull Object value) {
        this.setText(this.myStaticText != null ? this.myStaticText : value.toString());
    }
}

