/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.util.containers.ContainerUtil;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMessage {
    private final Date myDate = Calendar.getInstance().getTime();
    private boolean myIsRead;
    private Runnable myOnReadCallback;
    private boolean myIsSubmitting;
    private SubmittedReportInfo mySubmissionInfo;
    private String myAdditionalInfo;
    private Integer myAssigneeId;

    @NotNull
    public abstract Throwable getThrowable();

    @NotNull
    public abstract String getThrowableText();

    @Nullable
    public abstract String getMessage();

    @NotNull
    public List<Attachment> getAllAttachments() {
        return Collections.emptyList();
    }

    @NotNull
    public List<Attachment> getIncludedAttachments() {
        return ContainerUtil.filter(this.getAllAttachments(), Attachment::isIncluded);
    }

    @NotNull
    public Date getDate() {
        return this.myDate;
    }

    public boolean isRead() {
        return this.myIsRead;
    }

    public void setRead(boolean isRead) {
        this.myIsRead = isRead;
        if (isRead && this.myOnReadCallback != null) {
            this.myOnReadCallback.run();
            this.myOnReadCallback = null;
        }
    }

    public void setOnReadCallback(Runnable callback2) {
        this.myOnReadCallback = callback2;
    }

    public boolean isSubmitting() {
        return this.myIsSubmitting;
    }

    public void setSubmitting(boolean isSubmitting) {
        this.myIsSubmitting = isSubmitting;
    }

    public SubmittedReportInfo getSubmissionInfo() {
        return this.mySubmissionInfo;
    }

    public void setSubmitted(SubmittedReportInfo info) {
        this.myIsSubmitting = false;
        this.mySubmissionInfo = info;
    }

    public boolean isSubmitted() {
        return this.mySubmissionInfo != null && (this.mySubmissionInfo.getStatus() == SubmittedReportInfo.SubmissionStatus.NEW_ISSUE || this.mySubmissionInfo.getStatus() == SubmittedReportInfo.SubmissionStatus.DUPLICATE);
    }

    public String getAdditionalInfo() {
        return this.myAdditionalInfo;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.myAdditionalInfo = additionalInfo;
    }

    @Nullable
    public Integer getAssigneeId() {
        return this.myAssigneeId;
    }

    public void setAssigneeId(@Nullable Integer assigneeId) {
        this.myAssigneeId = assigneeId;
    }

    @Deprecated
    public List<Attachment> getAttachments() {
        return this.getIncludedAttachments();
    }
}

