/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.ErrorReportConfigurable;
import com.intellij.diagnostic.ITNProxy;
import com.intellij.diagnostic.ITNReporterKt;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J=\u0010\n\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/diagnostic/ITNReporter;", "Lcom/intellij/openapi/diagnostic/ErrorReportSubmitter;", "()V", "getPrivacyNoticeText", "", "getReportActionText", "showErrorInRelease", "", "event", "Lcom/intellij/openapi/diagnostic/IdeaLoggingEvent;", "submit", "events", "", "additionalInfo", "parentComponent", "Ljava/awt/Component;", "consumer", "Lcom/intellij/util/Consumer;", "Lcom/intellij/openapi/diagnostic/SubmittedReportInfo;", "([Lcom/intellij/openapi/diagnostic/IdeaLoggingEvent;Ljava/lang/String;Ljava/awt/Component;Lcom/intellij/util/Consumer;)Z", "intellij.platform.ide.impl"})
public class ITNReporter
extends ErrorReportSubmitter {
    @NotNull
    public String getReportActionText() {
        return DiagnosticBundle.message("error.report.to.jetbrains.action", new Object[0]);
    }

    @NotNull
    public String getPrivacyNoticeText() {
        return CredentialAttributesKt.isFulfilled((Credentials)ErrorReportConfigurable.Companion.getCredentials()) ? DiagnosticBundle.message("error.dialog.notice.named", new Object[0]) : DiagnosticBundle.message("error.dialog.notice.anonymous", new Object[0]);
    }

    public boolean submit(@NotNull IdeaLoggingEvent[] events, @Nullable String additionalInfo, @Nullable Component parentComponent, @NotNull Consumer<SubmittedReportInfo> consumer) {
        long l;
        IdeaLoggingEvent event = events[0];
        IdeaPluginDescriptor plugin = IdeErrorsDialog.getPlugin(event);
        String lastActionId = IdeaLogger.ourLastActionId;
        int previousReportId = -1;
        Pair previousException = ITNReporterKt.access$getPreviousReport$p();
        Object eventData = event.getData();
        if (previousException != null && eventData instanceof AbstractMessage && 0L <= (l = ((AbstractMessage)eventData).getDate().getTime() - ((Number)previousException.getFirst()).longValue()) && 600000L >= l) {
            previousReportId = ((Number)previousException.getSecond()).intValue();
        }
        IdeaPluginDescriptor ideaPluginDescriptor = plugin;
        IdeaPluginDescriptor ideaPluginDescriptor2 = plugin;
        IdeaPluginDescriptor ideaPluginDescriptor3 = plugin;
        ITNProxy.ErrorBean errorBean = new ITNProxy.ErrorBean(event, additionalInfo, ideaPluginDescriptor3 != null && (ideaPluginDescriptor3 = ideaPluginDescriptor3.getPluginId()) != null ? ideaPluginDescriptor3.getIdString() : null, ideaPluginDescriptor != null ? ideaPluginDescriptor.getName() : null, ideaPluginDescriptor2 != null ? ideaPluginDescriptor2.getVersion() : null, lastActionId, previousReportId);
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(parentComponent));
        return ITNReporterKt.access$submit(errorBean, consumer, parentComponent, project);
    }

    public boolean showErrorInRelease(@NotNull IdeaLoggingEvent event) {
        return false;
    }
}

