/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaReportingEvent
extends IdeaLoggingEvent {
    private final TextBasedThrowable myThrowable;
    private final IdeaPluginDescriptor myPlugin;

    public IdeaReportingEvent(@NotNull AbstractMessage messageObject, String message, @NotNull String stacktrace, IdeaPluginDescriptor plugin) {
        super(message, null, (Object)messageObject);
        this.myThrowable = new TextBasedThrowable(stacktrace);
        this.myPlugin = plugin;
    }

    @Nullable
    public String getOriginalMessage() {
        return this.getData().getMessage();
    }

    @NotNull
    public String getOriginalThrowableText() {
        return this.getData().getThrowableText();
    }

    @Nullable
    public IdeaPluginDescriptor getPlugin() {
        return this.myPlugin;
    }

    public Throwable getThrowable() {
        return this.myThrowable;
    }

    public String getThrowableText() {
        return this.myThrowable.myStacktrace;
    }

    @NotNull
    public AbstractMessage getData() {
        return (AbstractMessage)super.getData();
    }

    static class TextBasedThrowable
    extends Throwable {
        private final String myStacktrace;

        TextBasedThrowable(String stacktrace) {
            this.myStacktrace = stacktrace;
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            s.print(this.myStacktrace);
        }

        @Override
        public void printStackTrace(PrintStream s) {
            s.print(this.myStacktrace);
        }
    }
}

