/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.EditXmxVMOptionDialog;
import com.intellij.diagnostic.IdePerformanceListener;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.IdeBundle;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.PlatformUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class LowMemoryNotifier
implements Disposable {
    private static final String PERFORMANCE = "performance";
    private static final int UI_RESPONSE_LOGGING_INTERVAL_MS = 100000;
    private static final int TOLERABLE_UI_LATENCY = 100;
    private final LowMemoryWatcher myWatcher = PlatformUtils.isAndroidStudio() ? null : LowMemoryWatcher.register(this::onLowMemorySignalReceived, (LowMemoryWatcher.LowMemoryWatcherType)LowMemoryWatcher.LowMemoryWatcherType.ONLY_AFTER_GC);
    private final AtomicBoolean myNotificationShown = new AtomicBoolean();
    private volatile long myPreviousLoggedUIResponse = 0L;

    public LowMemoryNotifier() {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(IdePerformanceListener.TOPIC, (Object)new IdePerformanceListener(){

            public void uiFreezeFinished(int lengthInSeconds) {
                LifecycleUsageTriggerCollector.onFreeze(lengthInSeconds);
            }

            public void uiResponded(long latencyMs) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - LowMemoryNotifier.this.myPreviousLoggedUIResponse >= 100000L) {
                    LowMemoryNotifier.this.myPreviousLoggedUIResponse = currentTime;
                    FUCounterUsageLogger.getInstance().logEvent(LowMemoryNotifier.PERFORMANCE, "ui.latency", new FeatureUsageData().addData("duration_ms", latencyMs));
                }
                if (latencyMs >= 100L) {
                    FUCounterUsageLogger.getInstance().logEvent(LowMemoryNotifier.PERFORMANCE, "ui.lagging", new FeatureUsageData().addData("duration_ms", latencyMs));
                }
            }
        });
    }

    private void onLowMemorySignalReceived() {
        if (this.myNotificationShown.compareAndSet(false, true)) {
            Notification notification = new Notification(IdeBundle.message((String)"low.memory.notification.title", (Object[])new Object[0]), IdeBundle.message((String)"low.memory.notification.title", (Object[])new Object[0]), IdeBundle.message((String)"low.memory.notification.content", (Object[])new Object[0]), NotificationType.WARNING);
            notification.addAction((AnAction)new NotificationAction(IdeBundle.message((String)"low.memory.notification.action", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    Runtime rt = Runtime.getRuntime();
                    new EditXmxVMOptionDialog(rt.freeMemory(), rt.maxMemory()).show();
                    notification.expire();
                }
            });
            Notifications.Bus.notify((Notification)notification);
        }
    }

    public void dispose() {
        if (this.myWatcher != null) {
            this.myWatcher.stop();
        }
    }
}

