/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VMOptions {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.diagnostic.VMOptions");

    public static int readOption(@NotNull MemoryKind kind, boolean effective) {
        List<String> arguments;
        if (effective) {
            arguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        } else {
            File file2 = VMOptions.getWriteFile();
            if (file2 == null || !file2.exists()) {
                return -1;
            }
            try {
                String content = FileUtil.loadFile((File)file2);
                arguments = Collections.singletonList(content);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                return -1;
            }
        }
        for (String argument : arguments) {
            Matcher m = kind.pattern.matcher(argument);
            if (!m.find()) continue;
            try {
                int value = Integer.parseInt(m.group(1));
                double multiplier = VMOptions.parseUnit(m.group(2));
                return (int)((double)value * multiplier);
            }
            catch (NumberFormatException e) {
                LOG.info((Throwable)e);
                break;
            }
        }
        return -1;
    }

    private static double parseUnit(String unitString) {
        if (StringUtil.startsWithIgnoreCase((String)unitString, (String)"k")) {
            return 9.765625E-4;
        }
        if (StringUtil.startsWithIgnoreCase((String)unitString, (String)"g")) {
            return 1024.0;
        }
        return 1.0;
    }

    public static void writeOption(@NotNull MemoryKind option2, int value) {
        String optionValue = option2.option + value + "m";
        VMOptions.writeGeneralOption(option2.pattern, optionValue);
    }

    public static void writeOption(@NotNull String option2, @NotNull String separator, @NotNull String value) {
        VMOptions.writeGeneralOption(Pattern.compile("-D" + option2 + separator + "(true|false)*([a-zA-Z0-9]*)"), "-D" + option2 + separator + value);
    }

    private static void writeGeneralOption(@NotNull Pattern pattern, @NotNull String value) {
        File file2 = VMOptions.getWriteFile();
        if (file2 == null) {
            LOG.warn("VM options file not configured");
            return;
        }
        try {
            String content;
            String string = content = file2.exists() ? FileUtil.loadFile((File)file2) : "# custom Android Studio VM options, see https://developer.android.com/studio/intro/studio-config.html\n";
            if (!StringUtil.isEmptyOrSpaces((String)content)) {
                Matcher m = pattern.matcher(content);
                if (m.find()) {
                    StringBuffer b = new StringBuffer();
                    m.appendReplacement(b, Matcher.quoteReplacement(value));
                    m.appendTail(b);
                    content = b.toString();
                } else {
                    content = StringUtil.trimTrailing((String)content) + SystemProperties.getLineSeparator() + value;
                }
            } else {
                content = value;
            }
            if (file2.exists()) {
                FileUtil.setReadOnlyAttribute((String)file2.getPath(), (boolean)false);
            } else {
                FileUtil.ensureExists((File)file2.getParentFile());
            }
            FileUtil.writeToFile((File)file2, (String)content);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @Nullable
    public static String read() {
        try {
            File newFile = VMOptions.getWriteFile();
            if (newFile != null && newFile.exists()) {
                return FileUtil.loadFile((File)newFile);
            }
            String vmOptionsFile = System.getProperty("jb.vmOptionsFile");
            if (vmOptionsFile != null) {
                return FileUtil.loadFile((File)new File(vmOptionsFile));
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        return null;
    }

    @Nullable
    public static File getWriteFile() {
        String vmOptionsFile = System.getProperty("jb.vmOptionsFile");
        if (vmOptionsFile == null) {
            return null;
        }
        if (!PathManager.isUnderHomeDirectory((String)(vmOptionsFile = new File(vmOptionsFile).getAbsolutePath()))) {
            return new File(vmOptionsFile);
        }
        String location = PathManager.getCustomOptionsDirectory();
        if (location == null) {
            return null;
        }
        return new File(location, VMOptions.getCustomVMOptionsFileName());
    }

    @NotNull
    public static String getCustomVMOptionsFileName() {
        String fileName2 = ApplicationNamesInfo.getInstance().getProductName().toLowerCase(Locale.US);
        if (SystemInfo.is64Bit && !SystemInfo.isMac) {
            fileName2 = fileName2 + "64";
        }
        if (SystemInfo.isWindows) {
            fileName2 = fileName2 + ".exe";
        }
        fileName2 = fileName2 + ".vmoptions";
        return fileName2;
    }

    @Deprecated
    public static int readXmx() {
        return VMOptions.readOption(MemoryKind.HEAP, true);
    }

    public static enum MemoryKind {
        HEAP("Xmx", ""),
        PERM_GEN("XX:MaxPermSize", "="),
        METASPACE("XX:MaxMetaspaceSize", "="),
        CODE_CACHE("XX:ReservedCodeCacheSize", "=");

        public final String optionName;
        public final String option;
        private final Pattern pattern;

        private MemoryKind(String name, String separator) {
            this.optionName = name;
            this.option = "-" + name + separator;
            this.pattern = Pattern.compile(this.option + "(\\d*)([a-zA-Z]*)");
        }
    }
}

