/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.UIBundle;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class EditLogPatternDialog
extends DialogWrapper {
    private JPanel myWholePanel;
    private JTextField myNameField;
    private JCheckBox myShowFilesCombo;
    private TextFieldWithBrowseButton myFilePattern;

    public EditLogPatternDialog() {
        super(true);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(DiagnosticBundle.message("log.monitor.edit.aliases.title", objectArray));
        this.init();
    }

    public void init(String name, String pattern, boolean showAll) {
        this.myNameField.setText(name);
        this.myFilePattern.setText(pattern);
        this.myShowFilesCombo.setSelected(showAll);
        this.setOKActionEnabled(pattern != null && pattern.length() > 0);
    }

    protected JComponent createCenterPanel() {
        this.myFilePattern.addBrowseFolderListener(UIBundle.message((String)"file.chooser.default.title", (Object[])new Object[0]), null, null, FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.myFilePattern.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                EditLogPatternDialog.this.setOKActionEnabled(EditLogPatternDialog.this.myFilePattern.getText() != null && EditLogPatternDialog.this.myFilePattern.getText().length() > 0);
            }
        });
        return this.myWholePanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    public boolean isShowAllFiles() {
        return this.myShowFilesCombo.isSelected();
    }

    public String getName() {
        String name = this.myNameField.getText();
        if (name != null && name.length() > 0) {
            return name;
        }
        return this.myFilePattern.getText();
    }

    public String getLogPattern() {
        return this.myFilePattern.getText();
    }

    protected String getHelpId() {
        return "reference.run.configuration.edit.logfile.aliases";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextField jTextField;
        JPanel jPanel;
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/DiagnosticBundle").getString("log.monitor.edit.aliases.name"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/DiagnosticBundle").getString("log.monitor.edit.aliases.location"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFilePattern = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myShowFilesCombo = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/DiagnosticBundle").getString("log.monitor.edit.aliases.show.all.checkbox.title"));
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

