/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.logging.LogConsoleManager;
import com.intellij.execution.configurations.AdditionalTabComponentManager;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Alarm;
import com.intellij.util.SingleAlarm;
import gnu.trove.THashSet;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogFilesManager {
    private final LogConsoleManager myManager;
    private final List<LogFile> myLogFiles = new ArrayList<LogFile>();
    private final SingleAlarm myUpdateAlarm;

    public LogFilesManager(final @NotNull Project project, @NotNull LogConsoleManager manager, @NotNull Disposable parentDisposable) {
        this.myManager = manager;
        this.myUpdateAlarm = new SingleAlarm(new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                for (LogFile logFile : new ArrayList(LogFilesManager.this.myLogFiles)) {
                    ProcessHandler process2 = logFile.getProcess();
                    if (process2 != null && process2.isProcessTerminated()) {
                        LogFilesManager.this.myLogFiles.remove(logFile);
                        continue;
                    }
                    Set<String> oldPaths = logFile.getPaths();
                    Set newPaths = logFile.getOptions().getPaths();
                    logFile.setPaths(newPaths);
                    THashSet obsoletePaths = new THashSet(oldPaths);
                    obsoletePaths.removeAll(newPaths);
                    try {
                        SwingUtilities.invokeAndWait(() -> this.lambda$run$1(project, logFile, oldPaths, newPaths, (Set)obsoletePaths));
                    }
                    catch (InterruptedException | InvocationTargetException exception) {}
                }
                if (!LogFilesManager.this.myLogFiles.isEmpty()) {
                    LogFilesManager.this.myUpdateAlarm.cancelAndRequest();
                }
            }

            private /* synthetic */ void lambda$run$1(Project project2, LogFile logFile, Set oldPaths, Set newPaths, Set obsoletePaths) {
                if (project2.isDisposed()) {
                    return;
                }
                LogFilesManager.this.addConfigurationConsoles(logFile.getOptions(), (Condition<? super String>)file2 -> !oldPaths.contains(file2), newPaths, logFile.getConfiguration());
                for (String each : obsoletePaths) {
                    LogFilesManager.this.myManager.removeLogConsole(each);
                }
            }
        }, 500, Alarm.ThreadToUse.POOLED_THREAD, parentDisposable);
    }

    public void addLogConsoles(@NotNull RunConfigurationBase<?> runConfiguration, @Nullable ProcessHandler startedProcess) {
        for (LogFileOptions logFileOptions : runConfiguration.getAllLogFiles()) {
            if (!logFileOptions.isEnabled()) continue;
            this.myLogFiles.add(new LogFile(logFileOptions, runConfiguration, startedProcess));
        }
        this.myUpdateAlarm.request();
        runConfiguration.createAdditionalTabComponents((AdditionalTabComponentManager)this.myManager, startedProcess);
    }

    private void addConfigurationConsoles(@NotNull LogFileOptions logFile, @NotNull Condition<? super String> shouldInclude, @NotNull Set<String> paths, @NotNull RunConfigurationBase runConfiguration) {
        if (paths.isEmpty()) {
            return;
        }
        TreeMap<String, String> titleToPath = new TreeMap<String, String>();
        if (paths.size() == 1) {
            String path = paths.iterator().next();
            if (shouldInclude.value((Object)path)) {
                titleToPath.put(logFile.getName(), path);
            }
        } else {
            for (String path : paths) {
                if (!shouldInclude.value((Object)path)) continue;
                String title = new File(path).getName();
                if (titleToPath.containsKey(title)) {
                    title = path;
                }
                titleToPath.put(title, path);
            }
        }
        for (String title : titleToPath.keySet()) {
            String path = (String)titleToPath.get(title);
            assert (path != null);
            this.myManager.addLogConsole(title, path, logFile.getCharset(), logFile.isSkipContent() ? new File(path).length() : 0L, runConfiguration);
        }
    }

    private static class LogFile {
        private final LogFileOptions myOptions;
        private final RunConfigurationBase myConfiguration;
        private final ProcessHandler myProcess;
        private Set<String> myPaths = new HashSet<String>();

        LogFile(LogFileOptions options, RunConfigurationBase configuration2, ProcessHandler process2) {
            this.myOptions = options;
            this.myConfiguration = configuration2;
            this.myProcess = process2;
        }

        public LogFileOptions getOptions() {
            return this.myOptions;
        }

        public RunConfigurationBase getConfiguration() {
            return this.myConfiguration;
        }

        public ProcessHandler getProcess() {
            return this.myProcess;
        }

        public Set<String> getPaths() {
            return this.myPaths;
        }

        public void setPaths(Set<String> paths) {
            this.myPaths = paths;
        }
    }
}

