/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Range;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Block {
    private static final Logger LOG = Logger.getInstance(Block.class);
    @NotNull
    private final String[] mySource;
    private final int myStart;
    private final int myEnd;

    public Block(@NotNull String source, int start2, int end) {
        this(Block.tokenize(source), start2, end);
    }

    public Block(@NotNull String[] source, int start2, int end) {
        this.mySource = source;
        this.myStart = DiffUtil.bound(start2, 0, source.length);
        this.myEnd = DiffUtil.bound(end, this.myStart, source.length);
    }

    @NotNull
    public static String[] tokenize(@NotNull String text) {
        return LineTokenizer.tokenize((CharSequence)text, (boolean)false, (boolean)false);
    }

    @NotNull
    public Block createPreviousBlock(@NotNull String prevContent) {
        return this.createPreviousBlock(Block.tokenize(prevContent));
    }

    @NotNull
    public Block createPreviousBlock(@NotNull String[] prevContent) {
        try {
            FairDiffIterable iterable = ByLine.compare(Arrays.asList(prevContent), Arrays.asList(this.mySource), ComparisonPolicy.IGNORE_WHITESPACES, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
            boolean greedy = this.myStart != this.myEnd;
            int start2 = this.myStart;
            int end = this.myEnd;
            int shift = 0;
            for (Range range2 : iterable.iterateChanges()) {
                int changeStart = range2.start2 + shift;
                int changeEnd = range2.end2 + shift;
                int changeShift = range2.end1 - range2.start1 - (range2.end2 - range2.start2);
                DiffUtil.UpdatedLineRange updatedRange = DiffUtil.updateRangeOnModification(start2, end, changeStart, changeEnd, changeShift, greedy);
                start2 = updatedRange.startLine;
                end = updatedRange.endLine;
                shift += changeShift;
            }
            if (start2 < 0 || end > prevContent.length || end < start2) {
                LOG.error("Invalid block range: [" + start2 + ", " + end + "); length - " + prevContent.length);
            }
            for (Range range2 : iterable.iterateUnchanged()) {
                int count = range2.end1 - range2.start1;
                for (int i = 0; i < count; ++i) {
                    int prevIndex = range2.start1 + i;
                    int sourceIndex = range2.start2 + i;
                    if (!prevContent[prevIndex].equals(this.mySource[sourceIndex])) continue;
                    prevContent[prevIndex] = this.mySource[sourceIndex];
                }
            }
            return new Block(prevContent, start2, end);
        }
        catch (DiffTooBigException e) {
            return new Block(prevContent, 0, 0);
        }
    }

    @NotNull
    public String getBlockContent() {
        return StringUtil.join(this.getLines(), (String)"\n");
    }

    @NotNull
    public List<String> getLines() {
        return Arrays.asList(this.mySource).subList(this.myStart, this.myEnd);
    }

    public int hashCode() {
        return Arrays.hashCode(this.mySource) ^ this.myStart ^ this.myEnd;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Block)) {
            return false;
        }
        Block other = (Block)object;
        return this.myStart == other.myStart && this.myEnd == other.myEnd && Arrays.equals(this.mySource, other.mySource);
    }

    public int getStart() {
        return this.myStart;
    }

    public int getEnd() {
        return this.myEnd;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        this.appendLines(result2, 0, this.myStart);
        result2.append("<-----------------------------\n");
        this.appendLines(result2, this.myStart, this.myEnd);
        result2.append("----------------------------->\n");
        this.appendLines(result2, this.myEnd, this.mySource.length);
        return result2.toString();
    }

    private void appendLines(@NotNull StringBuilder result2, int from, int to) {
        for (int i = from; i < to; ++i) {
            result2.append(this.mySource[i]);
            result2.append("\n");
        }
    }
}

