/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.codeInsight.daemon.OutsidersPsiFileSupport;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.actions.DocumentFragmentContent;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DirectoryContentImpl;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.contents.FileContentImpl;
import com.intellij.diff.contents.FileDocumentContentImpl;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UIBasedFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.testFramework.BinaryLightVirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.LightColors;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffContentFactoryImpl
extends DiffContentFactoryEx {
    private static final Logger LOG = Logger.getInstance(DiffContentFactoryImpl.class);

    @NotNull
    public EmptyContent createEmpty() {
        return new EmptyContent();
    }

    @NotNull
    public DocumentContent create(@NotNull String text) {
        return this.create(null, text);
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable FileType type) {
        return this.create(null, text, type);
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable FileType type, boolean respectLineSeparators) {
        return this.create(null, text, type, respectLineSeparators);
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable VirtualFile highlightFile) {
        return this.create(null, text, highlightFile);
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable DocumentContent referent) {
        return this.create(null, text, referent);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text) {
        return this.create(project, text, (FileType)null);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text, @Nullable FileType type) {
        return this.create(project, text, type, true);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text, @Nullable FileType type, boolean respectLineSeparators) {
        return DiffContentFactoryImpl.createImpl(project, text, type, null, null, null, respectLineSeparators, true);
    }

    @Override
    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text, @NotNull FilePath filePath) {
        return DiffContentFactoryImpl.createImpl(project, text, filePath.getFileType(), filePath, filePath.getName(), filePath.getVirtualFile(), true, true);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text, @Nullable VirtualFile highlightFile) {
        FileType fileType = highlightFile != null ? highlightFile.getFileType() : null;
        FilePath filePath = highlightFile != null ? VcsUtil.getFilePath((VirtualFile)highlightFile) : null;
        String fileName2 = highlightFile != null ? highlightFile.getName() : null;
        return DiffContentFactoryImpl.createImpl(project, text, fileType, filePath, fileName2, highlightFile, true, true);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull String text, @Nullable DocumentContent referent) {
        if (referent == null) {
            return this.create(text);
        }
        return DiffContentFactoryImpl.createImpl(project, text, referent.getContentType(), null, null, referent.getHighlightFile(), false, true);
    }

    @NotNull
    public DocumentContent createEditable(@Nullable Project project, @NotNull String text, @Nullable FileType fileType) {
        return DiffContentFactoryImpl.createImpl(project, text, fileType, null, null, null, false, false);
    }

    @NotNull
    public DocumentContent create(@NotNull Document document, @Nullable DocumentContent referent) {
        return this.create(null, document, referent);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull Document document) {
        return this.create(project, document, (FileType)null);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull Document document, @Nullable FileType fileType) {
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 != null) {
            return new FileDocumentContentImpl(project, document, file2);
        }
        return new DocumentContentImpl(project, document, fileType, null, null, null, null);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull Document document, @Nullable VirtualFile highlightFile) {
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 != null && file2.equals(highlightFile)) {
            return new FileDocumentContentImpl(project, document, file2);
        }
        if (highlightFile == null) {
            return new DocumentContentImpl(document);
        }
        return new DocumentContentImpl(project, document, highlightFile.getFileType(), highlightFile, null, null, null);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull Document document, @Nullable DocumentContent referent) {
        if (referent == null) {
            return new DocumentContentImpl(document);
        }
        return new DocumentContentImpl(project, document, referent.getContentType(), referent.getHighlightFile(), null, null, null);
    }

    @NotNull
    public DiffContent create(@Nullable Project project, @NotNull VirtualFile file2) {
        return DiffContentFactoryImpl.createContentFromFile(project, file2);
    }

    @Nullable
    public DocumentContent createDocument(@Nullable Project project, @NotNull VirtualFile file2) {
        return (DocumentContent)ObjectUtils.tryCast((Object)DiffContentFactoryImpl.createContentFromFile(project, file2), DocumentContent.class);
    }

    @Nullable
    public FileContent createFile(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2.isDirectory()) {
            return null;
        }
        return (FileContent)this.create(project, file2);
    }

    @NotNull
    public DocumentContent createFragment(@Nullable Project project, @NotNull Document document, @NotNull TextRange range2) {
        DocumentContent content = this.create(project, document);
        return this.createFragment(project, content, range2);
    }

    @NotNull
    public DocumentContent createFragment(@Nullable Project project, @NotNull DocumentContent content, @NotNull TextRange range2) {
        return new DocumentFragmentContent(project, content, range2);
    }

    @NotNull
    public DiffContent createClipboardContent() {
        return this.createClipboardContent(null, null);
    }

    @NotNull
    public DocumentContent createClipboardContent(@Nullable DocumentContent referent) {
        return this.createClipboardContent(null, referent);
    }

    @NotNull
    public DiffContent createClipboardContent(@Nullable Project project) {
        return this.createClipboardContent(project, null);
    }

    @NotNull
    public DocumentContent createClipboardContent(@Nullable Project project, @Nullable DocumentContent referent) {
        String text = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        FileType type = referent != null ? referent.getContentType() : null;
        VirtualFile highlightFile = referent != null ? referent.getHighlightFile() : null;
        FilePath filePath = highlightFile != null ? VcsUtil.getFilePath((VirtualFile)highlightFile) : null;
        return DiffContentFactoryImpl.createImpl(project, StringUtil.notNullize((String)text), type, filePath, "Clipboard.txt", highlightFile, false, false);
    }

    @Override
    @NotNull
    public DiffContent createFromBytes(@Nullable Project project, @NotNull byte[] content, @NotNull FilePath filePath) throws IOException {
        return this.createFromBytes(project, content, filePath, null);
    }

    @Override
    @NotNull
    public DiffContent createFromBytes(@Nullable Project project, @NotNull byte[] content, @NotNull FilePath filePath, @Nullable Charset defaultCharset) throws IOException {
        if (defaultCharset == null && DiffContentFactoryImpl.isBinaryContent(content, filePath.getFileType())) {
            return DiffContentFactoryImpl.createBinaryImpl(project, content, filePath.getFileType(), filePath, filePath.getVirtualFile());
        }
        return DiffContentFactoryImpl.createDocumentFromBytes(project, content, filePath, defaultCharset);
    }

    @NotNull
    public DiffContent createFromBytes(@Nullable Project project, @NotNull byte[] content, @NotNull FileType fileType, @NotNull String fileName2) throws IOException {
        if (DiffContentFactoryImpl.isBinaryContent(content, fileType)) {
            return DiffContentFactoryImpl.createBinaryImpl(project, content, fileType, VcsUtil.getFilePath((String)fileName2), null);
        }
        return this.createDocumentFromBytes(project, content, fileType, fileName2);
    }

    @Override
    @NotNull
    public DiffContent createFromBytes(@Nullable Project project, @NotNull byte[] content, @NotNull VirtualFile highlightFile) throws IOException {
        if (DiffContentFactoryImpl.isBinaryContent(content, highlightFile.getFileType())) {
            return DiffContentFactoryImpl.createBinaryImpl(project, content, highlightFile.getFileType(), VcsUtil.getFilePath((VirtualFile)highlightFile), highlightFile);
        }
        return this.createDocumentFromBytes(project, content, highlightFile);
    }

    @Override
    @NotNull
    public DocumentContent createDocumentFromBytes(@Nullable Project project, @NotNull byte[] content, @NotNull FileType fileType, @NotNull String fileName2) {
        Charset charset = DiffContentFactoryImpl.guessCharset(project, content, fileType);
        return DiffContentFactoryImpl.createFromBytesImpl(project, content, fileType, null, fileName2, null, charset);
    }

    @Override
    @NotNull
    public DocumentContent createDocumentFromBytes(@Nullable Project project, @NotNull byte[] content, @NotNull FilePath filePath) {
        Charset charset = DiffContentFactoryImpl.guessCharset(content, filePath);
        return DiffContentFactoryImpl.createFromBytesImpl(project, content, filePath.getFileType(), filePath, filePath.getName(), filePath.getVirtualFile(), charset);
    }

    @NotNull
    private static DocumentContent createDocumentFromBytes(@Nullable Project project, @NotNull byte[] content, @NotNull FilePath filePath, @Nullable Charset defaultCharset) {
        Charset charset = DiffContentFactoryImpl.guessCharset(content, filePath.getFileType(), defaultCharset != null ? defaultCharset : filePath.getCharset());
        return DiffContentFactoryImpl.createFromBytesImpl(project, content, filePath.getFileType(), filePath, filePath.getName(), filePath.getVirtualFile(), charset);
    }

    @Override
    @NotNull
    public DocumentContent createDocumentFromBytes(@Nullable Project project, @NotNull byte[] content, @NotNull VirtualFile highlightFile) {
        Charset charset = DiffContentFactoryImpl.guessCharset(content, highlightFile);
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)highlightFile);
        return DiffContentFactoryImpl.createFromBytesImpl(project, content, highlightFile.getFileType(), filePath, highlightFile.getName(), highlightFile, charset);
    }

    @NotNull
    public DiffContent createBinary(@Nullable Project project, @NotNull byte[] content, @NotNull FileType type, @NotNull String fileName2) throws IOException {
        return DiffContentFactoryImpl.createBinaryImpl(project, content, type, VcsUtil.getFilePath((String)fileName2), null);
    }

    @NotNull
    private static DiffContent createContentFromFile(@Nullable Project project, @NotNull VirtualFile file2) {
        return DiffContentFactoryImpl.createContentFromFile(project, file2, file2);
    }

    @NotNull
    private static DiffContent createContentFromFile(@Nullable Project project, @NotNull VirtualFile file2, @Nullable VirtualFile highlightFile) {
        if (file2.isDirectory()) {
            return new DirectoryContentImpl(project, file2, highlightFile);
        }
        Document document = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(file2));
        if (document != null) {
            return new FileDocumentContentImpl(project, document, file2, highlightFile);
        }
        return new FileContentImpl(project, file2, highlightFile);
    }

    @NotNull
    private static DiffContent createBinaryImpl(@Nullable Project project, @NotNull byte[] content, @NotNull FileType type, @NotNull FilePath path, @Nullable VirtualFile highlightFile) throws IOException {
        Object file2;
        boolean useTemporalFile;
        boolean bl = useTemporalFile = type instanceof ArchiveFileType || BinaryFileTypeDecompilers.INSTANCE.forFileType(type) != null;
        if (useTemporalFile) {
            file2 = DiffContentFactoryImpl.createTemporalFile(project, "tmp", path.getName(), content);
        } else {
            file2 = new MyBinaryLightVirtualFile(path, type, content);
            file2.setWritable(false);
        }
        file2.putUserData(DiffUtil.TEMP_FILE_KEY, (Object)Boolean.TRUE);
        return DiffContentFactoryImpl.createContentFromFile(project, file2, highlightFile);
    }

    @NotNull
    private static DocumentContent createImpl(@Nullable Project project, @NotNull String text, @Nullable FileType fileType, @Nullable FilePath originalFilePath, @Nullable String fileName2, @Nullable VirtualFile highlightFile, boolean respectLineSeparators, boolean readOnly) {
        return DiffContentFactoryImpl.createImpl(project, text, fileType, originalFilePath, fileName2, highlightFile, null, null, respectLineSeparators, readOnly);
    }

    @NotNull
    private static DocumentContent createImpl(@Nullable Project project, @NotNull String text, @Nullable FileType fileType, @Nullable FilePath originalFilePath, @Nullable String fileName2, @Nullable VirtualFile highlightFile, @Nullable Charset charset, @Nullable Boolean bom, boolean respectLineSeparators, boolean readOnly) {
        if (FileTypes.UNKNOWN.equals(fileType)) {
            fileType = PlainTextFileType.INSTANCE;
        }
        LineSeparator separator = respectLineSeparators ? StringUtil.detectSeparators((CharSequence)text) : null;
        String correctedContent = StringUtil.convertLineSeparators((String)text);
        Document document = DiffContentFactoryImpl.createDocument(project, correctedContent, fileType, originalFilePath, fileName2, readOnly);
        DocumentContentImpl content = new DocumentContentImpl(project, document, (FileType)fileType, highlightFile, separator, charset, bom);
        if (fileName2 != null) {
            content.putUserData(DiffUserDataKeysEx.FILE_NAME, fileName2);
        }
        return content;
    }

    @NotNull
    private static DocumentContent createFromBytesImpl(@Nullable Project project, @NotNull byte[] content, @NotNull FileType fileType, @Nullable FilePath originalFilePath, @NotNull String fileName2, @Nullable VirtualFile highlightFile, @NotNull Charset charset) {
        if (fileType.isBinary()) {
            fileType = PlainTextFileType.INSTANCE;
        }
        boolean isBOM = CharsetToolkit.guessFromBOM((byte[])content) != null;
        boolean malformedContent = false;
        String text = CharsetToolkit.tryDecodeString((byte[])content, (Charset)charset);
        if (text == null) {
            text = CharsetToolkit.decodeString((byte[])content, (Charset)charset);
            malformedContent = true;
        }
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(project, text, fileType, originalFilePath, fileName2, highlightFile, charset, isBOM, true, true);
        if (malformedContent) {
            String notificationText = "Content was decoded with errors (using '" + charset.name() + "' charset)";
            DiffUtil.addNotification(DiffNotifications.createNotification(notificationText, LightColors.RED), (UserDataHolder)documentContent);
        }
        return documentContent;
    }

    @NotNull
    private static VirtualFile createTemporalFile(@Nullable Project project, @NotNull String prefix, @NotNull String suffix, @NotNull byte[] content) throws IOException {
        VirtualFile file2;
        File tempFile = FileUtil.createTempFile((String)PathUtil.suggestFileName((String)(prefix + "_"), (boolean)true, (boolean)false), (String)PathUtil.suggestFileName((String)("_" + suffix), (boolean)true, (boolean)false), (boolean)true);
        if (content.length != 0) {
            FileUtil.writeToFile((File)tempFile, (byte[])content);
        }
        if (!tempFile.setWritable(false, false)) {
            LOG.warn("Can't set writable attribute of temporal file");
        }
        if ((file2 = VfsUtil.findFileByIoFile((File)tempFile, (boolean)true)) == null) {
            throw new IOException("Can't create temp file for revision content");
        }
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{file2});
        return file2;
    }

    @NotNull
    private static Document createDocument(@Nullable Project project, @NotNull String content, @Nullable FileType fileType, @Nullable FilePath originalFilePath, @Nullable String fileName2, boolean readOnly) {
        Document document;
        if (project != null && !project.isDefault() && fileType != null && !fileType.isBinary() && Registry.is((String)"diff.enable.psi.highlighting")) {
            if (fileName2 == null) {
                fileName2 = "diff." + StringUtil.defaultIfEmpty((String)fileType.getDefaultExtension(), (String)"txt");
            }
            if ((document = DiffContentFactoryImpl.createPsiDocument(project, content, fileType, originalFilePath, fileName2, readOnly)) != null) {
                return document;
            }
        }
        document = EditorFactory.getInstance().createDocument((CharSequence)content);
        document.setReadOnly(readOnly);
        return document;
    }

    @Nullable
    private static Document createPsiDocument(@NotNull Project project, @NotNull String content, @NotNull FileType fileType, @Nullable FilePath originalFilePath, @NotNull String fileName2, boolean readOnly) {
        return (Document)ReadAction.compute(() -> {
            LightVirtualFile file2 = new LightVirtualFile(fileName2, fileType, (CharSequence)content);
            file2.setWritable(!readOnly);
            OutsidersPsiFileSupport.markFile((VirtualFile)file2, originalFilePath != null ? originalFilePath.getPath() : null);
            Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)file2);
            if (document == null) {
                return null;
            }
            PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            return document;
        });
    }

    private static boolean isBinaryContent(@NotNull byte[] content, @NotNull FileType fileType) {
        if (UnknownFileType.INSTANCE.equals(fileType)) {
            return DiffContentFactoryImpl.guessCharsetFromContent(content) == null;
        }
        if (fileType instanceof UIBasedFileType) {
            return true;
        }
        return fileType.isBinary();
    }

    @NotNull
    public static Charset guessCharset(@NotNull byte[] content, @NotNull FilePath filePath) {
        return DiffContentFactoryImpl.guessCharset(content, filePath.getFileType(), filePath.getCharset());
    }

    @NotNull
    public static Charset guessCharset(@NotNull byte[] content, @NotNull VirtualFile highlightFile) {
        return DiffContentFactoryImpl.guessCharset(content, highlightFile.getFileType(), highlightFile.getCharset());
    }

    @NotNull
    public static Charset guessCharset(@Nullable Project project, @NotNull byte[] content, @NotNull FileType fileType) {
        EncodingManager e = project != null ? EncodingProjectManager.getInstance((Project)project) : EncodingManager.getInstance();
        return DiffContentFactoryImpl.guessCharset(content, fileType, e.getDefaultCharset());
    }

    @NotNull
    private static Charset guessCharset(@NotNull byte[] content, @NotNull FileType fileType, @NotNull Charset defaultCharset) {
        Charset guessedCharset;
        Charset bomCharset = CharsetToolkit.guessFromBOM((byte[])content);
        if (bomCharset != null) {
            return bomCharset;
        }
        if (fileType.isBinary() && (guessedCharset = DiffContentFactoryImpl.guessCharsetFromContent(content)) != null) {
            return guessedCharset;
        }
        return defaultCharset;
    }

    @Nullable
    private static Charset guessCharsetFromContent(@NotNull byte[] content) {
        CharsetToolkit toolkit = new CharsetToolkit(content);
        Charset fromBOM = toolkit.guessFromBOM();
        if (fromBOM != null) {
            return fromBOM;
        }
        CharsetToolkit.GuessedEncoding guessedEncoding = toolkit.guessFromContent(content.length);
        switch (guessedEncoding) {
            case SEVEN_BIT: {
                return Charset.forName("US-ASCII");
            }
            case VALID_UTF8: {
                return CharsetToolkit.UTF8_CHARSET;
            }
        }
        return null;
    }

    private static class MyBinaryLightVirtualFile
    extends BinaryLightVirtualFile {
        private final FilePath myPath;

        MyBinaryLightVirtualFile(@NotNull FilePath path, FileType type, @NotNull byte[] content) {
            super(path.getName(), type, content);
            this.myPath = path;
        }

        @NotNull
        public String getPath() {
            return this.myPath.getPath();
        }
    }
}

