/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.actions.BaseShowDiffAction;
import com.intellij.diff.actions.impl.MutableDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.Side;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareClipboardWithSelectionAction
extends BaseShowDiffAction {
    @Nullable
    private static Editor getEditor(@NotNull AnActionEvent e) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor != null) {
            return editor;
        }
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        return FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
    }

    @Nullable
    private static FileType getEditorFileType(@NotNull AnActionEvent e) {
        DiffContent content = (DiffContent)e.getData(DiffDataKeys.CURRENT_CONTENT);
        if (content != null && content.getContentType() != null) {
            return content.getContentType();
        }
        DiffRequest request = (DiffRequest)e.getData(DiffDataKeys.DIFF_REQUEST);
        if (request instanceof ContentDiffRequest) {
            for (DiffContent diffContent : ((ContentDiffRequest)request).getContents()) {
                FileType type = diffContent.getContentType();
                if (type == null || type == UnknownFileType.INSTANCE) continue;
                return type;
            }
        }
        return null;
    }

    @Override
    protected boolean isAvailable(@NotNull AnActionEvent e) {
        Editor editor = CompareClipboardWithSelectionAction.getEditor(e);
        return editor != null;
    }

    @Override
    @Nullable
    protected DiffRequestChain getDiffRequestChain(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        Editor editor = CompareClipboardWithSelectionAction.getEditor(e);
        FileType editorFileType = CompareClipboardWithSelectionAction.getEditorFileType(e);
        assert (editor != null);
        DiffContent selectedContent = (DiffContent)e.getData(DiffDataKeys.CURRENT_CONTENT);
        DocumentContent content2 = CompareClipboardWithSelectionAction.createContent(project, editor, editorFileType, selectedContent);
        DocumentContent content1 = DiffContentFactory.getInstance().createClipboardContent(project, content2);
        MutableDiffRequestChain chain = new MutableDiffRequestChain((DiffContent)content1, (DiffContent)content2);
        chain.setWindowTitle(DiffBundle.message((String)"diff.clipboard.vs.editor.dialog.title", (Object[])new Object[0]));
        chain.setTitle1(DiffBundle.message((String)"diff.content.clipboard.content.title", (Object[])new Object[0]));
        chain.setTitle2(CompareClipboardWithSelectionAction.createContentTitle(editor));
        int currentLine = editor.getCaretModel().getLogicalPosition().line;
        chain.putRequestUserData(DiffUserDataKeys.SCROLL_TO_LINE, Pair.create((Object)Side.RIGHT, (Object)currentLine));
        return chain;
    }

    @NotNull
    private static DocumentContent createContent(@Nullable Project project, @NotNull Editor editor, @Nullable FileType type, @Nullable DiffContent selectedContent) {
        SelectionModel selectionModel;
        Document editorDocument;
        Document contentDocument;
        DocumentContent content = null;
        if (selectedContent instanceof DocumentContent && (contentDocument = ((DocumentContent)selectedContent).getDocument()).equals(editorDocument = editor.getDocument())) {
            content = (DocumentContent)selectedContent;
        }
        if (content == null) {
            content = DiffContentFactory.getInstance().create(project, editor.getDocument(), type);
        }
        if ((selectionModel = editor.getSelectionModel()).hasSelection()) {
            TextRange range2 = new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
            content = DiffContentFactory.getInstance().createFragment(project, content, range2);
        }
        if (editor.isViewer()) {
            content.putUserData(DiffUserDataKeys.FORCE_READ_ONLY, (Object)true);
        }
        return content;
    }

    @NotNull
    private static String createContentTitle(@NotNull Editor editor) {
        String title;
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(editor.getDocument());
        String string = title = file2 != null ? DiffRequestFactory.getInstance().getContentTitle(file2) : "Editor";
        if (editor.getSelectionModel().hasSelection()) {
            title = DiffBundle.message((String)"diff.content.selection.from.file.content.title", (Object[])new Object[]{title});
        }
        return title;
    }
}

