/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.actions.DocumentsSynchronizer;
import com.intellij.diff.contents.DiffContentBase;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.LineCol;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import gnu.trove.TIntFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentFragmentContent
extends DiffContentBase
implements DocumentContent {
    @NotNull
    private final DocumentContent myOriginal;
    @NotNull
    private final RangeMarker myRangeMarker;
    @NotNull
    private final MyDocumentsSynchronizer mySynchronizer;
    private int myAssignments = 0;

    public DocumentFragmentContent(@Nullable Project project, @NotNull DocumentContent original, @NotNull TextRange range2) {
        this(project, original, DocumentFragmentContent.createRangeMarker(original.getDocument(), range2));
    }

    public DocumentFragmentContent(@Nullable Project project, @NotNull DocumentContent original, @NotNull RangeMarker rangeMarker) {
        this.myOriginal = original;
        this.myRangeMarker = rangeMarker;
        Document document1 = this.myOriginal.getDocument();
        Document document2 = EditorFactory.getInstance().createDocument((CharSequence)"");
        document2.putUserData(UndoManager.ORIGINAL_DOCUMENT, (Object)document1);
        this.mySynchronizer = new MyDocumentsSynchronizer(project, this.myRangeMarker, document1, document2);
        TIntFunction originalLineConvertor = (TIntFunction)original.getUserData(DiffUserDataKeysEx.LINE_NUMBER_CONVERTOR);
        this.putUserData(DiffUserDataKeysEx.LINE_NUMBER_CONVERTOR, value -> {
            if (!this.myRangeMarker.isValid()) {
                return -1;
            }
            int line = value + document1.getLineNumber(this.myRangeMarker.getStartOffset());
            return originalLineConvertor != null ? originalLineConvertor.execute(line) : line;
        });
    }

    @NotNull
    private static RangeMarker createRangeMarker(@NotNull Document document, @NotNull TextRange range2) {
        RangeMarker rangeMarker = document.createRangeMarker(range2.getStartOffset(), range2.getEndOffset(), true);
        rangeMarker.setGreedyToLeft(true);
        rangeMarker.setGreedyToRight(true);
        return rangeMarker;
    }

    @NotNull
    public Document getDocument() {
        return this.mySynchronizer.getDocument2();
    }

    @Nullable
    public VirtualFile getHighlightFile() {
        return this.myOriginal.getHighlightFile();
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull LineCol position) {
        if (!this.myRangeMarker.isValid()) {
            return null;
        }
        int offset = position.toOffset(this.getDocument());
        int originalOffset = offset + this.myRangeMarker.getStartOffset();
        LineCol originalPosition = LineCol.fromOffset((Document)this.myOriginal.getDocument(), (int)originalOffset);
        return this.myOriginal.getNavigatable(originalPosition);
    }

    @Nullable
    public FileType getContentType() {
        return this.myOriginal.getContentType();
    }

    @Nullable
    public Navigatable getNavigatable() {
        return this.getNavigatable(new LineCol(0));
    }

    public void onAssigned(boolean isAssigned) {
        if (isAssigned) {
            if (this.myAssignments == 0) {
                this.mySynchronizer.startListen();
            }
            ++this.myAssignments;
        } else {
            --this.myAssignments;
            if (this.myAssignments == 0) {
                this.mySynchronizer.stopListen();
            }
        }
        assert (this.myAssignments >= 0);
    }

    private static class MyDocumentsSynchronizer
    extends DocumentsSynchronizer {
        @NotNull
        private final RangeMarker myRangeMarker;

        MyDocumentsSynchronizer(@Nullable Project project, @NotNull RangeMarker range2, @NotNull Document document1, @NotNull Document document2) {
            super(project, document1, document2);
            this.myRangeMarker = range2;
        }

        @Override
        protected void onDocumentChanged1(@NotNull DocumentEvent event) {
            if (!this.myRangeMarker.isValid()) {
                this.myDocument2.setReadOnly(false);
                this.replaceString(this.myDocument2, 0, this.myDocument2.getTextLength(), "Invalid selection range");
                this.myDocument2.setReadOnly(true);
                return;
            }
            CharSequence newText = this.myDocument1.getCharsSequence().subSequence(this.myRangeMarker.getStartOffset(), this.myRangeMarker.getEndOffset());
            this.replaceString(this.myDocument2, 0, this.myDocument2.getTextLength(), newText);
        }

        @Override
        protected void onDocumentChanged2(@NotNull DocumentEvent event) {
            if (!this.myRangeMarker.isValid()) {
                return;
            }
            if (!this.myDocument1.isWritable()) {
                return;
            }
            CharSequence newText = event.getNewFragment();
            int originalOffset = event.getOffset() + this.myRangeMarker.getStartOffset();
            int originalEnd = originalOffset + event.getOldLength();
            this.replaceString(this.myDocument1, originalOffset, originalEnd, newText);
        }

        @Override
        public void startListen() {
            if (this.myRangeMarker.isValid()) {
                this.myDocument2.setReadOnly(false);
                CharSequence nexText = this.myDocument1.getCharsSequence().subSequence(this.myRangeMarker.getStartOffset(), this.myRangeMarker.getEndOffset());
                this.replaceString(this.myDocument2, 0, this.myDocument2.getTextLength(), nexText);
                this.myDocument2.setReadOnly(!this.myDocument1.isWritable());
            } else {
                this.myDocument2.setReadOnly(false);
                this.replaceString(this.myDocument2, 0, this.myDocument2.getTextLength(), "Invalid selection range");
                this.myDocument2.setReadOnly(true);
            }
            super.startListen();
        }
    }
}

