/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import java.beans.PropertyChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class DocumentsSynchronizer {
    @NotNull
    protected final Document myDocument1;
    @NotNull
    protected final Document myDocument2;
    @Nullable
    private final Project myProject;
    private boolean myDuringModification = false;
    private final DocumentListener myListener1 = new DocumentListener(){

        public void documentChanged(@NotNull DocumentEvent e) {
            if (DocumentsSynchronizer.this.myDuringModification) {
                return;
            }
            DocumentsSynchronizer.this.onDocumentChanged1(e);
        }
    };
    private final DocumentListener myListener2 = new DocumentListener(){

        public void documentChanged(@NotNull DocumentEvent e) {
            if (DocumentsSynchronizer.this.myDuringModification) {
                return;
            }
            DocumentsSynchronizer.this.onDocumentChanged2(e);
        }
    };
    private final PropertyChangeListener myROListener = event -> {
        if ("writable".equals(event.getPropertyName())) {
            this.getDocument2().setReadOnly(!this.getDocument1().isWritable());
        }
    };

    protected DocumentsSynchronizer(@Nullable Project project, @NotNull Document document1, @NotNull Document document2) {
        this.myProject = project;
        this.myDocument1 = document1;
        this.myDocument2 = document2;
    }

    @NotNull
    public Document getDocument1() {
        return this.myDocument1;
    }

    @NotNull
    public Document getDocument2() {
        return this.myDocument2;
    }

    protected abstract void onDocumentChanged1(@NotNull DocumentEvent var1);

    protected abstract void onDocumentChanged2(@NotNull DocumentEvent var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceString(@NotNull Document document, int startOffset, int endOffset, @NotNull CharSequence newText) {
        try {
            this.myDuringModification = true;
            CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> document.replaceString(startOffset, endOffset, newText)), "Synchronize document and its fragment", (Object)document);
        }
        finally {
            this.myDuringModification = false;
        }
    }

    public void startListen() {
        this.myDocument1.addDocumentListener(this.myListener1);
        this.myDocument2.addDocumentListener(this.myListener2);
        this.myDocument1.addPropertyChangeListener(this.myROListener);
    }

    public void stopListen() {
        this.myDocument1.removeDocumentListener(this.myListener1);
        this.myDocument2.removeDocumentListener(this.myListener2);
        this.myDocument1.removePropertyChangeListener(this.myROListener);
    }
}

