/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions.impl;

import com.intellij.diff.actions.impl.GoToChangePopupAction;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Key;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;

public class GoToChangePopupBuilder {
    private static final Key<JBPopup> POPUP_KEY = Key.create((String)"Diff.RequestChainGoToPopup");

    @NotNull
    public static AnAction create(@NotNull DiffRequestChain chain, @NotNull Consumer<Integer> onSelected) {
        if (chain instanceof Chain) {
            return ((Chain)chain).createGoToChangeAction(onSelected);
        }
        return new SimpleGoToChangePopupAction(chain, onSelected);
    }

    private static class SimpleGoToChangePopupAction
    extends BaseGoToChangePopupAction<DiffRequestChain> {
        @NotNull
        protected final Consumer<Integer> myOnSelected;

        SimpleGoToChangePopupAction(@NotNull DiffRequestChain chain, @NotNull Consumer<Integer> onSelected) {
            super(chain);
            this.myOnSelected = onSelected;
        }

        @Override
        @NotNull
        protected JBPopup createPopup(@NotNull AnActionEvent e) {
            return JBPopupFactory.getInstance().createListPopup((ListPopupStep)new MyListPopupStep());
        }

        private class MyListPopupStep
        extends BaseListPopupStep<DiffRequestProducer> {
            MyListPopupStep() {
                super("Go To Change", SimpleGoToChangePopupAction.this.myChain.getRequests());
                this.setDefaultOptionIndex(SimpleGoToChangePopupAction.this.myChain.getIndex());
            }

            @NotNull
            public String getTextFor(DiffRequestProducer value) {
                return value.getName();
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public PopupStep onChosen(DiffRequestProducer selectedValue, boolean finalChoice) {
                return this.doFinalStep(() -> {
                    int index = SimpleGoToChangePopupAction.this.myChain.getRequests().indexOf(selectedValue);
                    SimpleGoToChangePopupAction.this.myOnSelected.consume((Object)index);
                });
            }
        }
    }

    public static abstract class BaseGoToChangePopupAction<Chain extends DiffRequestChain>
    extends GoToChangePopupAction {
        @NotNull
        protected final Chain myChain;

        public BaseGoToChangePopupAction(@NotNull Chain chain) {
            this.myChain = chain;
        }

        public void update(@NotNull AnActionEvent e) {
            if (this.myChain.getRequests().size() <= 1) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setEnabledAndVisible(true);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            JBPopup oldPopup = (JBPopup)this.myChain.getUserData(POPUP_KEY);
            if (oldPopup != null && oldPopup.isVisible()) {
                oldPopup.cancel();
            }
            final JBPopup popup2 = this.createPopup(e);
            this.myChain.putUserData(POPUP_KEY, (Object)popup2);
            popup2.addListener((JBPopupListener)new JBPopupAdapter(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (myChain.getUserData(POPUP_KEY) == popup2) {
                        myChain.putUserData(POPUP_KEY, null);
                    }
                }
            });
            InputEvent event = e.getInputEvent();
            if (event instanceof MouseEvent) {
                popup2.show(new RelativePoint((MouseEvent)event));
            } else {
                popup2.showInBestPositionFor(e.getDataContext());
            }
        }

        @NotNull
        protected abstract JBPopup createPopup(@NotNull AnActionEvent var1);
    }

    public static interface Chain
    extends DiffRequestChain {
        @NotNull
        public AnAction createGoToChangeAction(@NotNull Consumer<? super Integer> var1);
    }
}

