/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions.impl;

import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.HighlightingLevel;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.AbstractToggleUseSoftWrapsAction;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetEditorSettingsAction
extends ActionGroup
implements DumbAware {
    @NotNull
    private final TextDiffSettingsHolder.TextDiffSettings myTextSettings;
    @NotNull
    private final List<? extends Editor> myEditors;
    @Nullable
    private SyncScrollSupport.Support mySyncScrollSupport;
    @NotNull
    private final AnAction[] myActions;

    public SetEditorSettingsAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull List<? extends Editor> editors) {
        super("Editor Settings", null, AllIcons.General.GearPlain);
        this.setPopup(true);
        this.myTextSettings = settings;
        this.myEditors = editors;
        for (Editor editor : this.myEditors) {
            ((EditorGutterComponentEx)editor.getGutter()).setGutterPopupGroup(this);
        }
        this.myActions = new AnAction[]{new EditorSettingToggleAction("EditorToggleShowWhitespaces"){

            @Override
            public boolean isSelected() {
                return SetEditorSettingsAction.this.myTextSettings.isShowWhitespaces();
            }

            @Override
            public void setSelected(boolean state) {
                SetEditorSettingsAction.this.myTextSettings.setShowWhitespaces(state);
            }

            @Override
            public void apply(@NotNull Editor editor, boolean value) {
                if (editor.getSettings().isWhitespacesShown() != value) {
                    editor.getSettings().setWhitespacesShown(value);
                    editor.getComponent().repaint();
                }
            }
        }, new EditorSettingToggleAction("EditorToggleShowLineNumbers"){

            @Override
            public boolean isSelected() {
                return SetEditorSettingsAction.this.myTextSettings.isShowLineNumbers();
            }

            @Override
            public void setSelected(boolean state) {
                SetEditorSettingsAction.this.myTextSettings.setShowLineNumbers(state);
            }

            @Override
            public void apply(@NotNull Editor editor, boolean value) {
                if (editor.getSettings().isLineNumbersShown() != value) {
                    editor.getSettings().setLineNumbersShown(value);
                    editor.getComponent().repaint();
                }
            }
        }, new EditorSettingToggleAction("EditorToggleShowIndentLines"){

            @Override
            public boolean isSelected() {
                return SetEditorSettingsAction.this.myTextSettings.isShowIndentLines();
            }

            @Override
            public void setSelected(boolean state) {
                SetEditorSettingsAction.this.myTextSettings.setShowIndentLines(state);
            }

            @Override
            public void apply(@NotNull Editor editor, boolean value) {
                if (editor.getSettings().isIndentGuidesShown() != value) {
                    editor.getSettings().setIndentGuidesShown(value);
                    editor.getComponent().repaint();
                }
            }
        }, new EditorSettingToggleAction("EditorToggleUseSoftWraps"){
            private boolean myForcedSoftWrap;

            @Override
            public boolean isSelected() {
                return this.myForcedSoftWrap || SetEditorSettingsAction.this.myTextSettings.isUseSoftWraps();
            }

            @Override
            public void setSelected(boolean state) {
                this.myForcedSoftWrap = false;
                SetEditorSettingsAction.this.myTextSettings.setUseSoftWraps(state);
            }

            @Override
            public void apply(@NotNull Editor editor, boolean value) {
                if (editor.getSettings().isUseSoftWraps() == value) {
                    return;
                }
                if (SetEditorSettingsAction.this.mySyncScrollSupport != null) {
                    SetEditorSettingsAction.this.mySyncScrollSupport.enterDisableScrollSection();
                }
                try {
                    AbstractToggleUseSoftWrapsAction.toggleSoftWraps(editor, null, value);
                }
                finally {
                    if (SetEditorSettingsAction.this.mySyncScrollSupport != null) {
                        SetEditorSettingsAction.this.mySyncScrollSupport.exitDisableScrollSection();
                    }
                }
            }

            @Override
            public void applyDefaults(@NotNull List<? extends Editor> editors) {
                if (!SetEditorSettingsAction.this.myTextSettings.isUseSoftWraps()) {
                    for (Editor editor : editors) {
                        this.myForcedSoftWrap = this.myForcedSoftWrap || ((EditorImpl)editor).shouldSoftWrapsBeForced();
                    }
                }
                super.applyDefaults(editors);
            }
        }, new EditorHighlightingLayerAction()};
    }

    public void setSyncScrollSupport(@Nullable SyncScrollSupport.Support syncScrollSupport) {
        this.mySyncScrollSupport = syncScrollSupport;
    }

    public void applyDefaults() {
        for (AnAction action : this.myActions) {
            ((EditorSettingAction)action).applyDefaults(this.myEditors);
        }
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction editorSettingsGroup = ActionManager.getInstance().getAction("Diff.EditorGutterPopupMenu.EditorSettings");
        ArrayList<Object> actions = new ArrayList<Object>();
        ContainerUtil.addAll(actions, (Object[])this.myActions);
        actions.add(editorSettingsGroup);
        actions.add(Separator.getInstance());
        if (e != null && "DiffToolbar".equals(e.getPlace())) {
            return actions.toArray(AnAction.EMPTY_ARRAY);
        }
        ActionGroup gutterGroup = (ActionGroup)ActionManager.getInstance().getAction("Diff.EditorGutterPopupMenu");
        ArrayList result2 = ContainerUtil.newArrayList((Object[])gutterGroup.getChildren(e));
        result2.add(Separator.getInstance());
        SetEditorSettingsAction.replaceOrAppend(result2, editorSettingsGroup, new DefaultActionGroup(actions));
        return result2.toArray(AnAction.EMPTY_ARRAY);
    }

    private static <T> void replaceOrAppend(List<T> list2, T from, T to) {
        int index = list2.indexOf(from);
        if (index == -1) {
            index = list2.size();
        }
        list2.remove(from);
        list2.add(index, to);
    }

    private static interface EditorSettingAction {
        public void applyDefaults(@NotNull List<? extends Editor> var1);
    }

    private class EditorHighlightingLayerAction
    extends ActionGroup
    implements EditorSettingAction,
    DumbAware {
        private final AnAction[] myOptions;

        EditorHighlightingLayerAction() {
            super("Highlighting Level", true);
            this.myOptions = (AnAction[])ContainerUtil.map((Object[])HighlightingLevel.values(), level -> new OptionAction((HighlightingLevel)((Object)level)), (Object[])AnAction.EMPTY_ARRAY);
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            return this.myOptions;
        }

        @Override
        public void applyDefaults(@NotNull List<? extends Editor> editors) {
            this.apply(SetEditorSettingsAction.this.myTextSettings.getHighlightingLevel());
        }

        private void apply(@NotNull HighlightingLevel layer) {
            for (Editor editor : SetEditorSettingsAction.this.myEditors) {
                ((EditorImpl)editor).setHighlightingFilter(layer.getCondition());
            }
        }

        private class OptionAction
        extends ToggleAction
        implements DumbAware {
            @NotNull
            private final HighlightingLevel myLayer;

            OptionAction(HighlightingLevel layer) {
                super(layer.getText(), null, layer.getIcon());
                this.myLayer = layer;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                return SetEditorSettingsAction.this.myTextSettings.getHighlightingLevel() == this.myLayer;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                SetEditorSettingsAction.this.myTextSettings.setHighlightingLevel(this.myLayer);
                EditorHighlightingLayerAction.this.apply(this.myLayer);
            }
        }
    }

    private abstract class EditorSettingToggleAction
    extends ToggleAction
    implements DumbAware,
    EditorSettingAction {
        private EditorSettingToggleAction(String actionId) {
            ActionUtil.copyFrom((AnAction)this, (String)actionId);
            this.getTemplatePresentation().setIcon(null);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return this.isSelected();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            this.setSelected(state);
            for (Editor editor : SetEditorSettingsAction.this.myEditors) {
                this.apply(editor, state);
            }
        }

        public abstract boolean isSelected();

        public abstract void setSelected(boolean var1);

        public abstract void apply(@NotNull Editor var1, boolean var2);

        @Override
        public void applyDefaults(@NotNull List<? extends Editor> editors) {
            for (Editor editor : editors) {
                this.apply(editor, this.isSelected());
            }
        }
    }
}

