/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.applications;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.applications.DiffApplicationBase;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffApplication
extends DiffApplicationBase {
    public DiffApplication() {
        super("diff", 2, 3);
    }

    @Override
    @NotNull
    public String getUsageMessage() {
        String scriptName = ApplicationNamesInfo.getInstance().getScriptName();
        return DiffBundle.message((String)"diff.application.usage.parameters.and.description", (Object[])new Object[]{scriptName});
    }

    @Override
    public void processCommand(@NotNull String[] args, @Nullable String currentDirectory) throws Exception {
        ContentDiffRequest request;
        List<String> filePaths = Arrays.asList(args).subList(1, args.length);
        List<VirtualFile> files2 = DiffApplication.findFiles(filePaths, currentDirectory);
        Project project = DiffApplication.guessProject(files2);
        if (files2.size() == 3) {
            files2 = this.replaceNullsWithEmptyFile(files2);
            request = DiffRequestFactory.getInstance().createFromFiles(project, files2.get(0), files2.get(2), files2.get(1));
        } else {
            request = DiffRequestFactory.getInstance().createFromFiles(project, files2.get(0), files2.get(1));
        }
        SimpleDiffRequestChain chain = new SimpleDiffRequestChain((DiffRequest)request);
        chain.putUserData(DiffUserDataKeys.PLACE, (Object)"External");
        DiffDialogHints dialogHints = project != null ? DiffDialogHints.DEFAULT : DiffDialogHints.MODAL;
        DiffManagerEx.getInstance().showDiffBuiltin(project, (DiffRequestChain)chain, dialogHints);
    }
}

