/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.applications;

import com.intellij.openapi.application.ApplicationStarterBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffApplicationBase
extends ApplicationStarterBase {
    protected static final String NULL_PATH = "/dev/null";
    protected static final Logger LOG = Logger.getInstance(DiffApplicationBase.class);

    protected DiffApplicationBase(@NotNull String commandName, int ... possibleArgumentsCount) {
        super(commandName, possibleArgumentsCount);
    }

    @NotNull
    public static List<VirtualFile> findFiles(@NotNull List<String> filePaths, @Nullable String currentDirectory) throws Exception {
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
        for (String path : filePaths) {
            if (NULL_PATH.equals(path)) {
                files2.add(null);
                continue;
            }
            VirtualFile virtualFile = DiffApplicationBase.findFile(path, currentDirectory);
            if (virtualFile == null) {
                throw new Exception("Can't find file: " + path);
            }
            files2.add(virtualFile);
        }
        DiffApplicationBase.refreshAndEnsureFilesValid(ContainerUtil.skipNulls(files2));
        return files2;
    }

    private static void refreshAndEnsureFilesValid(@NotNull List<? extends VirtualFile> files2) throws Exception {
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])VfsUtilCore.toVirtualFileArray(files2));
        for (VirtualFile virtualFile : files2) {
            if (virtualFile.isValid()) continue;
            throw new Exception("Can't find file: " + virtualFile.getPresentableUrl());
        }
    }

    @Nullable
    public static VirtualFile findFile(@NotNull String path, @Nullable String currentDirectory) {
        File file2 = DiffApplicationBase.getFile(path, currentDirectory);
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
        if (virtualFile == null) {
            LOG.warn(String.format("Can't find file: current directory - %s; path - %s", currentDirectory, path));
        }
        return virtualFile;
    }

    @NotNull
    public static File getFile(@NotNull String path, @Nullable String currentDirectory) {
        File file2 = new File(path);
        if (!file2.isAbsolute() && currentDirectory != null) {
            file2 = new File(currentDirectory, path);
        }
        return file2;
    }

    @NotNull
    public List<VirtualFile> replaceNullsWithEmptyFile(@NotNull List<VirtualFile> contents) {
        return ContainerUtil.map(contents, file2 -> (VirtualFile)ObjectUtils.notNull((Object)file2, () -> new LightVirtualFile(NULL_PATH, (FileType)PlainTextFileType.INSTANCE, (CharSequence)"")));
    }

    @Nullable
    protected static Project guessProject(@NotNull List<? extends VirtualFile> files2) {
        Project project2;
        HashSet projects = new HashSet();
        for (VirtualFile virtualFile : files2) {
            projects.addAll(ProjectLocator.getInstance().getProjectsForFile(virtualFile));
        }
        if (projects.isEmpty()) {
            Object[] openProjects = ProjectManager.getInstance().getOpenProjects();
            projects.addAll(ContainerUtil.filter((Object[])openProjects, project -> project.isInitialized() && !project.isDisposed()));
        }
        if (projects.isEmpty()) {
            return null;
        }
        Window recentFocusedWindow = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        if (recentFocusedWindow instanceof IdeFrame && (project2 = ((IdeFrame)recentFocusedWindow).getProject()) != null && projects.contains(project2)) {
            return project2;
        }
        return (Project)projects.iterator().next();
    }
}

