/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.applications;

import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.applications.DiffApplicationBase;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeApplication
extends DiffApplicationBase {
    public MergeApplication() {
        super("merge", 3, 4);
    }

    @Override
    @NotNull
    public String getUsageMessage() {
        String scriptName = ApplicationNamesInfo.getInstance().getScriptName();
        return DiffBundle.message((String)"merge.application.usage.parameters.and.description", (Object[])new Object[]{scriptName});
    }

    @Override
    public void processCommand(@NotNull String[] args, @Nullable String currentDirectory) throws Exception {
        List<String> filePaths = Arrays.asList(args).subList(1, args.length);
        List<VirtualFile> files2 = MergeApplication.findFiles(filePaths, currentDirectory);
        Project project = MergeApplication.guessProject(files2);
        List<VirtualFile> contents = ContainerUtil.list((Object[])new VirtualFile[]{files2.get(0), files2.get(2), files2.get(1)});
        VirtualFile outputFile = files2.get(files2.size() - 1);
        if (outputFile == null) {
            throw new Exception("Can't find output file: " + (String)ContainerUtil.getLastItem(filePaths));
        }
        contents = this.replaceNullsWithEmptyFile(contents);
        MergeRequest request = DiffRequestFactory.getInstance().createMergeRequestFromFiles(project, outputFile, contents, null);
        DiffManagerEx.getInstance().showMergeBuiltin(project, request);
        Document document = FileDocumentManager.getInstance().getCachedDocument(outputFile);
        if (document != null) {
            FileDocumentManager.getInstance().saveDocument(document);
        }
    }
}

