/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.chains;

import com.intellij.diff.chains.DiffRequestChainBase;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.LoadingDiffRequest;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AsyncDiffRequestChain
extends DiffRequestChainBase {
    private static final Logger LOG = Logger.getInstance(AsyncDiffRequestChain.class);
    private final EventDispatcher<Listener> myDispatcher = EventDispatcher.create(Listener.class);
    private List<? extends DiffRequestProducer> myRequests = null;
    @Nullable
    private ProgressIndicator myIndicator;
    private int myAssignments = 0;

    public void addListener(@NotNull Listener listener2, @NotNull Disposable disposable) {
        this.myDispatcher.addListener((EventListener)listener2, disposable);
    }

    @NotNull
    public List<? extends DiffRequestProducer> getRequests() {
        List<? extends DiffRequestProducer> requests = this.myRequests;
        if (requests == null) {
            return Collections.singletonList(new SimpleDiffRequestChain.DiffRequestProducerWrapper((DiffRequest)new LoadingDiffRequest()));
        }
        return requests;
    }

    @NotNull
    public ListSelection<? extends DiffRequestProducer> loadRequestsInBackground() {
        try {
            return this.loadRequestProducers();
        }
        catch (DiffRequestProducerException e) {
            return ListSelection.createSingleton((Object)new SimpleDiffRequestChain.DiffRequestProducerWrapper((DiffRequest)new ErrorDiffRequest((Throwable)e)));
        }
    }

    public void onAssigned(boolean isAssigned) {
        if (isAssigned) {
            if (this.myAssignments == 0 && this.myIndicator == null) {
                this.myIndicator = this.startLoading();
            }
            ++this.myAssignments;
        } else {
            --this.myAssignments;
            if (this.myAssignments == 0 && this.myIndicator != null) {
                this.myIndicator.cancel();
                this.myIndicator = null;
            }
        }
        assert (this.myAssignments >= 0);
    }

    @Nullable
    private ProgressIndicator startLoading() {
        if (this.myRequests != null) {
            return null;
        }
        return BackgroundTaskUtil.executeAndTryWait((Function<? super ProgressIndicator, ? extends Runnable>)((Function)indicator -> {
            ListSelection<? extends DiffRequestProducer> producers = this.loadRequestsInBackground();
            return () -> {
                indicator.checkCanceled();
                if (this.myRequests != null) {
                    LOG.error("Changes are loaded twice");
                    return;
                }
                this.myRequests = producers.getList();
                this.setIndex(producers.getSelectedIndex());
                this.myIndicator = null;
                ((Listener)this.myDispatcher.getMulticaster()).onRequestsLoaded();
            };
        }), null);
    }

    @NotNull
    protected abstract ListSelection<? extends DiffRequestProducer> loadRequestProducers() throws DiffRequestProducerException;

    public static interface Listener
    extends EventListener {
        public void onRequestsLoaded();
    }
}

