/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ChangeCorrector;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ByChar {
    @NotNull
    public static FairDiffIterable compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
        indicator.checkCanceled();
        int[] codePoints1 = ByChar.getAllCodePoints(text1);
        int[] codePoints2 = ByChar.getAllCodePoints(text2);
        FairDiffIterable iterable = DiffIterableUtil.diff(codePoints1, codePoints2, indicator);
        int offset1 = 0;
        int offset2 = 0;
        DiffIterableUtil.ChangeBuilder builder2 = new DiffIterableUtil.ChangeBuilder(text1.length(), text2.length());
        for (Pair<Range, Boolean> pair : DiffIterableUtil.iterateAll(iterable)) {
            Range range2 = (Range)pair.first;
            boolean equals = (Boolean)pair.second;
            int end1 = offset1 + ByChar.countChars(codePoints1, range2.start1, range2.end1);
            int end2 = offset2 + ByChar.countChars(codePoints2, range2.start2, range2.end2);
            if (equals) {
                builder2.markEqual(offset1, offset2, end1, end2);
            }
            offset1 = end1;
            offset2 = end2;
        }
        assert (offset1 == text1.length());
        assert (offset2 == text2.length());
        return DiffIterableUtil.fair(builder2.finish());
    }

    @NotNull
    public static FairDiffIterable compareTwoStep(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
        indicator.checkCanceled();
        CodePointsOffsets codePoints1 = ByChar.getNonSpaceCodePoints(text1);
        CodePointsOffsets codePoints2 = ByChar.getNonSpaceCodePoints(text2);
        FairDiffIterable nonSpaceChanges = DiffIterableUtil.diff(codePoints1.codePoints, codePoints2.codePoints, indicator);
        return ByChar.matchAdjustmentSpaces(codePoints1, codePoints2, text1, text2, nonSpaceChanges, indicator);
    }

    @NotNull
    public static DiffIterable compareTrimWhitespaces(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
        FairDiffIterable iterable = ByChar.compareTwoStep(text1, text2, indicator);
        return new ByWord.TrimSpacesCorrector(iterable, text1, text2, indicator).build();
    }

    @NotNull
    public static DiffIterable compareIgnoreWhitespaces(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
        indicator.checkCanceled();
        CodePointsOffsets codePoints1 = ByChar.getNonSpaceCodePoints(text1);
        CodePointsOffsets codePoints2 = ByChar.getNonSpaceCodePoints(text2);
        FairDiffIterable changes2 = DiffIterableUtil.diff(codePoints1.codePoints, codePoints2.codePoints, indicator);
        return ByChar.matchAdjustmentSpacesIW(codePoints1, codePoints2, text1, text2, changes2);
    }

    @NotNull
    public static FairDiffIterable comparePunctuation(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
        indicator.checkCanceled();
        CodePointsOffsets chars1 = ByChar.getPunctuationChars(text1);
        CodePointsOffsets chars2 = ByChar.getPunctuationChars(text2);
        FairDiffIterable nonSpaceChanges = DiffIterableUtil.diff(chars1.codePoints, chars2.codePoints, indicator);
        return ByChar.transferPunctuation(chars1, chars2, text1, text2, nonSpaceChanges, indicator);
    }

    @NotNull
    private static FairDiffIterable transferPunctuation(@NotNull CodePointsOffsets chars1, @NotNull CodePointsOffsets chars2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable changes2, @NotNull ProgressIndicator indicator) {
        DiffIterableUtil.ChangeBuilder builder2 = new DiffIterableUtil.ChangeBuilder(text1.length(), text2.length());
        for (Range range2 : changes2.iterateUnchanged()) {
            int count = range2.end1 - range2.start1;
            for (int i = 0; i < count; ++i) {
                int offset1 = chars1.offsets[range2.start1 + i];
                int offset2 = chars2.offsets[range2.start2 + i];
                builder2.markEqual(offset1, offset2);
            }
        }
        return DiffIterableUtil.fair(builder2.finish());
    }

    @NotNull
    private static FairDiffIterable matchAdjustmentSpaces(@NotNull CodePointsOffsets codePoints1, @NotNull CodePointsOffsets codePoints2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable changes2, @NotNull ProgressIndicator indicator) {
        return new ChangeCorrector.DefaultCharChangeCorrector(codePoints1, codePoints2, text1, text2, changes2, indicator).build();
    }

    @NotNull
    private static DiffIterable matchAdjustmentSpacesIW(@NotNull CodePointsOffsets codePoints1, @NotNull CodePointsOffsets codePoints2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable changes2) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (Range ch : changes2.iterateChanges()) {
            int startOffset2;
            int endOffset2;
            int startOffset1;
            int endOffset1;
            if (ch.start1 == ch.end1) {
                startOffset1 = endOffset1 = ByChar.expandForwardW(codePoints1, codePoints2, text1, text2, ch, true);
            } else {
                startOffset1 = codePoints1.charOffset(ch.start1);
                endOffset1 = codePoints1.charOffsetAfter(ch.end1 - 1);
            }
            if (ch.start2 == ch.end2) {
                startOffset2 = endOffset2 = ByChar.expandForwardW(codePoints1, codePoints2, text1, text2, ch, false);
            } else {
                startOffset2 = codePoints2.charOffset(ch.start2);
                endOffset2 = codePoints2.charOffsetAfter(ch.end2 - 1);
            }
            ranges.add(new Range(startOffset1, endOffset1, startOffset2, endOffset2));
        }
        return DiffIterableUtil.create(ranges, text1.length(), text2.length());
    }

    private static int expandForwardW(@NotNull CodePointsOffsets codePoints1, @NotNull CodePointsOffsets codePoints2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull Range ch, boolean left) {
        int offset1 = ch.start1 == 0 ? 0 : codePoints1.charOffsetAfter(ch.start1 - 1);
        int offset2 = ch.start2 == 0 ? 0 : codePoints2.charOffsetAfter(ch.start2 - 1);
        int start2 = left ? offset1 : offset2;
        return start2 + TrimUtil.expandWhitespacesForward(text1, text2, offset1, offset2, text1.length(), text2.length());
    }

    @NotNull
    private static int[] getAllCodePoints(@NotNull CharSequence text) {
        int charCount;
        TIntArrayList list2 = new TIntArrayList(text.length());
        int len = text.length();
        for (int offset = 0; offset < len; offset += charCount) {
            int ch = Character.codePointAt(text, offset);
            charCount = Character.charCount(ch);
            list2.add(ch);
        }
        return list2.toNativeArray();
    }

    @NotNull
    private static CodePointsOffsets getNonSpaceCodePoints(@NotNull CharSequence text) {
        int charCount;
        TIntArrayList codePoints = new TIntArrayList(text.length());
        TIntArrayList offsets = new TIntArrayList(text.length());
        int len = text.length();
        for (int offset = 0; offset < len; offset += charCount) {
            int ch = Character.codePointAt(text, offset);
            charCount = Character.charCount(ch);
            if (TrimUtil.isWhiteSpaceCodePoint(ch)) continue;
            codePoints.add(ch);
            offsets.add(offset);
        }
        return new CodePointsOffsets(codePoints.toNativeArray(), offsets.toNativeArray());
    }

    @NotNull
    private static CodePointsOffsets getPunctuationChars(@NotNull CharSequence text) {
        TIntArrayList codePoints = new TIntArrayList(text.length());
        TIntArrayList offsets = new TIntArrayList(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!TrimUtil.isPunctuation(c)) continue;
            codePoints.add((int)c);
            offsets.add(i);
        }
        return new CodePointsOffsets(codePoints.toNativeArray(), offsets.toNativeArray());
    }

    private static int countChars(int[] codePoints, int start2, int end) {
        int count = 0;
        for (int i = start2; i < end; ++i) {
            count += Character.charCount(codePoints[i]);
        }
        return count;
    }

    static class CodePointsOffsets {
        public final int[] codePoints;
        public final int[] offsets;

        CodePointsOffsets(int[] codePoints, int[] offsets) {
            this.codePoints = codePoints;
            this.offsets = offsets;
        }

        public int charOffset(int index) {
            return this.offsets[index];
        }

        public int charOffsetAfter(int index) {
            return this.offsets[index] + Character.charCount(this.codePoints[index]);
        }
    }
}

