/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ChangeCorrector;
import com.intellij.diff.comparison.ChunkOptimizer;
import com.intellij.diff.comparison.ComparisonMergeUtil;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ByLine {
    @NotNull
    public static FairDiffIterable compare(@NotNull List<? extends CharSequence> lines1, @NotNull List<? extends CharSequence> lines2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        indicator.checkCanceled();
        return ByLine.doCompare(ByLine.getLines(lines1, policy), ByLine.getLines(lines2, policy), policy, indicator);
    }

    @NotNull
    public static List<MergeRange> compare(@NotNull List<? extends CharSequence> lines1, @NotNull List<? extends CharSequence> lines2, @NotNull List<? extends CharSequence> lines3, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        indicator.checkCanceled();
        return ByLine.doCompare(ByLine.getLines(lines1, policy), ByLine.getLines(lines2, policy), ByLine.getLines(lines3, policy), policy, indicator, false);
    }

    @NotNull
    public static List<MergeRange> merge(@NotNull List<? extends CharSequence> lines1, @NotNull List<? extends CharSequence> lines2, @NotNull List<? extends CharSequence> lines3, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        indicator.checkCanceled();
        return ByLine.doCompare(ByLine.getLines(lines1, policy), ByLine.getLines(lines2, policy), ByLine.getLines(lines3, policy), policy, indicator, true);
    }

    @NotNull
    static FairDiffIterable doCompare(@NotNull List<? extends Line> lines1, @NotNull List<? extends Line> lines2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        indicator.checkCanceled();
        if (policy == ComparisonPolicy.IGNORE_WHITESPACES) {
            FairDiffIterable changes2 = ByLine.compareSmart(lines1, lines2, indicator);
            changes2 = ByLine.optimizeLineChunks(lines1, lines2, changes2, indicator);
            return ByLine.expandRanges(lines1, lines2, changes2);
        }
        List<Line> iwLines1 = ByLine.convertMode(lines1, ComparisonPolicy.IGNORE_WHITESPACES);
        List<Line> iwLines2 = ByLine.convertMode(lines2, ComparisonPolicy.IGNORE_WHITESPACES);
        FairDiffIterable iwChanges = ByLine.compareSmart(iwLines1, iwLines2, indicator);
        iwChanges = ByLine.optimizeLineChunks(lines1, lines2, iwChanges, indicator);
        return ByLine.correctChangesSecondStep(lines1, lines2, iwChanges);
    }

    @NotNull
    static List<MergeRange> doCompare(@NotNull List<? extends Line> lines1, @NotNull List<? extends Line> lines2, @NotNull List<? extends Line> lines3, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator, boolean keepIgnoredChanges) {
        indicator.checkCanceled();
        List<Line> iwLines1 = ByLine.convertMode(lines1, ComparisonPolicy.IGNORE_WHITESPACES);
        List<Line> iwLines2 = ByLine.convertMode(lines2, ComparisonPolicy.IGNORE_WHITESPACES);
        List<Line> iwLines3 = ByLine.convertMode(lines3, ComparisonPolicy.IGNORE_WHITESPACES);
        FairDiffIterable iwChanges1 = ByLine.compareSmart(iwLines2, iwLines1, indicator);
        iwChanges1 = ByLine.optimizeLineChunks(lines2, lines1, iwChanges1, indicator);
        FairDiffIterable iterable1 = ByLine.correctChangesSecondStep(lines2, lines1, iwChanges1);
        FairDiffIterable iwChanges2 = ByLine.compareSmart(iwLines2, iwLines3, indicator);
        iwChanges2 = ByLine.optimizeLineChunks(lines2, lines3, iwChanges2, indicator);
        FairDiffIterable iterable2 = ByLine.correctChangesSecondStep(lines2, lines3, iwChanges2);
        if (keepIgnoredChanges && policy != ComparisonPolicy.DEFAULT) {
            return ComparisonMergeUtil.buildMerge(iterable1, iterable2, (index1, index2, index3) -> ByLine.equalsDefaultPolicy(lines1, lines2, lines3, index1, index2, index3), indicator);
        }
        return ComparisonMergeUtil.buildSimple(iterable1, iterable2, indicator);
    }

    private static boolean equalsDefaultPolicy(@NotNull List<? extends Line> lines1, @NotNull List<? extends Line> lines2, @NotNull List<? extends Line> lines3, int index1, int index2, int index3) {
        CharSequence content1 = lines1.get(index1).getContent();
        CharSequence content2 = lines2.get(index2).getContent();
        CharSequence content3 = lines3.get(index3).getContent();
        return StringUtil.equals((CharSequence)content2, (CharSequence)content1) && StringUtil.equals((CharSequence)content2, (CharSequence)content3);
    }

    @NotNull
    private static FairDiffIterable correctChangesSecondStep(final @NotNull List<? extends Line> lines1, final @NotNull List<? extends Line> lines2, final @NotNull FairDiffIterable changes2) {
        final DiffIterableUtil.ExpandChangeBuilder builder2 = new DiffIterableUtil.ExpandChangeBuilder(lines1, lines2);
        new Object(){
            private CharSequence sample = null;
            private int last1 = 0;
            private int last2 = 0;

            public void run() {
                for (Range range2 : changes2.iterateUnchanged()) {
                    int count = range2.end1 - range2.start1;
                    for (int i = 0; i < count; ++i) {
                        int index1 = range2.start1 + i;
                        int index2 = range2.start2 + i;
                        Line line1 = (Line)lines1.get(index1);
                        Line line2 = (Line)lines2.get(index2);
                        if (StringUtil.equalsIgnoreWhitespaces((CharSequence)this.sample, (CharSequence)line1.getContent())) continue;
                        if (line1.equals(line2)) {
                            this.flush(index1, index2);
                            builder2.markEqual(index1, index2);
                            continue;
                        }
                        this.flush(index1, index2);
                        this.sample = line1.getContent();
                    }
                }
                this.flush(changes2.getLength1(), changes2.getLength2());
            }

            private void flush(int line1, int line2) {
                int i;
                if (this.sample == null) {
                    return;
                }
                int start1 = Math.max(this.last1, builder2.getIndex1());
                int start2 = Math.max(this.last2, builder2.getIndex2());
                TIntArrayList subLines1 = new TIntArrayList();
                TIntArrayList subLines2 = new TIntArrayList();
                for (i = start1; i < line1; ++i) {
                    if (!StringUtil.equalsIgnoreWhitespaces((CharSequence)this.sample, (CharSequence)((Line)lines1.get(i)).getContent())) continue;
                    subLines1.add(i);
                    this.last1 = i + 1;
                }
                for (i = start2; i < line2; ++i) {
                    if (!StringUtil.equalsIgnoreWhitespaces((CharSequence)this.sample, (CharSequence)((Line)lines2.get(i)).getContent())) continue;
                    subLines2.add(i);
                    this.last2 = i + 1;
                }
                assert (subLines1.size() > 0 && subLines2.size() > 0);
                this.alignExactMatching(subLines1, subLines2);
                this.sample = null;
            }

            private void alignExactMatching(TIntArrayList subLines1, TIntArrayList subLines2) {
                boolean skipAligning;
                int n = Math.max(subLines1.size(), subLines2.size());
                boolean bl = skipAligning = n > 10 || subLines1.size() == subLines2.size();
                if (skipAligning) {
                    int count = Math.min(subLines1.size(), subLines2.size());
                    for (int i = 0; i < count; ++i) {
                        int index1 = subLines1.get(i);
                        int index2 = subLines2.get(i);
                        if (!((Line)lines1.get(index1)).equals(lines2.get(index2))) continue;
                        builder2.markEqual(index1, index2);
                    }
                    return;
                }
                if (subLines1.size() < subLines2.size()) {
                    int[] matching = ByLine.getBestMatchingAlignment(subLines1, subLines2, lines1, lines2);
                    for (int i = 0; i < subLines1.size(); ++i) {
                        int index1 = subLines1.get(i);
                        int index2 = subLines2.get(matching[i]);
                        if (!((Line)lines1.get(index1)).equals(lines2.get(index2))) continue;
                        builder2.markEqual(index1, index2);
                    }
                } else {
                    int[] matching = ByLine.getBestMatchingAlignment(subLines2, subLines1, lines2, lines1);
                    for (int i = 0; i < subLines2.size(); ++i) {
                        int index1 = subLines1.get(matching[i]);
                        int index2 = subLines2.get(i);
                        if (!((Line)lines1.get(index1)).equals(lines2.get(index2))) continue;
                        builder2.markEqual(index1, index2);
                    }
                }
            }
        }.run();
        return DiffIterableUtil.fair(builder2.finish());
    }

    @NotNull
    private static int[] getBestMatchingAlignment(final @NotNull TIntArrayList subLines1, final @NotNull TIntArrayList subLines2, final @NotNull List<? extends Line> lines1, final @NotNull List<? extends Line> lines2) {
        assert (subLines1.size() < subLines2.size());
        final int size = subLines1.size();
        final int[] comb = new int[size];
        final int[] best = new int[size];
        for (int i = 0; i < size; ++i) {
            best[i] = i;
        }
        new Object(){
            int bestWeight = 0;

            public void run() {
                this.combinations(0, subLines2.size() - 1, 0);
            }

            private void combinations(int start2, int n, int k) {
                if (k == size) {
                    this.processCombination();
                    return;
                }
                for (int i = start2; i <= n; ++i) {
                    comb[k] = i;
                    this.combinations(i + 1, n, k + 1);
                }
            }

            private void processCombination() {
                int weight2 = 0;
                for (int i = 0; i < size; ++i) {
                    int index1 = subLines1.get(i);
                    int index2 = subLines2.get(comb[i]);
                    if (!((Line)lines1.get(index1)).equals(lines2.get(index2))) continue;
                    ++weight2;
                }
                if (weight2 > this.bestWeight) {
                    this.bestWeight = weight2;
                    System.arraycopy(comb, 0, best, 0, comb.length);
                }
            }
        }.run();
        return best;
    }

    @NotNull
    private static FairDiffIterable optimizeLineChunks(@NotNull List<? extends Line> lines1, @NotNull List<? extends Line> lines2, @NotNull FairDiffIterable iterable, @NotNull ProgressIndicator indicator) {
        return new ChunkOptimizer.LineChunkOptimizer(lines1, lines2, iterable, indicator).build();
    }

    @NotNull
    private static FairDiffIterable compareSmart(@NotNull List<? extends Line> lines1, @NotNull List<? extends Line> lines2, @NotNull ProgressIndicator indicator) {
        int threshold = ComparisonUtil.getUnimportantLineCharCount();
        if (threshold == 0) {
            return DiffIterableUtil.diff(lines1, lines2, indicator);
        }
        Pair<List<Line>, TIntArrayList> bigLines1 = ByLine.getBigLines(lines1, threshold);
        Pair<List<Line>, TIntArrayList> bigLines2 = ByLine.getBigLines(lines2, threshold);
        FairDiffIterable changes2 = DiffIterableUtil.diff((List)bigLines1.first, (List)bigLines2.first, indicator);
        return new ChangeCorrector.SmartLineChangeCorrector((TIntArrayList)bigLines1.second, (TIntArrayList)bigLines2.second, lines1, lines2, changes2, indicator).build();
    }

    @NotNull
    private static Pair<List<Line>, TIntArrayList> getBigLines(@NotNull List<? extends Line> lines2, int threshold) {
        ArrayList<Line> bigLines = new ArrayList<Line>(lines2.size());
        TIntArrayList indexes = new TIntArrayList(lines2.size());
        for (int i = 0; i < lines2.size(); ++i) {
            Line line = lines2.get(i);
            if (line.getNonSpaceChars() <= threshold) continue;
            bigLines.add(line);
            indexes.add(i);
        }
        return Pair.create(bigLines, (Object)indexes);
    }

    @NotNull
    private static FairDiffIterable expandRanges(@NotNull List<? extends Line> lines1, @NotNull List<? extends Line> lines2, @NotNull FairDiffIterable iterable) {
        ArrayList<Range> changes2 = new ArrayList<Range>();
        for (Range ch : iterable.iterateChanges()) {
            Range expanded = TrimUtil.expand(lines1, lines2, ch.start1, ch.start2, ch.end1, ch.end2);
            if (expanded.isEmpty()) continue;
            changes2.add(expanded);
        }
        return DiffIterableUtil.fair(DiffIterableUtil.create(changes2, lines1.size(), lines2.size()));
    }

    @NotNull
    private static List<Line> getLines(@NotNull List<? extends CharSequence> text, @NotNull ComparisonPolicy policy) {
        return ContainerUtil.map(text, line -> new Line((CharSequence)line, policy));
    }

    @NotNull
    private static List<Line> convertMode(@NotNull List<? extends Line> original, @NotNull ComparisonPolicy policy) {
        ArrayList<Line> result2 = new ArrayList<Line>(original.size());
        for (Line line : original) {
            Line newLine = line.myPolicy != policy ? new Line(line.getContent(), policy) : line;
            result2.add(newLine);
        }
        return result2;
    }

    static class Line {
        @NotNull
        private final CharSequence myText;
        @NotNull
        private final ComparisonPolicy myPolicy;
        private final int myHash;
        private final int myNonSpaceChars;

        Line(@NotNull CharSequence text, @NotNull ComparisonPolicy policy) {
            this.myText = text;
            this.myPolicy = policy;
            this.myHash = Line.hashCode(text, policy);
            this.myNonSpaceChars = Line.countNonSpaceChars(text);
        }

        @NotNull
        public CharSequence getContent() {
            return this.myText;
        }

        public int getNonSpaceChars() {
            return this.myNonSpaceChars;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Line line = (Line)o;
            assert (this.myPolicy == line.myPolicy);
            if (this.hashCode() != line.hashCode()) {
                return false;
            }
            return Line.equals(this.getContent(), line.getContent(), this.myPolicy);
        }

        public int hashCode() {
            return this.myHash;
        }

        private static int countNonSpaceChars(@NotNull CharSequence text) {
            int nonSpace = 0;
            int len = text.length();
            for (int offset = 0; offset < len; ++offset) {
                char c = text.charAt(offset);
                if (StringUtil.isWhiteSpace((char)c)) continue;
                ++nonSpace;
            }
            return nonSpace;
        }

        private static boolean equals(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy) {
            switch (policy) {
                case DEFAULT: {
                    return StringUtil.equals((CharSequence)text1, (CharSequence)text2);
                }
                case TRIM_WHITESPACES: {
                    return StringUtil.equalsTrimWhitespaces((CharSequence)text1, (CharSequence)text2);
                }
                case IGNORE_WHITESPACES: {
                    return StringUtil.equalsIgnoreWhitespaces((CharSequence)text1, (CharSequence)text2);
                }
            }
            throw new IllegalArgumentException(policy.toString());
        }

        private static int hashCode(@NotNull CharSequence text, @NotNull ComparisonPolicy policy) {
            switch (policy) {
                case DEFAULT: {
                    return StringUtil.stringHashCode((CharSequence)text);
                }
                case TRIM_WHITESPACES: {
                    int offset1 = TrimUtil.trimStart(text, 0, text.length());
                    int offset2 = TrimUtil.trimEnd(text, offset1, text.length());
                    return StringUtil.stringHashCode((CharSequence)text, (int)offset1, (int)offset2);
                }
                case IGNORE_WHITESPACES: {
                    return StringUtil.stringHashCodeIgnoreWhitespaces((CharSequence)text);
                }
            }
            throw new IllegalArgumentException(policy.name());
        }
    }
}

